/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import org.apache.flink.sql.parser.dql.SqlShowProcedures;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ShowProceduresOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlShowProcedureConverter
implements SqlNodeConverter<SqlShowProcedures> {
    @Override
    public Operation convertSqlNode(SqlShowProcedures sqlShowProcedures, SqlNodeConverter.ConvertContext context) {
        if (sqlShowProcedures.getPreposition() == null) {
            return new ShowProceduresOperation(sqlShowProcedures.isNotLike(), sqlShowProcedures.getLikeType(), sqlShowProcedures.getLikeSqlPattern());
        }
        CharSequence[] fullDatabaseName = sqlShowProcedures.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new ValidationException(String.format("Show procedures from/in identifier [ %s ] format error, it should be [catalog_name.]database_name.", String.join((CharSequence)".", fullDatabaseName)));
        }
        CatalogManager catalogManager = context.getCatalogManager();
        CharSequence catalogName = fullDatabaseName.length == 1 ? catalogManager.getCurrentCatalog() : fullDatabaseName[0];
        CharSequence databaseName = fullDatabaseName.length == 1 ? fullDatabaseName[0] : fullDatabaseName[1];
        return new ShowProceduresOperation(sqlShowProcedures.getPreposition(), catalogName, (String)databaseName, sqlShowProcedures.isNotLike(), sqlShowProcedures.getLikeType(), sqlShowProcedures.getLikeSqlPattern());
    }
}

