/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.bridging;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlTableFunction;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.RexFactory;
import org.apache.flink.table.planner.functions.bridging.BridgingUtils;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.util.Preconditions;

@Internal
public class BridgingSqlFunction
extends SqlFunction {
    private final DataTypeFactory dataTypeFactory;
    private final FlinkTypeFactory typeFactory;
    private final RexFactory rexFactory;
    private final ContextResolvedFunction resolvedFunction;
    private final TypeInference typeInference;

    private BridgingSqlFunction(DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, RexFactory rexFactory, SqlKind kind, ContextResolvedFunction resolvedFunction, TypeInference typeInference) {
        super(BridgingUtils.createName(resolvedFunction), BridgingUtils.createSqlIdentifier(resolvedFunction), kind, BridgingUtils.createSqlReturnTypeInference(dataTypeFactory, resolvedFunction.getDefinition(), typeInference), BridgingUtils.createSqlOperandTypeInference(dataTypeFactory, resolvedFunction.getDefinition(), typeInference), BridgingUtils.createSqlOperandTypeChecker(dataTypeFactory, resolvedFunction.getDefinition(), typeInference), BridgingUtils.createParamTypes(typeFactory, typeInference), BridgingUtils.createSqlFunctionCategory(resolvedFunction));
        this.dataTypeFactory = dataTypeFactory;
        this.typeFactory = typeFactory;
        this.rexFactory = rexFactory;
        this.resolvedFunction = resolvedFunction;
        this.typeInference = typeInference;
    }

    public static BridgingSqlFunction of(DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, RexFactory rexFactory, SqlKind kind, ContextResolvedFunction resolvedFunction, TypeInference typeInference) {
        FunctionKind functionKind = resolvedFunction.getDefinition().getKind();
        Preconditions.checkState((functionKind == FunctionKind.SCALAR || functionKind == FunctionKind.TABLE ? 1 : 0) != 0, (Object)"Scalar or table function kind expected.");
        if (functionKind == FunctionKind.TABLE) {
            return new WithTableFunction(dataTypeFactory, typeFactory, rexFactory, kind, resolvedFunction, typeInference);
        }
        return new BridgingSqlFunction(dataTypeFactory, typeFactory, rexFactory, kind, resolvedFunction, typeInference);
    }

    public static BridgingSqlFunction of(FlinkContext context, FlinkTypeFactory typeFactory, ContextResolvedFunction resolvedFunction) {
        DataTypeFactory dataTypeFactory = context.getCatalogManager().getDataTypeFactory();
        TypeInference typeInference = resolvedFunction.getDefinition().getTypeInference(dataTypeFactory);
        return BridgingSqlFunction.of(dataTypeFactory, typeFactory, context.getRexFactory(), SqlKind.OTHER_FUNCTION, resolvedFunction, typeInference);
    }

    public static BridgingSqlFunction of(RelOptCluster cluster, ContextResolvedFunction resolvedFunction) {
        FlinkContext context = ShortcutUtils.unwrapContext(cluster);
        FlinkTypeFactory typeFactory = ShortcutUtils.unwrapTypeFactory(cluster);
        return BridgingSqlFunction.of(context, typeFactory, resolvedFunction);
    }

    public static BridgingSqlFunction of(RelOptCluster cluster, BuiltInFunctionDefinition functionDefinition) {
        return BridgingSqlFunction.of(cluster, ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((String)functionDefinition.getName()), (FunctionDefinition)functionDefinition));
    }

    public DataTypeFactory getDataTypeFactory() {
        return this.dataTypeFactory;
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public RexFactory getRexFactory() {
        return this.rexFactory;
    }

    public ContextResolvedFunction getResolvedFunction() {
        return this.resolvedFunction;
    }

    public FunctionDefinition getDefinition() {
        return this.resolvedFunction.getDefinition();
    }

    public TypeInference getTypeInference() {
        return this.typeInference;
    }

    @Override
    public List<String> getParamNames() {
        if (this.typeInference.getNamedArguments().isPresent()) {
            return (List)this.typeInference.getNamedArguments().get();
        }
        return super.getParamNames();
    }

    @Override
    public boolean isDeterministic() {
        return this.resolvedFunction.getDefinition().isDeterministic();
    }

    public static class WithTableFunction
    extends BridgingSqlFunction
    implements SqlTableFunction {
        private WithTableFunction(DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, RexFactory rexFactory, SqlKind kind, ContextResolvedFunction resolvedFunction, TypeInference typeInference) {
            super(dataTypeFactory, typeFactory, rexFactory, kind, resolvedFunction, typeInference);
        }

        @Override
        public SqlReturnTypeInference getRowTypeInference() {
            return this.getReturnTypeInference();
        }
    }
}

