/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSnapshot;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindowTableFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.IdentifierNamespace;
import org.apache.calcite.sql.validate.IdentifierSnapshotNamespace;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.annotation.Internal;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.calcite.TimestampSchemaVersion;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.util.Preconditions;

@Internal
public final class FlinkCalciteSqlValidator
extends SqlValidatorImpl {
    private SqlNode sqlNodeForExpectedOutputType;
    private RelDataType expectedOutputType;
    private final RelOptCluster relOptCluster;
    private final RelOptTable.ToRelContext toRelContext;
    private final FrameworkConfig frameworkConfig;

    public FlinkCalciteSqlValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlValidator.Config config, RelOptTable.ToRelContext toRelcontext, RelOptCluster relOptCluster, FrameworkConfig frameworkConfig) {
        super(opTab, catalogReader, typeFactory, config);
        this.relOptCluster = relOptCluster;
        this.toRelContext = toRelcontext;
        this.frameworkConfig = frameworkConfig;
    }

    public void setExpectedOutputType(SqlNode sqlNode, RelDataType expectedOutputType) {
        this.sqlNodeForExpectedOutputType = sqlNode;
        this.expectedOutputType = expectedOutputType;
    }

    public Optional<RelDataType> getExpectedOutputType(SqlNode sqlNode) {
        if (sqlNode == this.sqlNodeForExpectedOutputType) {
            return Optional.of(this.expectedOutputType);
        }
        return Optional.empty();
    }

    @Override
    public void validateLiteral(SqlLiteral literal) {
        BigDecimal decimal;
        if (literal.getTypeName() == SqlTypeName.DECIMAL && (decimal = literal.getValueAs(BigDecimal.class)).precision() > 38) {
            throw this.newValidationError(literal, Static.RESOURCE.numberLiteralOutOfRange(decimal.toString()));
        }
        super.validateLiteral(literal);
    }

    @Override
    protected void validateJoin(SqlJoin join, SqlValidatorScope scope) {
        if (join.getJoinType() == JoinType.LEFT && SqlUtil.stripAs(join.getRight()).getKind() == SqlKind.COLLECTION_TABLE) {
            SqlBasicCall call;
            Object operand0;
            SqlNode right = SqlUtil.stripAs(join.getRight());
            if (right instanceof SqlBasicCall && (operand0 = (call = (SqlBasicCall)right).operand(0)) instanceof SqlBasicCall && ((SqlBasicCall)operand0).getOperator() instanceof SqlWindowTableFunction) {
                return;
            }
            SqlNode condition = join.getCondition();
            if (!(condition == null || SqlUtil.isLiteral(condition) && ((SqlLiteral)condition).getValueAs(Boolean.class) == Boolean.TRUE)) {
                throw new ValidationException(String.format("Left outer joins with a table function do not accept a predicate such as %s. Only literal TRUE is accepted.", condition));
            }
        }
        super.validateJoin(join, scope);
    }

    @Override
    public void validateColumnListParams(SqlFunction function, List<RelDataType> argTypes, List<SqlNode> operands) {
    }

    @Override
    protected void registerNamespace(@Nullable SqlValidatorScope usingScope, @Nullable String alias, SqlValidatorNamespace ns, boolean forceNullable) {
        Optional<SqlSnapshot> snapshot = this.getSnapShotNode(ns);
        if (usingScope != null && snapshot.isPresent() && !(snapshot.get().getPeriod() instanceof SqlIdentifier)) {
            SqlSnapshot sqlSnapshot = snapshot.get();
            SqlNode periodNode = sqlSnapshot.getPeriod();
            SqlToRelConverter sqlToRelConverter = this.createSqlToRelConverter();
            RexNode rexNode = sqlToRelConverter.convertExpression(periodNode);
            RexNode simplifiedRexNode = FlinkRexUtil.simplify(sqlToRelConverter.getRexBuilder(), rexNode, this.relOptCluster.getPlanner().getExecutor());
            ArrayList<RexNode> reducedNodes = new ArrayList<RexNode>();
            this.relOptCluster.getPlanner().getExecutor().reduce(this.relOptCluster.getRexBuilder(), Collections.singletonList(simplifiedRexNode), reducedNodes);
            if (!(reducedNodes.get(0) instanceof RexLiteral)) {
                throw new UnsupportedOperationException(String.format("Unsupported time travel expression: %s for the expression can not be reduced to a constant by Flink.", periodNode));
            }
            RexLiteral rexLiteral = (RexLiteral)reducedNodes.get(0);
            TimestampString timestampString = rexLiteral.getValueAs(TimestampString.class);
            Preconditions.checkNotNull((Object)timestampString, (String)"The time travel expression %s can not reduce to a valid timestamp string. This is a bug. Please file an issue.", (Object[])new Object[]{periodNode});
            TableConfig tableConfig = ShortcutUtils.unwrapContext(this.relOptCluster).getTableConfig();
            ZoneId zoneId = tableConfig.getLocalTimeZone();
            long timeTravelTimestamp = TimestampData.fromEpochMillis((long)timestampString.getMillisSinceEpoch()).toLocalDateTime().atZone(zoneId).toInstant().toEpochMilli();
            SchemaVersion schemaVersion = TimestampSchemaVersion.of(timeTravelTimestamp);
            IdentifierNamespace identifierNamespace = (IdentifierNamespace)ns;
            ns = new IdentifierSnapshotNamespace(identifierNamespace, schemaVersion, ((DelegatingScope)usingScope).getParent());
            sqlSnapshot.setOperand(1, SqlLiteral.createTimestamp(timestampString, rexLiteral.getType().getPrecision(), sqlSnapshot.getPeriod().getParserPosition()));
        }
        super.registerNamespace(usingScope, alias, ns, forceNullable);
    }

    private Optional<SqlSnapshot> getSnapShotNode(SqlValidatorNamespace ns) {
        if (ns instanceof IdentifierNamespace) {
            SqlNode enclosingNode = ns.getEnclosingNode();
            if (enclosingNode instanceof SqlSnapshot) {
                return Optional.of((SqlSnapshot)enclosingNode);
            }
            if (enclosingNode instanceof SqlBasicCall && ((SqlBasicCall)enclosingNode).getOperator() instanceof SqlAsOperator && ((SqlBasicCall)enclosingNode).getOperandList().get(0) instanceof SqlSnapshot) {
                return Optional.of((SqlSnapshot)((SqlBasicCall)enclosingNode).getOperandList().get(0));
            }
        }
        return Optional.empty();
    }

    private SqlToRelConverter createSqlToRelConverter() {
        return new SqlToRelConverter((RelOptTable.ViewExpander)this.toRelContext, (SqlValidator)this, (Prepare.CatalogReader)this.getCatalogReader().unwrap(CalciteCatalogReader.class), this.relOptCluster, this.frameworkConfig.getConvertletTable(), this.frameworkConfig.getSqlToRelConverterConfig());
    }
}

