/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CalcCodeGenerator;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public abstract class CommonExecCalc
extends ExecNodeBase<RowData>
implements SingleTransformationTranslator<RowData> {
    public static final String CALC_TRANSFORMATION = "calc";
    public static final String FIELD_NAME_PROJECTION = "projection";
    public static final String FIELD_NAME_CONDITION = "condition";
    @JsonProperty(value="projection")
    private final List<RexNode> projection;
    @JsonProperty(value="condition")
    @Nullable
    private final RexNode condition;
    private final Class<?> operatorBaseClass;
    private final boolean retainHeader;

    protected CommonExecCalc(int id, ExecNodeContext context, ReadableConfig persistedConfig, List<RexNode> projection, @Nullable RexNode condition, Class<?> operatorBaseClass, boolean retainHeader, List<InputProperty> inputProperties, RowType outputType, String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.projection = (List)Preconditions.checkNotNull(projection);
        this.condition = condition;
        this.operatorBaseClass = (Class)Preconditions.checkNotNull(operatorBaseClass);
        this.retainHeader = retainHeader;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        CodeGeneratorContext ctx = new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader()).setOperatorBaseClass(this.operatorBaseClass);
        CodeGenOperatorFactory<RowData> substituteStreamOperator = CalcCodeGenerator.generateCalcOperator(ctx, inputTransform, (RowType)this.getOutputType(), JavaScalaConversionUtil.toScala(this.projection), JavaScalaConversionUtil.toScala(Optional.ofNullable(this.condition)), this.retainHeader, this.getClass().getSimpleName());
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(CALC_TRANSFORMATION, config), substituteStreamOperator, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism(), false);
    }
}

