/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.sink;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.connector.RowLevelModificationScanContext;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelUpdate;
import org.apache.flink.table.planner.plan.abilities.sink.SinkAbilitySpec;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="RowLevelUpdate")
public class RowLevelUpdateSpec
implements SinkAbilitySpec {
    public static final String FIELD_NAME_UPDATED_COLUMNS = "updatedColumns";
    public static final String FIELD_NAME_ROW_LEVEL_UPDATE_MODE = "rowLevelUpdateMode";
    @JsonProperty(value="updatedColumns")
    @Nonnull
    private final List<Column> updatedColumns;
    @JsonProperty(value="rowLevelUpdateMode")
    @Nonnull
    private final SupportsRowLevelUpdate.RowLevelUpdateMode rowLevelUpdateMode;
    @JsonIgnore
    @Nullable
    private final RowLevelModificationScanContext scanContext;

    @JsonCreator
    public RowLevelUpdateSpec(@JsonProperty(value="updatedColumns") @Nonnull List<Column> updatedColumns, @JsonProperty(value="rowLevelUpdateMode") @Nonnull SupportsRowLevelUpdate.RowLevelUpdateMode rowLevelUpdateMode, @Nullable RowLevelModificationScanContext scanContext) {
        this.updatedColumns = updatedColumns;
        this.rowLevelUpdateMode = rowLevelUpdateMode;
        this.scanContext = scanContext;
    }

    @Override
    public void apply(DynamicTableSink tableSink) {
        if (!(tableSink instanceof SupportsRowLevelUpdate)) {
            throw new TableException(String.format("%s does not support SupportsRowLevelUpdate.", tableSink.getClass().getName()));
        }
        ((SupportsRowLevelUpdate)tableSink).applyRowLevelUpdate(this.updatedColumns, this.scanContext);
    }

    @Nonnull
    public SupportsRowLevelUpdate.RowLevelUpdateMode getRowLevelUpdateMode() {
        return this.rowLevelUpdateMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowLevelUpdateSpec that = (RowLevelUpdateSpec)o;
        return Objects.equals(this.updatedColumns, that.updatedColumns) && this.rowLevelUpdateMode == that.rowLevelUpdateMode && Objects.equals(this.scanContext, that.scanContext);
    }

    public int hashCode() {
        return Objects.hash(this.updatedColumns, this.rowLevelUpdateMode, this.scanContext);
    }
}

