/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.sink;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.RowLevelModificationScanContext;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelDelete;
import org.apache.flink.table.planner.plan.abilities.sink.SinkAbilitySpec;
import org.apache.flink.util.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="RowLevelDelete")
public class RowLevelDeleteSpec
implements SinkAbilitySpec {
    public static final String FIELD_NAME_ROW_LEVEL_DELETE_MODE = "rowLevelDeleteMode";
    @JsonProperty(value="rowLevelDeleteMode")
    @Nonnull
    private final SupportsRowLevelDelete.RowLevelDeleteMode rowLevelDeleteMode;
    @JsonIgnore
    @Nullable
    private final RowLevelModificationScanContext scanContext;

    @JsonCreator
    public RowLevelDeleteSpec(@JsonProperty(value="rowLevelDeleteMode") @Nonnull SupportsRowLevelDelete.RowLevelDeleteMode rowLevelDeleteMode, @Nullable RowLevelModificationScanContext scanContext) {
        this.rowLevelDeleteMode = (SupportsRowLevelDelete.RowLevelDeleteMode)Preconditions.checkNotNull((Object)rowLevelDeleteMode);
        this.scanContext = scanContext;
    }

    @Override
    public void apply(DynamicTableSink tableSink) {
        if (!(tableSink instanceof SupportsRowLevelDelete)) {
            throw new TableException(String.format("%s does not support SupportsRowLevelDelete.", tableSink.getClass().getName()));
        }
        ((SupportsRowLevelDelete)tableSink).applyRowLevelDelete(this.scanContext);
    }

    @Nonnull
    public SupportsRowLevelDelete.RowLevelDeleteMode getRowLevelDeleteMode() {
        return this.rowLevelDeleteMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowLevelDeleteSpec that = (RowLevelDeleteSpec)o;
        return this.rowLevelDeleteMode == that.rowLevelDeleteMode && Objects.equals(this.scanContext, that.scanContext);
    }

    public int hashCode() {
        return Objects.hash(this.rowLevelDeleteMode, this.scanContext);
    }
}

