/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.ArrayImpl;
import org.apache.calcite.runtime.Geometries;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class JavaToSqlTypeConversionRules {
    private static final JavaToSqlTypeConversionRules INSTANCE = new JavaToSqlTypeConversionRules();
    private final Map<Class<?>, SqlTypeName> rules = ImmutableMap.builder().put(Integer.class, SqlTypeName.INTEGER).put(Integer.TYPE, SqlTypeName.INTEGER).put(Long.class, SqlTypeName.BIGINT).put(Long.TYPE, SqlTypeName.BIGINT).put(Short.class, SqlTypeName.SMALLINT).put(Short.TYPE, SqlTypeName.SMALLINT).put(Byte.TYPE, SqlTypeName.TINYINT).put(Byte.class, SqlTypeName.TINYINT).put(Float.class, SqlTypeName.REAL).put(Float.TYPE, SqlTypeName.REAL).put(Double.class, SqlTypeName.DOUBLE).put(Double.TYPE, SqlTypeName.DOUBLE).put(Boolean.TYPE, SqlTypeName.BOOLEAN).put(Boolean.class, SqlTypeName.BOOLEAN).put(byte[].class, SqlTypeName.VARBINARY).put(String.class, SqlTypeName.VARCHAR).put(char[].class, SqlTypeName.VARCHAR).put(Character.class, SqlTypeName.CHAR).put(Character.TYPE, SqlTypeName.CHAR).put(java.util.Date.class, SqlTypeName.TIMESTAMP).put(Date.class, SqlTypeName.DATE).put(Timestamp.class, SqlTypeName.TIMESTAMP).put(Time.class, SqlTypeName.TIME).put(BigDecimal.class, SqlTypeName.DECIMAL).put(Geometries.Geom.class, SqlTypeName.GEOMETRY).put(ResultSet.class, SqlTypeName.CURSOR).put(ColumnList.class, SqlTypeName.COLUMN_LIST).put(ArrayImpl.class, SqlTypeName.ARRAY).put(List.class, SqlTypeName.ARRAY).put(Map.class, SqlTypeName.MAP).put(Void.class, SqlTypeName.NULL).build();

    public static JavaToSqlTypeConversionRules instance() {
        return INSTANCE;
    }

    public @Nullable SqlTypeName lookup(Class javaClass) {
        return this.rules.get(javaClass);
    }

    private static interface ColumnList
    extends List {
    }
}

