/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlInternalOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlBetweenOperator;
import org.apache.calcite.sql.fun.SqlInOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.util.Litmus;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlInternalOperators {
    public static final SqlRowOperator ANONYMOUS_ROW = new SqlRowOperator("$ANONYMOUS_ROW"){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            List<@Nullable SqlNode> operandList = call.getOperandList();
            writer.list(SqlWriter.FrameTypeEnum.PARENTHESES, SqlWriter.COMMA, SqlNodeList.of(call.getParserPosition(), operandList));
        }
    };
    public static final SqlRowOperator ANONYMOUS_ROW_NO_PARENTHESES = new SqlRowOperator("$ANONYMOUS_ROW_NO_PARENTHESES"){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL);
            for (SqlNode operand : call.getOperandList()) {
                writer.sep(",");
                operand.unparse(writer, leftPrec, rightPrec);
            }
            writer.endList(frame);
        }
    };
    public static final SqlInternalOperator THROW_UNLESS = new SqlInternalOperator("$THROW_UNLESS", SqlKind.OTHER);
    public static final SqlInOperator DRUID_IN = new SqlInOperator(SqlKind.DRUID_IN);
    public static final SqlInOperator DRUID_NOT_IN = new SqlInOperator(SqlKind.DRUID_NOT_IN);
    public static final SqlBetweenOperator DRUID_BETWEEN = new SqlBetweenOperator(SqlBetweenOperator.Flag.SYMMETRIC, false){

        @Override
        public SqlKind getKind() {
            return SqlKind.DRUID_BETWEEN;
        }

        @Override
        public boolean validRexOperands(int count, Litmus litmus) {
            return litmus.succeed();
        }
    };
    public static final SqlOperator SEPARATOR = new SqlInternalOperator("SEPARATOR", SqlKind.SEPARATOR, 20, false, ReturnTypes.ARG0, InferTypes.RETURN_TYPE, (SqlOperandTypeChecker)OperandTypes.ANY);

    private SqlInternalOperators() {
    }
}

