/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.hep;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

abstract class HepInstruction {
    HepInstruction() {
    }

    void initialize(boolean clearCache) {
    }

    abstract void execute(HepPlanner var1);

    static class EndGroup
    extends HepInstruction {
        @Nullable Set<RelOptRule> ruleSet;
        boolean collecting;

        EndGroup() {
        }

        @Override
        void initialize(boolean clearCache) {
            if (!clearCache) {
                return;
            }
            this.ruleSet = new HashSet<RelOptRule>();
            this.collecting = true;
        }

        @Override
        void execute(HepPlanner planner) {
            planner.executeInstruction(this);
        }
    }

    static class BeginGroup
    extends HepInstruction {
        @Nullable EndGroup endGroup;

        BeginGroup() {
        }

        @Override
        void initialize(boolean clearCache) {
        }

        @Override
        void execute(HepPlanner planner) {
            planner.executeInstruction(this);
        }
    }

    static class Subprogram
    extends HepInstruction {
        @Nullable HepProgram subprogram;

        Subprogram() {
        }

        @Override
        void initialize(boolean clearCache) {
            if (this.subprogram != null) {
                this.subprogram.initialize(clearCache);
            }
        }

        @Override
        void execute(HepPlanner planner) {
            planner.executeInstruction(this);
        }
    }

    static class MatchLimit
    extends HepInstruction {
        int limit;

        MatchLimit() {
        }

        @Override
        void execute(HepPlanner planner) {
            planner.executeInstruction(this);
        }
    }

    static class MatchOrder
    extends HepInstruction {
        @Nullable HepMatchOrder order;

        MatchOrder() {
        }

        @Override
        void execute(HepPlanner planner) {
            planner.executeInstruction(this);
        }
    }

    static class RuleInstance
    extends HepInstruction {
        @Nullable String ruleDescription;
        @Nullable RelOptRule rule;

        RuleInstance() {
        }

        @Override
        void initialize(boolean clearCache) {
            if (!clearCache) {
                return;
            }
            if (this.ruleDescription != null) {
                this.rule = null;
            }
        }

        @Override
        void execute(HepPlanner planner) {
            planner.executeInstruction(this);
        }
    }

    static class CommonRelSubExprRules
    extends HepInstruction {
        @Nullable Set<RelOptRule> ruleSet;

        CommonRelSubExprRules() {
        }

        @Override
        void execute(HepPlanner planner) {
            planner.executeInstruction(this);
        }
    }

    static class ConverterRules
    extends HepInstruction {
        boolean guaranteed;
        @MonotonicNonNull Set<RelOptRule> ruleSet;

        ConverterRules() {
        }

        @Override
        void execute(HepPlanner planner) {
            planner.executeInstruction(this);
        }
    }

    static class RuleCollection
    extends HepInstruction {
        @Nullable Collection<RelOptRule> rules;

        RuleCollection() {
        }

        @Override
        void execute(HepPlanner planner) {
            planner.executeInstruction(this);
        }
    }

    static class RuleClass<R extends RelOptRule>
    extends HepInstruction {
        @Nullable Class<R> ruleClass;
        @Nullable Set<RelOptRule> ruleSet;

        RuleClass() {
        }

        @Override
        void initialize(boolean clearCache) {
            if (!clearCache) {
                return;
            }
            this.ruleSet = null;
        }

        @Override
        void execute(HepPlanner planner) {
            planner.executeInstruction(this);
        }
    }
}

