/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.EnumerableTraitsUtils;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.DeriveMode;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelNodes;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class EnumerableNestedLoopJoin
extends Join
implements EnumerableRel {
    protected EnumerableNestedLoopJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traits, ImmutableList.of(), left, right, condition, variablesSet, joinType);
    }

    @Deprecated
    protected EnumerableNestedLoopJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
        this(cluster, traits, left, right, condition, CorrelationId.setOf(variablesStopped), joinType);
    }

    @Override
    public EnumerableNestedLoopJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new EnumerableNestedLoopJoin(this.getCluster(), traitSet, left, right, condition, this.variablesSet, joinType);
    }

    public static EnumerableNestedLoopJoin create(RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        RelOptCluster cluster = left.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.enumerableNestedLoopJoin(mq, left, right, joinType));
        return new EnumerableNestedLoopJoin(cluster, traitSet, left, right, condition, variablesSet, joinType);
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        switch (this.joinType) {
            case SEMI: 
            case ANTI: {
                break;
            }
            case RIGHT: {
                rowCount = RelMdUtil.addEpsilon(rowCount);
                break;
            }
            default: {
                if (RelNodes.COMPARATOR.compare(this.left, this.right) <= 0) break;
                rowCount = RelMdUtil.addEpsilon(rowCount);
            }
        }
        double rightRowCount = this.right.estimateRowCount(mq);
        double leftRowCount = this.left.estimateRowCount(mq);
        if (Double.isInfinite(leftRowCount)) {
            rowCount = leftRowCount;
        }
        if (Double.isInfinite(rightRowCount)) {
            rowCount = rightRowCount;
        }
        RelOptCost cost = planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
        cost = cost.multiplyBy(10.0);
        return cost;
    }

    @Override
    public @Nullable Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        return EnumerableTraitsUtils.passThroughTraitsForJoin(required, this.joinType, this.getLeft().getRowType().getFieldCount(), this.traitSet);
    }

    @Override
    public @Nullable Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        return EnumerableTraitsUtils.deriveTraitsForJoin(childTraits, childId, this.joinType, this.traitSet, this.right.getTraitSet());
    }

    @Override
    public DeriveMode getDeriveMode() {
        if (this.joinType == JoinRelType.FULL || this.joinType == JoinRelType.RIGHT) {
            return DeriveMode.PROHIBITED;
        }
        return DeriveMode.LEFT_FIRST;
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        Expression rightExpression = builder.append("right", rightResult.block);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferArray());
        Expression predicate = EnumUtils.generatePredicate(implementor, this.getCluster().getRexBuilder(), this.left, this.right, leftResult.physType, rightResult.physType, this.condition);
        return implementor.result(physType, builder.append(Expressions.call(BuiltInMethod.NESTED_LOOP_JOIN.method, leftExpression, rightExpression, predicate, EnumUtils.joinSelector(this.joinType, physType, ImmutableList.of(leftResult.physType, rightResult.physType)), Expressions.constant((Object)EnumUtils.toLinq4jJoinType(this.joinType)))).toBlock());
    }
}

