/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.type;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.OrdinalReturnTypeInference;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FlinkReturnTypes {
    public static final SqlReturnTypeInference ROUND_FUNCTION = new SqlReturnTypeInference(){

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            BigDecimal lenVal;
            RelDataType numType = opBinding.getOperandType(0);
            if (numType.getSqlTypeName() != SqlTypeName.DECIMAL) {
                return numType;
            }
            if (opBinding.getOperandCount() == 1) {
                lenVal = BigDecimal.ZERO;
            } else if (opBinding.getOperandCount() == 2) {
                lenVal = this.getArg1Literal(opBinding);
            } else {
                throw new AssertionError();
            }
            if (lenVal == null) {
                return numType;
            }
            int p = numType.getPrecision();
            int s = numType.getScale();
            int r = lenVal.intValueExact();
            DecimalType dt = LogicalTypeMerging.findRoundDecimalType((int)p, (int)s, (int)r);
            return opBinding.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, dt.getPrecision(), dt.getScale());
        }

        private BigDecimal getArg1Literal(SqlOperatorBinding opBinding) {
            try {
                return opBinding.getOperandLiteralValue(1, BigDecimal.class);
            }
            catch (Throwable e) {
                return null;
            }
        }
    };
    public static final SqlReturnTypeInference ARG0_VARCHAR_FORCE_NULLABLE = new OrdinalReturnTypeInference(0){

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType newType;
            RelDataType type = super.inferReturnType(opBinding);
            switch (type.getSqlTypeName()) {
                case CHAR: {
                    newType = opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, type.getPrecision());
                    break;
                }
                case VARCHAR: {
                    newType = type;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported type: " + type);
                }
            }
            return opBinding.getTypeFactory().createTypeWithNullability(newType, true);
        }
    };
    public static final SqlReturnTypeInference VARCHAR_FORCE_NULLABLE = ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference VARCHAR_NOT_NULL = ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.TO_NOT_NULLABLE);
    public static final SqlReturnTypeInference ROUND_FUNCTION_NULLABLE = ReturnTypes.cascade(ROUND_FUNCTION, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference IF_NULLABLE = ReturnTypes.cascade(new SqlReturnTypeInference(){

        @Override
        public @Nullable RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            int nOperands = opBinding.getOperandCount();
            ArrayList<RelDataType> types = new ArrayList<RelDataType>();
            for (int i = 1; i < nOperands; ++i) {
                RelDataType type = opBinding.getOperandType(i);
                if (!(SqlTypeUtil.isNumeric(type) || SqlTypeUtil.isCharacter(type) || SqlTypeUtil.isBinary(type))) {
                    return opBinding.getOperandType(1);
                }
                types.add(type);
            }
            return opBinding.getTypeFactory().leastRestrictive(types);
        }
    }, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference STR_MAP_NULLABLE = ReturnTypes.explicit(factory -> ((FlinkTypeFactory)factory).createFieldTypeFromLogicalType((LogicalType)new MapType((LogicalType)VarCharType.STRING_TYPE, (LogicalType)VarCharType.STRING_TYPE)));
}

