/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.utils.PythonUtil;

public class PythonMapRenameRule
extends RelOptRule {
    public static final PythonMapRenameRule INSTANCE = new PythonMapRenameRule();

    private PythonMapRenameRule() {
        super(PythonMapRenameRule.operand(FlinkLogicalCalc.class, PythonMapRenameRule.operand(FlinkLogicalCalc.class, PythonMapRenameRule.none()), new RelOptRuleOperand[0]), "PythonMapRenameRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalCalc topCalc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalCalc bottomCalc = (FlinkLogicalCalc)call.rel(1);
        List bottomProjects = bottomCalc.getProgram().getProjectList().stream().map(bottomCalc.getProgram()::expandLocalRef).collect(Collectors.toList());
        if (bottomProjects.size() != 1 || !PythonUtil.isPythonCall((RexNode)bottomProjects.get(0), null) || bottomCalc.getProgram().getCondition() != null) {
            return false;
        }
        return PythonUtil.isFlattenCalc(topCalc) && !((RelDataType)bottomCalc.getRowType().getFieldList().get(0).getValue()).getFieldNames().equals(topCalc.getProgram().getOutputRowType().getFieldNames());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCalc topCalc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalCalc bottomCalc = (FlinkLogicalCalc)call.rel(1);
        List topProjects = topCalc.getProgram().getProjectList().stream().map(topCalc.getProgram()::expandLocalRef).collect(Collectors.toList());
        FlinkLogicalCalc newCalc = new FlinkLogicalCalc(topCalc.getCluster(), topCalc.getTraitSet(), bottomCalc, RexProgram.create(bottomCalc.getRowType(), topProjects, null, ((RelDataType)bottomCalc.getRowType().getFieldList().get(0).getValue()).getFieldNames(), call.builder().getRexBuilder()));
        call.transformTo(newCalc);
    }
}

