/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.SizeBasedWindowFunction;
import org.apache.flink.table.types.DataType;

public class NTILEAggFunction
extends DeclarativeAggregateFunction
implements SizeBasedWindowFunction {
    private final Expression bucketSize;
    private final Expression bucketsWithPadding;
    private final UnresolvedReferenceExpression rowNumber = ApiExpressionUtils.unresolvedRef((String)"rowNumber");
    private final UnresolvedReferenceExpression bucket = ApiExpressionUtils.unresolvedRef((String)"bucket");
    private final UnresolvedReferenceExpression bucketThreshold = ApiExpressionUtils.unresolvedRef((String)"bucketThreshold");

    public NTILEAggFunction() {
        this.bucketSize = ExpressionBuilder.div((Expression)this.windowSizeAttribute(), (Expression)this.operand(0));
        this.bucketsWithPadding = ExpressionBuilder.mod((Expression)this.windowSizeAttribute(), (Expression)this.operand(0));
    }

    @Override
    public int operandCount() {
        return 1;
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.rowNumber, this.bucket, this.bucketThreshold};
    }

    @Override
    public DataType[] getAggBufferTypes() {
        return new DataType[]{DataTypes.BIGINT(), DataTypes.BIGINT(), DataTypes.BIGINT()};
    }

    @Override
    public DataType getResultType() {
        return DataTypes.BIGINT();
    }

    @Override
    public Expression[] initialValuesExpressions() {
        return new Expression[]{ApiExpressionUtils.valueLiteral((Object)0L), ApiExpressionUtils.valueLiteral((Object)0L), ApiExpressionUtils.valueLiteral((Object)0L)};
    }

    @Override
    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.plus((Expression)this.rowNumber, (Expression)ExpressionBuilder.literal(1L)), ExpressionBuilder.plus((Expression)this.bucket, this.bucketOverflowThen((Expression)ExpressionBuilder.literal(1L))), ExpressionBuilder.plus((Expression)this.bucketThreshold, this.bucketOverflowThen((Expression)ExpressionBuilder.plus(this.bucketSize, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.lessThanOrEqual((Expression)this.bucket, this.bucketsWithPadding), (Expression)ApiExpressionUtils.valueLiteral((Object)1), (Expression)ApiExpressionUtils.valueLiteral((Object)0)))))};
    }

    private Expression bucketOverflowThen(Expression e) {
        return ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.greaterThan((Expression)this.rowNumber, (Expression)this.bucketThreshold), e, (Expression)ApiExpressionUtils.valueLiteral((Object)0L));
    }

    @Override
    public Expression[] retractExpressions() {
        throw new TableException("This function does not support retraction.");
    }

    @Override
    public Expression[] mergeExpressions() {
        throw new TableException("This function does not support merge.");
    }

    @Override
    public Expression getValueExpression() {
        return this.bucket;
    }
}

