/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;

public class SqlAddReplaceColumns
extends SqlAlterTable {
    private final SqlNodeList newColumns;
    private final boolean replace;
    private final SqlNodeList properties;

    public SqlAddReplaceColumns(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList newColumns, boolean replace, @Nullable SqlNodeList properties) {
        super(pos, tableName);
        this.newColumns = newColumns;
        this.replace = replace;
        this.properties = properties;
    }

    public SqlNodeList getNewColumns() {
        return this.newColumns;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public SqlNodeList getProperties() {
        return this.properties;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableIdentifier, this.partitionSpec, this.newColumns, this.properties);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        if (this.replace) {
            writer.keyword("REPLACE");
        } else {
            writer.keyword("ADD");
        }
        writer.keyword("COLUMNS");
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.create("sds"), "(", ")");
        for (SqlNode column : this.newColumns) {
            SqlUnparseUtils.printIndent(writer);
            column.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(frame);
    }
}

