/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eg!B\u0001\u0003\u0003\u0003y!\u0001\u0006*poRKW.Z+oE>,h\u000eZ3e\u001fZ,'O\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005A92\u0003\u0002\u0001\u0012SI\u0002RAE\n\u0016G\rj\u0011AA\u0005\u0003)\t\u0011q\u0004\u0015:pG\u0016\u001c8OR;oGRLwN\\,ji\"\u001cE.Z1okB\u001cF/\u0019;f!\t1r\u0003\u0004\u0001\u0005\u000ba\u0001!\u0019A\r\u0003\u0003-\u000b\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z!\t!s%D\u0001&\u0015\t1C!A\u0003usB,7/\u0003\u0002)K\t!1IU8x!\rQSfL\u0007\u0002W)\u0011AFB\u0001\bG>$WmZ3o\u0013\tq3F\u0001\u0005D_6\u0004\u0018\u000e\\3s!\t\u0011\u0002'\u0003\u00022\u0005\t)r)\u001a8fe\u0006$X\rZ!hOJ,w-\u0019;j_:\u001c\bCA\u001a7\u001b\u0005!$BA\u001b\u0007\u0003\u0011)H/\u001b7\n\u0005]\"$a\u0002'pO\u001eLgn\u001a\u0005\ts\u0001\u0011\t\u0011)A\u0005u\u0005yq-\u001a8BO\u001e\u0014XmZ1uS>t7\u000f\u0005\u0002+w%\u0011Ah\u000b\u0002\u001e\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t\rVt7\r^5p]\"Aa\b\u0001B\u0001B\u0003%q(\u0001\tj]R,'/\\3eS\u0006$X\rV=qKB\u0019\u0001iR%\u000e\u0003\u0005S!AQ\"\u0002\u0011QL\b/Z5oM>T!\u0001R#\u0002\r\r|W.\\8o\u0015\t1\u0005\"A\u0002ba&L!\u0001S!\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:\u0004\"A\u0013'\u000e\u0003-S!A\n\u0005\n\u00055[%a\u0001*po\"Aq\n\u0001B\u0001B\u0003%\u0001+A\u0005j]B,H\u000fV=qKB\u0019\u0001iR\u0012\t\u0011I\u0003!\u0011!Q\u0001\nM\u000b!B]8x)&lW-\u00133y!\tYB+\u0003\u0002V9\t\u0019\u0011J\u001c;\t\u0011]\u0003!\u0011!Q\u0001\na\u000b1\"];fef\u001cuN\u001c4jOB\u0011\u0011lW\u0007\u00025*\u0011aIB\u0005\u00039j\u0013\u0011c\u0015;sK\u0006l\u0017+^3ss\u000e{gNZ5h\u0011\u0015q\u0006\u0001\"\u0001`\u0003\u0019a\u0014N\\5u}Q1\u0001-\u00192dI\u0016\u00042A\u0005\u0001\u0016\u0011\u0015IT\f1\u0001;\u0011\u0015qT\f1\u0001@\u0011\u0015yU\f1\u0001Q\u0011\u0015\u0011V\f1\u0001T\u0011\u00159V\f1\u0001Y\u0011%9\u0007\u00011AA\u0002\u0013E\u0001.\u0001\u0004pkR\u0004X\u000f^\u000b\u0002G!I!\u000e\u0001a\u0001\u0002\u0004%\tb[\u0001\u000b_V$\b/\u001e;`I\u0015\fHC\u00017p!\tYR.\u0003\u0002o9\t!QK\\5u\u0011\u001d\u0001\u0018.!AA\u0002\r\n1\u0001\u001f\u00132\u0011%\u0011\b\u00011A\u0001B\u0003&1%A\u0004pkR\u0004X\u000f\u001e\u0011\t\u0013Q\u0004\u0001\u0019!a\u0001\n\u0013)\u0018\u0001E1dGVlW\u000f\\1u_J\u001cF/\u0019;f+\u00051\bcA<{\u00136\t\u0001P\u0003\u0002z\u0007\u0006)1\u000f^1uK&\u00111\u0010\u001f\u0002\u000b-\u0006dW/Z*uCR,\u0007\"C?\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u007f\u0003Q\t7mY;nk2\fGo\u001c:Ti\u0006$Xm\u0018\u0013fcR\u0011An \u0005\bar\f\t\u00111\u0001w\u0011)\t\u0019\u0001\u0001a\u0001\u0002\u0003\u0006KA^\u0001\u0012C\u000e\u001cW/\\;mCR|'o\u0015;bi\u0016\u0004\u0003bCA\u0004\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013\t1B]8x\u001b\u0006\u00048\u000b^1uKV\u0011\u00111\u0002\t\bo\u00065\u0011\u0011CA\f\u0013\r\ty\u0001\u001f\u0002\t\u001b\u0006\u00048\u000b^1uKB\u00191$a\u0005\n\u0007\u0005UAD\u0001\u0003M_:<\u0007#BA\r\u0003CIUBAA\u000e\u0015\r)\u0014Q\u0004\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\u000e\u0005\u0011a\u0015n\u001d;\t\u0017\u0005\u001d\u0002\u00011AA\u0002\u0013%\u0011\u0011F\u0001\u0010e><X*\u00199Ti\u0006$Xm\u0018\u0013fcR\u0019A.a\u000b\t\u0013A\f)#!AA\u0002\u0005-\u0001bCA\u0018\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0017\tAB]8x\u001b\u0006\u00048\u000b^1uK\u0002B1\"a\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00026\u0005\u00012o\u001c:uK\u0012$\u0016.\\3ti\u0006l\u0007o]\u000b\u0003\u0003o\u0001b!!\u0007\u0002:\u0005E\u0011\u0002BA\u001e\u00037\u0011!\u0002T5oW\u0016$G*[:u\u0011-\ty\u0004\u0001a\u0001\u0002\u0004%I!!\u0011\u0002)M|'\u000f^3e)&lWm\u001d;b[B\u001cx\fJ3r)\ra\u00171\t\u0005\na\u0006u\u0012\u0011!a\u0001\u0003oA1\"a\u0012\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00028\u0005\t2o\u001c:uK\u0012$\u0016.\\3ti\u0006l\u0007o\u001d\u0011\t\u0017\u0005-\u0003\u00011AA\u0002\u0013E\u0011QJ\u0001\tMVt7\r^5p]V\tq\u0006C\u0006\u0002R\u0001\u0001\r\u00111A\u0005\u0012\u0005M\u0013\u0001\u00044v]\u000e$\u0018n\u001c8`I\u0015\fHc\u00017\u0002V!A\u0001/a\u0014\u0002\u0002\u0003\u0007q\u0006\u0003\u0006\u0002Z\u0001\u0001\r\u0011!Q!\n=\n\u0011BZ;oGRLwN\u001c\u0011\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`\u0005!q\u000e]3o)\ra\u0017\u0011\r\u0005\t\u0003G\nY\u00061\u0001\u0002f\u000511m\u001c8gS\u001e\u0004B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003WB\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002p\u0005%$!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0002t\u0001!\t%!\u001e\u0002\u001dA\u0014xnY3tg\u0016cW-\\3oiR9A.a\u001e\u0002|\u0005]\u0005bBA=\u0003c\u0002\raI\u0001\u0007S:\u0004X\u000f^\"\t\u0011\u0005u\u0014\u0011\u000fa\u0001\u0003\u007f\n1a\u0019;y!\u0011\t\t)a%\u0011\u000f\u0005\r\u0015qR\u000b$G5\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)A\u0005gk:\u001cG/[8og*\u0019a)a#\u000b\u0007\u00055\u0005\"A\u0005tiJ,\u0017-\\5oO&!\u0011\u0011SAC\u0005QYU-_3e!J|7-Z:t\rVt7\r^5p]&!\u0011QSAH\u0005\u001d\u0019uN\u001c;fqRD\u0001\"!'\u0002r\u0001\u0007\u00111T\u0001\u0004_V$\b#BAO\u0003C\u001bSBAAP\u0015\t)\u0004\"\u0003\u0003\u0002$\u0006}%!C\"pY2,7\r^8s\u0011\u001d\t9\u000b\u0001C!\u0003S\u000bqa\u001c8US6,'\u000fF\u0004m\u0003W\u000by+a.\t\u0011\u00055\u0016Q\u0015a\u0001\u0003#\t\u0011\u0002^5nKN$\u0018-\u001c9\t\u0011\u0005u\u0014Q\u0015a\u0001\u0003c\u0003B!!!\u00024&!\u0011QWAH\u00059ye\u000eV5nKJ\u001cuN\u001c;fqRD\u0001\"!'\u0002&\u0002\u0007\u00111\u0014\u0005\b\u0003w\u0003A\u0011BA_\u0003IIgn]3siR{7k\u001c:uK\u0012d\u0015n\u001d;\u0015\u00071\fy\f\u0003\u0005\u0002B\u0006e\u0006\u0019AA\t\u0003=\u0011XmY8sIRKW.Z:uC6\u0004\bbBAc\u0001\u0019\u0005\u0011qY\u0001!aJ|7-Z:t\u000b2,W.\u001a8ug^KG\u000f[*b[\u0016$\u0016.\\3ti\u0006l\u0007\u000fF\u0004m\u0003\u0013\fi-!5\t\u0011\u0005-\u00171\u0019a\u0001\u0003/\t!bY;s%><H*[:u\u0011\u001d\ty-a1A\u0002%\u000bq\u0002\\1ti\u0006\u001b7-^7vY\u0006$xN\u001d\u0005\t\u00033\u000b\u0019\r1\u0001\u0002\u001c\"9\u0011Q\u001b\u0001\u0005B\u0005]\u0017!B2m_N,G#\u00017")
public abstract class RowTimeUnboundedOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final TypeInformation<Row> intermediateType;
    private final TypeInformation<CRow> inputType;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private LinkedList<Object> sortedTimestamps;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        RowTimeUnboundedOver rowTimeUnboundedOver = this;
        synchronized (rowTimeUnboundedOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    public CRow output() {
        return this.output;
    }

    public void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private LinkedList<Object> sortedTimestamps() {
        return this.sortedTimestamps;
    }

    private void sortedTimestamps_$eq(LinkedList<Object> x$1) {
        this.sortedTimestamps = x$1;
    }

    public GeneratedAggregations function() {
        return this.function;
    }

    public void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(30).append("Compiling AggregateHelper: ").append(this.genAggregations.name()).append(" \n\n").append(new StringBuilder(6).append("Code:\n").append(this.genAggregations.code()).toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        this.sortedTimestamps_$eq(new LinkedList<Object>());
        ValueStateDescriptor accDescriptor = new ValueStateDescriptor("accumulatorstate", this.intermediateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accDescriptor));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("rowmapstate", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeUnboundedOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        block1: {
            Row input = inputC.row();
            this.processCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
            long timestamp = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
            long curWatermark = ctx.timerService().currentWatermark();
            if (timestamp <= curWatermark) break block1;
            ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
            ArrayList<Row> rowList = (ArrayList<Row>)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
            if (rowList == null) {
                rowList = new ArrayList<Row>();
            }
            rowList.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)timestamp), rowList);
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled()) {
                boolean noRecordsToProcess;
                boolean bl = noRecordsToProcess = !this.rowMapState().keys().iterator().hasNext();
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState()}));
                    this.function().cleanup();
                } else {
                    this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        Iterator keyIterator = this.rowMapState().keys().iterator();
        if (keyIterator.hasNext()) {
            long curWatermark = ctx.timerService().currentWatermark();
            boolean existEarlyRecord = false;
            do {
                long recordTime;
                if ((recordTime = BoxesRunTime.unboxToLong(keyIterator.next())) <= curWatermark) {
                    this.insertToSortedList(recordTime);
                    continue;
                }
                existEarlyRecord = true;
            } while (keyIterator.hasNext());
            Row lastAccumulator = (Row)this.accumulatorState().value();
            if (lastAccumulator == null) {
                lastAccumulator = this.function().createAccumulators();
            }
            while (!this.sortedTimestamps().isEmpty()) {
                long curTimestamp = BoxesRunTime.unboxToLong((Object)this.sortedTimestamps().removeFirst());
                List curRowList = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)curTimestamp));
                this.processElementsWithSameTimestamp(curRowList, lastAccumulator, out);
                this.rowMapState().remove((Object)BoxesRunTime.boxToLong((long)curTimestamp));
            }
            this.accumulatorState().update((Object)lastAccumulator);
            if (existEarlyRecord) {
                ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
            }
        }
        this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    private void insertToSortedList(long recordTimestamp) {
        block1: {
            ListIterator<Object> listIterator = this.sortedTimestamps().listIterator(this.sortedTimestamps().size());
            boolean bl = true;
            while (listIterator.hasPrevious() && bl) {
                long timestamp = BoxesRunTime.unboxToLong((Object)listIterator.previous());
                if (recordTimestamp < timestamp) continue;
                listIterator.next();
                listIterator.add(BoxesRunTime.boxToLong((long)recordTimestamp));
                bl = false;
            }
            if (!bl) break block1;
            this.sortedTimestamps().addFirst(BoxesRunTime.boxToLong((long)recordTimestamp));
        }
    }

    public abstract void processElementsWithSameTimestamp(List<Row> var1, Row var2, Collector<CRow> var3);

    public void close() {
        this.function().close();
    }

    public RowTimeUnboundedOver(GeneratedAggregationsFunction genAggregations, TypeInformation<Row> intermediateType, TypeInformation<CRow> inputType, int rowTimeIdx, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.intermediateType = intermediateType;
        this.inputType = inputType;
        this.rowTimeIdx = rowTimeIdx;
        super(queryConfig);
        Compiler.$init$(this);
        Logging.$init$(this);
    }
}

