/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.runtime.aggregate.CollectionRowComparator;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001=\u0011!DU8x)&lWmU8siB\u0013xnY3tg\u001a+hn\u0019;j_:T!a\u0001\u0003\u0002\u0013\u0005<wM]3hCR,'BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001!\u0006\u0002\u0011;M\u0011\u0001!\u0005\t\u0006%eY\u0012&K\u0007\u0002')\u0011A#F\u0001\nMVt7\r^5p]NT!AF\f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0019\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u00035M\u0011AcS3zK\u0012\u0004&o\\2fgN4UO\\2uS>t\u0007C\u0001\u000f\u001e\u0019\u0001!QA\b\u0001C\u0002}\u0011\u0011aS\t\u0003A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012qAT8uQ&tw\r\u0005\u0002\"O%\u0011\u0001F\t\u0002\u0004\u0003:L\bC\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0005\u0003\u0015!\u0018\u0010]3t\u0013\tq3F\u0001\u0003D%><\b\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011B\u0019\u0002\u0019%t\u0007/\u001e;S_^$\u0016\u0010]3\u0016\u0003I\u0002\"AK\u001a\n\u0005QZ#\u0001D\"S_^$\u0016\u0010]3J]\u001a|\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u001b%t\u0007/\u001e;S_^$\u0016\u0010]3!\u0011!A\u0004A!b\u0001\n\u0013I\u0014A\u0003:poRLW.Z%eqV\t!\b\u0005\u0002\"w%\u0011AH\t\u0002\u0004\u0013:$\b\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002\u0017I|w\u000f^5nK&#\u0007\u0010\t\u0005\t\u0001\u0002\u0011)\u0019!C\u0005\u0003\u0006i!o\\<D_6\u0004\u0018M]1u_J,\u0012A\u0011\t\u0004C\r+\u0015B\u0001##\u0005\u0019y\u0005\u000f^5p]B\u0011aiR\u0007\u0002\u0005%\u0011\u0001J\u0001\u0002\u0018\u0007>dG.Z2uS>t'k\\<D_6\u0004\u0018M]1u_JD\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u000fe><8i\\7qCJ\fGo\u001c:!\u0011\u0015a\u0005\u0001\"\u0001N\u0003\u0019a\u0014N\\5u}Q!aj\u0014)R!\r1\u0005a\u0007\u0005\u0006a-\u0003\rA\r\u0005\u0006q-\u0003\rA\u000f\u0005\u0006\u0001.\u0003\rA\u0011\u0005\n'\u0002\u0001\r\u00111A\u0005\nQ\u000b\u0011\u0002Z1uCN#\u0018\r^3\u0016\u0003U\u0003BA\u0016/_C6\tqK\u0003\u0002Y3\u0006)1\u000f^1uK*\u0011!lW\u0001\u0007G>lWn\u001c8\u000b\u0005YA\u0011BA/X\u0005!i\u0015\r]*uCR,\u0007CA\u0011`\u0013\t\u0001'E\u0001\u0003M_:<\u0007c\u00012hS6\t1M\u0003\u0002eK\u0006!Q\u000f^5m\u0015\u00051\u0017\u0001\u00026bm\u0006L!\u0001[2\u0003\t1K7\u000f\u001e\t\u0003U2l\u0011a\u001b\u0006\u0003Y!I!!\\6\u0003\u0007I{w\u000fC\u0005p\u0001\u0001\u0007\t\u0019!C\u0005a\u0006iA-\u0019;b'R\fG/Z0%KF$\"!\u001d;\u0011\u0005\u0005\u0012\u0018BA:#\u0005\u0011)f.\u001b;\t\u000fUt\u0017\u0011!a\u0001+\u0006\u0019\u0001\u0010J\u0019\t\u0013]\u0004\u0001\u0019!A!B\u0013)\u0016A\u00033bi\u0006\u001cF/\u0019;fA!I\u0011\u0010\u0001a\u0001\u0002\u0004%IA_\u0001\u0016Y\u0006\u001cH\u000f\u0016:jO\u001e,'/\u001b8h)N\u001cF/\u0019;f+\u0005Y\bc\u0001,}=&\u0011Qp\u0016\u0002\u000b-\u0006dW/Z*uCR,\u0007BC@\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0002\u0005IB.Y:u)JLwmZ3sS:<Gk]*uCR,w\fJ3r)\r\t\u00181\u0001\u0005\bkz\f\t\u00111\u0001|\u0011)\t9\u0001\u0001a\u0001\u0002\u0003\u0006Ka_\u0001\u0017Y\u0006\u001cH\u000f\u0016:jO\u001e,'/\u001b8h)N\u001cF/\u0019;fA!Y\u00111\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0007\u0003\u001dyW\u000f\u001e9vi\u000e+\u0012!\u000b\u0005\f\u0003#\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\"A\u0006pkR\u0004X\u000f^\"`I\u0015\fHcA9\u0002\u0016!AQ/a\u0004\u0002\u0002\u0003\u0007\u0011\u0006\u0003\u0006\u0002\u001a\u0001\u0001\r\u0011!Q!\n%\n\u0001b\\;uaV$8\t\t\u0005\b\u0003;\u0001A\u0011IA\u0010\u0003\u0011y\u0007/\u001a8\u0015\u0007E\f\t\u0003\u0003\u0005\u0002$\u0005m\u0001\u0019AA\u0013\u0003\u0019\u0019wN\u001c4jOB!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,!\tQbY8oM&<WO]1uS>t\u0017\u0002BA\u0018\u0003S\u0011QbQ8oM&<WO]1uS>t\u0007bBA\u001a\u0001\u0011\u0005\u0013QG\u0001\u000faJ|7-Z:t\u000b2,W.\u001a8u)\u001d\t\u0018qGA\u001e\u0003\u000bBq!!\u000f\u00022\u0001\u0007\u0011&\u0001\u0004j]B,Ho\u0011\u0005\t\u0003{\t\t\u00041\u0001\u0002@\u0005\u00191\r\u001e=\u0011\u0007E\t\t%C\u0002\u0002De\u0011qaQ8oi\u0016DH\u000f\u0003\u0005\u0002H\u0005E\u0002\u0019AA%\u0003\ryW\u000f\u001e\t\u0006\u0003\u0017\ny%K\u0007\u0003\u0003\u001bR!\u0001\u001a\u0005\n\t\u0005E\u0013Q\n\u0002\n\u0007>dG.Z2u_JDq!!\u0016\u0001\t\u0003\n9&A\u0004p]RKW.\u001a:\u0015\u000fE\fI&!\u0018\u0002f!9\u00111LA*\u0001\u0004q\u0016!\u0003;j[\u0016\u001cH/Y7q\u0011!\ti$a\u0015A\u0002\u0005}\u0003cA\t\u0002b%\u0019\u00111M\r\u0003\u001d=sG+[7fe\u000e{g\u000e^3yi\"A\u0011qIA*\u0001\u0004\tI\u0005")
public class RowTimeSortProcessFunction<K>
extends KeyedProcessFunction<K, CRow, CRow> {
    private final CRowTypeInfo inputRowType;
    private final int rowtimeIdx;
    private final Option<CollectionRowComparator> rowComparator;
    private MapState<Object, List<Row>> dataState;
    private ValueState<Object> lastTriggeringTsState;
    private CRow outputC;

    private CRowTypeInfo inputRowType() {
        return this.inputRowType;
    }

    private int rowtimeIdx() {
        return this.rowtimeIdx;
    }

    private Option<CollectionRowComparator> rowComparator() {
        return this.rowComparator;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private CRow outputC() {
        return this.outputC;
    }

    private void outputC_$eq(CRow x$1) {
        this.outputC = x$1;
    }

    public void open(Configuration config) {
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType().rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        this.outputC_$eq(new CRow());
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        block2: {
            long lastTriggeringTs;
            Row input = inputC.row();
            long rowtime = BoxesRunTime.unboxToLong((Object)input.getField(this.rowtimeIdx()));
            if (rowtime <= (lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value()))) break block2;
            List rows = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)rowtime));
            if (rows != null) {
                rows.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)rowtime), (Object)rows);
            } else {
                ArrayList<Row> rows2 = new ArrayList<Row>();
                rows2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)rowtime), rows2);
                ctx.timerService().registerEventTimeTimer(rowtime);
            }
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        block2: {
            ((TimestampedCollector)out).eraseTimestamp();
            List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
            if (inputs == null) break block2;
            if (this.rowComparator().isDefined()) {
                Collections.sort(inputs, (Comparator)this.rowComparator().get());
            }
            for (int i = 0; i < inputs.size(); ++i) {
                this.outputC().row_$eq((Row)inputs.get(i));
                out.collect((Object)this.outputC());
            }
            this.dataState().remove((Object)BoxesRunTime.boxToLong((long)timestamp));
            this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        }
    }

    public RowTimeSortProcessFunction(CRowTypeInfo inputRowType, int rowtimeIdx, Option<CollectionRowComparator> rowComparator) {
        this.inputRowType = inputRowType;
        this.rowtimeIdx = rowtimeIdx;
        this.rowComparator = rowComparator;
        Preconditions.checkNotNull(rowComparator);
    }
}

