/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001=\u0011aCU8x)&lWMQ8v]\u0012,GMU8xg>3XM\u001d\u0006\u0003\u0007\u0011\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001+\t\u0001rc\u0005\u0003\u0001#%\u0012\u0004#\u0002\n\u0014+\r\u001aS\"\u0001\u0002\n\u0005Q\u0011!a\b)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8XSRD7\t\\3b]V\u00048\u000b^1uKB\u0011ac\u0006\u0007\u0001\t\u0015A\u0002A1\u0001\u001a\u0005\u0005Y\u0015C\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u0011\n\u0005\tb\"aA!osB\u0011AeJ\u0007\u0002K)\u0011a\u0005B\u0001\u0006if\u0004Xm]\u0005\u0003Q\u0015\u0012Aa\u0011*poB\u0019!&L\u0018\u000e\u0003-R!\u0001\f\u0004\u0002\u000f\r|G-Z4f]&\u0011af\u000b\u0002\t\u0007>l\u0007/\u001b7feB\u0011!\u0003M\u0005\u0003c\t\u0011QcR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7\u000f\u0005\u00024m5\tAG\u0003\u00026\r\u0005!Q\u000f^5m\u0013\t9DGA\u0004M_\u001e<\u0017N\\4\t\u0011e\u0002!\u0011!Q\u0001\ni\nqbZ3o\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003UmJ!\u0001P\u0016\u0003;\u001d+g.\u001a:bi\u0016$\u0017iZ4sK\u001e\fG/[8og\u001a+hn\u0019;j_:D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0015C\u001e<'/Z4bi&|gn\u0015;bi\u0016$\u0016\u0010]3\u0011\u0005\u0001;U\"A!\u000b\u0005\t\u001b\u0015!\u0003;za\u0016,H/\u001b7t\u0015\t!U)\u0001\u0003kCZ\f'B\u0001$\t\u0003\r\t\u0007/[\u0005\u0003\u0011\u0006\u00131BU8x)f\u0004X-\u00138g_\"A!\n\u0001B\u0001B\u0003%1*\u0001\u0007j]B,HOU8x)f\u0004X\r\u0005\u0002%\u0019&\u0011Q*\n\u0002\r\u0007J{w\u000fV=qK&sgm\u001c\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\u0006y\u0001O]3dK\u0012LgnZ(gMN,G\u000f\u0005\u0002\u001c#&\u0011!\u000b\b\u0002\u0005\u0019>tw\r\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0003)\u0011xn\u001e+j[\u0016LE\r\u001f\t\u00037YK!a\u0016\u000f\u0003\u0007%sG\u000f\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0003-\tX/\u001a:z\u0007>tg-[4\u0011\u0005mkV\"\u0001/\u000b\u0005\u00193\u0011B\u00010]\u0005E\u0019FO]3b[F+XM]=D_:4\u0017n\u001a\u0005\u0006A\u0002!\t!Y\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\t\u001cG-\u001a4hQB\u0019!\u0003A\u000b\t\u000bez\u0006\u0019\u0001\u001e\t\u000byz\u0006\u0019A \t\u000b){\u0006\u0019A&\t\u000b={\u0006\u0019\u0001)\t\u000bQ{\u0006\u0019A+\t\u000be{\u0006\u0019\u0001.\t\u0013)\u0004\u0001\u0019!a\u0001\n\u0013Y\u0017AB8viB,H/F\u0001$\u0011%i\u0007\u00011AA\u0002\u0013%a.\u0001\u0006pkR\u0004X\u000f^0%KF$\"a\u001c:\u0011\u0005m\u0001\u0018BA9\u001d\u0005\u0011)f.\u001b;\t\u000fMd\u0017\u0011!a\u0001G\u0005\u0019\u0001\u0010J\u0019\t\u0013U\u0004\u0001\u0019!A!B\u0013\u0019\u0013aB8viB,H\u000f\t\u0005\no\u0002\u0001\r\u00111A\u0005\na\fQ\u0003\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$X-F\u0001z!\rQx\u0010U\u0007\u0002w*\u0011A0`\u0001\u0006gR\fG/\u001a\u0006\u0003}\u0016\u000baaY8n[>t\u0017bAA\u0001w\nQa+\u00197vKN#\u0018\r^3\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013%\u0011qA\u0001\u001aY\u0006\u001cH\u000f\u0016:jO\u001e,'/\u001b8h)N\u001cF/\u0019;f?\u0012*\u0017\u000fF\u0002p\u0003\u0013A\u0001b]A\u0002\u0003\u0003\u0005\r!\u001f\u0005\u000b\u0003\u001b\u0001\u0001\u0019!A!B\u0013I\u0018A\u00067bgR$&/[4hKJLgn\u001a+t'R\fG/\u001a\u0011\t\u0015\u0005E\u0001\u00011AA\u0002\u0013%\u00010\u0001\beCR\f7i\\;oiN#\u0018\r^3\t\u0017\u0005U\u0001\u00011AA\u0002\u0013%\u0011qC\u0001\u0013I\u0006$\u0018mQ8v]R\u001cF/\u0019;f?\u0012*\u0017\u000fF\u0002p\u00033A\u0001b]A\n\u0003\u0003\u0005\r!\u001f\u0005\u000b\u0003;\u0001\u0001\u0019!A!B\u0013I\u0018a\u00043bi\u0006\u001cu.\u001e8u'R\fG/\u001a\u0011\t\u0017\u0005\u0005\u0002\u00011AA\u0002\u0013%\u00111E\u0001\u0011C\u000e\u001cW/\\;mCR|'o\u0015;bi\u0016,\"!!\n\u0011\ti|\u0018q\u0005\t\u0005\u0003S\ti#\u0004\u0002\u0002,)\u0011a\u0005C\u0005\u0005\u0003_\tYCA\u0002S_^D1\"a\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00026\u0005!\u0012mY2v[Vd\u0017\r^8s'R\fG/Z0%KF$2a\\A\u001c\u0011%\u0019\u0018\u0011GA\u0001\u0002\u0004\t)\u0003C\u0006\u0002<\u0001\u0001\r\u0011!Q!\n\u0005\u0015\u0012!E1dGVlW\u000f\\1u_J\u001cF/\u0019;fA!Y\u0011q\b\u0001A\u0002\u0003\u0007I\u0011BA!\u0003%!\u0017\r^1Ti\u0006$X-\u0006\u0002\u0002DA1!0!\u0012Q\u0003\u0013J1!a\u0012|\u0005!i\u0015\r]*uCR,\u0007CBA&\u0003#\n9#\u0004\u0002\u0002N)\u0019Q'a\u0014\u000b\u0003\u0011KA!a\u0015\u0002N\t!A*[:u\u0011-\t9\u0006\u0001a\u0001\u0002\u0004%I!!\u0017\u0002\u001b\u0011\fG/Y*uCR,w\fJ3r)\ry\u00171\f\u0005\ng\u0006U\u0013\u0011!a\u0001\u0003\u0007B1\"a\u0018\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002D\u0005QA-\u0019;b'R\fG/\u001a\u0011\t\u0017\u0005\r\u0004\u00011AA\u0002\u0013%\u0011QM\u0001\tMVt7\r^5p]V\tq\u0006C\u0006\u0002j\u0001\u0001\r\u00111A\u0005\n\u0005-\u0014\u0001\u00044v]\u000e$\u0018n\u001c8`I\u0015\fHcA8\u0002n!A1/a\u001a\u0002\u0002\u0003\u0007q\u0006\u0003\u0006\u0002r\u0001\u0001\r\u0011!Q!\n=\n\u0011BZ;oGRLwN\u001c\u0011\t\u000f\u0005U\u0004\u0001\"\u0011\u0002x\u0005!q\u000e]3o)\ry\u0017\u0011\u0010\u0005\t\u0003w\n\u0019\b1\u0001\u0002~\u000511m\u001c8gS\u001e\u0004B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007C\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002\b\u0006\u0005%!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0002\f\u0002!\t%!$\u0002\u001dA\u0014xnY3tg\u0016cW-\\3oiR9q.a$\u0002\u0014\u0006=\u0006bBAI\u0003\u0013\u0003\raI\u0001\u0007S:\u0004X\u000f^\"\t\u0011\u0005U\u0015\u0011\u0012a\u0001\u0003/\u000b1a\u0019;y!\u0011\tI*a+\u0011\u000f\u0005m\u0015qU\u000b$G5\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+A\u0005gk:\u001cG/[8og*\u0019a)a)\u000b\u0007\u0005\u0015\u0006\"A\u0005tiJ,\u0017-\\5oO&!\u0011\u0011VAO\u0005QYU-_3e!J|7-Z:t\rVt7\r^5p]&!\u0011QVAT\u0005\u001d\u0019uN\u001c;fqRD\u0001\"!-\u0002\n\u0002\u0007\u00111W\u0001\u0004_V$\b#BA[\u0003s\u001bSBAA\\\u0015\t)\u0004\"\u0003\u0003\u0002<\u0006]&!C\"pY2,7\r^8s\u0011\u001d\ty\f\u0001C!\u0003\u0003\fqa\u001c8US6,'\u000fF\u0004p\u0003\u0007\f9-a4\t\u000f\u0005\u0015\u0017Q\u0018a\u0001!\u0006IA/[7fgR\fW\u000e\u001d\u0005\t\u0003+\u000bi\f1\u0001\u0002JB!\u0011\u0011TAf\u0013\u0011\ti-a*\u0003\u001d=sG+[7fe\u000e{g\u000e^3yi\"A\u0011\u0011WA_\u0001\u0004\t\u0019\fC\u0004\u0002T\u0002!\t%!6\u0002\u000b\rdwn]3\u0015\u0003=\u0004")
public class RowTimeBoundedRowsOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Object> dataCountState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        RowTimeBoundedRowsOver rowTimeBoundedRowsOver = this;
        synchronized (rowTimeBoundedRowsOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Object> dataCountState() {
        return this.dataCountState;
    }

    private void dataCountState_$eq(ValueState<Object> x$1) {
        this.dataCountState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(30).append("Compiling AggregateHelper: ").append(this.genAggregations.name()).append(" \n\n").append(new StringBuilder(6).append("Code:\n").append(this.genAggregations.code()).toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor dataCountStateDescriptor = new ValueStateDescriptor("dataCountState", Long.TYPE);
        this.dataCountState_$eq((ValueState<Object>)this.getRuntimeContext().getState(dataCountStateDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRowsOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        block2: {
            Row input = inputC.row();
            this.processCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
            long triggeringTs = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
            long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
            if (triggeringTs <= lastTriggeringTs) break block2;
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)triggeringTs));
            if (data != null) {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), (Object)data);
            } else {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            }
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled()) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.dataCountState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            long dataCount = BoxesRunTime.unboxToLong((Object)this.dataCountState().value());
            List retractList = null;
            long retractTs = Long.MAX_VALUE;
            int retractCnt = 0;
            for (int i = 0; i < inputs.size(); ++i) {
                Row input = (Row)inputs.get(i);
                if (accumulators == null) {
                    accumulators = this.function().createAccumulators();
                }
                Row retractRow = null;
                if (dataCount >= this.precedingOffset) {
                    if (retractList == null) {
                        retractTs = Long.MAX_VALUE;
                        Iterator dataTimestampIt = this.dataState().keys().iterator();
                        while (dataTimestampIt.hasNext()) {
                            long dataTs = BoxesRunTime.unboxToLong(dataTimestampIt.next());
                            if (dataTs >= retractTs) continue;
                            retractTs = dataTs;
                        }
                        retractList = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)retractTs));
                    }
                    retractRow = (Row)retractList.get(retractCnt);
                    if (retractList.size() == ++retractCnt) {
                        this.dataState().remove((Object)BoxesRunTime.boxToLong((long)retractTs));
                        retractList = null;
                        retractCnt = 0;
                    }
                } else {
                    ++dataCount;
                }
                this.function().setForwardedFields(input, this.output().row());
                if (retractRow != null) {
                    this.function().retract(accumulators, retractRow);
                }
                this.function().accumulate(accumulators, input);
                this.function().setAggregationResults(accumulators, this.output().row());
                out.collect((Object)this.output());
            }
            if (this.dataState().contains((Object)BoxesRunTime.boxToLong((long)retractTs)) && retractCnt > 0) {
                retractList.subList(0, retractCnt).clear();
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)retractTs), (Object)retractList);
            }
            this.dataCountState().update((Object)BoxesRunTime.boxToLong((long)dataCount));
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() {
        this.function().close();
    }

    public RowTimeBoundedRowsOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, int rowTimeIdx, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(queryConfig);
        Compiler.$init$(this);
        Logging.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

