/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001=\u0011qc\u0012:pkB\fum\u001a)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001U\u0011\u0001cF\n\u0005\u0001EI#\u0007E\u0003\u0013'U\u00193%D\u0001\u0003\u0013\t!\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\t1*\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\u000bQL\b/Z:\n\u0005!*#\u0001B\"S_^\u00042AK\u00170\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u001d\u0019w\u000eZ3hK:L!AL\u0016\u0003\u0011\r{W\u000e]5mKJ\u0004\"A\u0005\u0019\n\u0005E\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tA!\u001e;jY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0011!I\u0004A!b\u0001\n\u0013Q\u0014aD4f]\u0006;wM]3hCRLwN\\:\u0016\u0003m\u0002\"A\u000b\u001f\n\u0005uZ#!H$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d$v]\u000e$\u0018n\u001c8\t\u0011}\u0002!\u0011!Q\u0001\nm\n\u0001cZ3o\u0003\u001e<'/Z4bi&|gn\u001d\u0011\t\u0011\u0005\u0003!Q1A\u0005\n\t\u000bA#Y4he\u0016<\u0017\r^5p]N#\u0018\r^3UsB,W#A\"\u0011\u0005\u0011[U\"A#\u000b\u0005\u0019;\u0015!\u0003;za\u0016,H/\u001b7t\u0015\tA\u0015*\u0001\u0003kCZ\f'B\u0001&\t\u0003\r\t\u0007/[\u0005\u0003\u0019\u0016\u00131BU8x)f\u0004X-\u00138g_\"Aa\n\u0001B\u0001B\u0003%1)A\u000bbO\u001e\u0014XmZ1uS>t7\u000b^1uKRK\b/\u001a\u0011\t\u0011A\u0003!Q1A\u0005\nE\u000b!cZ3oKJ\fG/\u001a*fiJ\f7\r^5p]V\t!\u000b\u0005\u0002\u001c'&\u0011A\u000b\b\u0002\b\u0005>|G.Z1o\u0011!1\u0006A!A!\u0002\u0013\u0011\u0016aE4f]\u0016\u0014\u0018\r^3SKR\u0014\u0018m\u0019;j_:\u0004\u0003\u0002\u0003-\u0001\u0005\u000b\u0007I\u0011B-\u0002\u0017E,XM]=D_:4\u0017nZ\u000b\u00025B\u00111,X\u0007\u00029*\u0011!JB\u0005\u0003=r\u0013\u0011c\u0015;sK\u0006l\u0017+^3ss\u000e{gNZ5h\u0011!\u0001\u0007A!A!\u0002\u0013Q\u0016\u0001D9vKJL8i\u001c8gS\u001e\u0004\u0003\"\u00022\u0001\t\u0003\u0019\u0017A\u0002\u001fj]&$h\bF\u0003eK\u001a<\u0007\u000eE\u0002\u0013\u0001UAQ!O1A\u0002mBQ!Q1A\u0002\rCQ\u0001U1A\u0002ICQ\u0001W1A\u0002iC\u0011B\u001b\u0001A\u0002\u0003\u0007I\u0011B6\u0002\u0011\u0019,hn\u0019;j_:,\u0012a\f\u0005\n[\u0002\u0001\r\u00111A\u0005\n9\fABZ;oGRLwN\\0%KF$\"a\u001c:\u0011\u0005m\u0001\u0018BA9\u001d\u0005\u0011)f.\u001b;\t\u000fMd\u0017\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\t\u0013U\u0004\u0001\u0019!A!B\u0013y\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011%9\b\u00011AA\u0002\u0013%\u00010\u0001\u0004oK^\u0014vn^\u000b\u0002G!I!\u0010\u0001a\u0001\u0002\u0004%Ia_\u0001\u000b]\u0016<(k\\<`I\u0015\fHCA8}\u0011\u001d\u0019\u00180!AA\u0002\rB\u0011B \u0001A\u0002\u0003\u0005\u000b\u0015B\u0012\u0002\u000f9,wOU8xA!Q\u0011\u0011\u0001\u0001A\u0002\u0003\u0007I\u0011\u0002=\u0002\u000fA\u0014XM\u001e*po\"Y\u0011Q\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0004\u0003-\u0001(/\u001a<S_^|F%Z9\u0015\u0007=\fI\u0001\u0003\u0005t\u0003\u0007\t\t\u00111\u0001$\u0011)\ti\u0001\u0001a\u0001\u0002\u0003\u0006KaI\u0001\taJ,gOU8xA!Q\u0011\u0011\u0003\u0001A\u0002\u0003\u0007I\u0011B)\u0002\u0011\u0019L'o\u001d;S_^D1\"!\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0018\u0005aa-\u001b:tiJ{wo\u0018\u0013fcR\u0019q.!\u0007\t\u0011M\f\u0019\"!AA\u0002IC!\"!\b\u0001\u0001\u0004\u0005\t\u0015)\u0003S\u0003%1\u0017N]:u%><\b\u0005C\u0006\u0002\"\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0012!B:uCR,WCAA\u0013!\u0019\t9#a\f\u000245\u0011\u0011\u0011\u0006\u0006\u0005\u0003C\tYCC\u0002\u0002.%\u000baaY8n[>t\u0017\u0002BA\u0019\u0003S\u0011!BV1mk\u0016\u001cF/\u0019;f!\u0011\t)$!\u000f\u000e\u0005\u0005]\"B\u0001\u0014\t\u0013\u0011\tY$a\u000e\u0003\u0007I{w\u000fC\u0006\u0002@\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0013!C:uCR,w\fJ3r)\ry\u00171\t\u0005\ng\u0006u\u0012\u0011!a\u0001\u0003KA1\"a\u0012\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002&\u000511\u000f^1uK\u0002B1\"a\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002N\u0005A1M\u001c;Ti\u0006$X-\u0006\u0002\u0002PA1\u0011qEA\u0018\u0003#\u0002B!a\u0015\u0002\\5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0003mC:<'\"\u0001%\n\t\u0005u\u0013Q\u000b\u0002\u0005\u0019>tw\rC\u0006\u0002b\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0014\u0001D2oiN#\u0018\r^3`I\u0015\fHcA8\u0002f!I1/a\u0018\u0002\u0002\u0003\u0007\u0011q\n\u0005\f\u0003S\u0002\u0001\u0019!A!B\u0013\ty%A\u0005d]R\u001cF/\u0019;fA!9\u0011Q\u000e\u0001\u0005B\u0005=\u0014\u0001B8qK:$2a\\A9\u0011!\t\u0019(a\u001bA\u0002\u0005U\u0014AB2p]\u001aLw\r\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tY\bC\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005}\u0014\u0011\u0010\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\u0006q\u0001O]8dKN\u001cX\t\\3nK:$HcB8\u0002\b\u0006-\u0015q\u0015\u0005\b\u0003\u0013\u000b\t\t1\u0001$\u0003\u0019Ig\u000e];u\u0007\"A\u0011QRAA\u0001\u0004\ty)A\u0002dib\u0004B!!%\u0002$B9\u00111SAP+\r\u001aSBAAK\u0015\u0011\t9*!'\u0002\u0013\u0019,hn\u0019;j_:\u001c(b\u0001&\u0002\u001c*\u0019\u0011Q\u0014\u0005\u0002\u0013M$(/Z1nS:<\u0017\u0002BAQ\u0003+\u0013AcS3zK\u0012\u0004&o\\2fgN4UO\\2uS>t\u0017\u0002BAS\u0003?\u0013qaQ8oi\u0016DH\u000f\u0003\u0005\u0002*\u0006\u0005\u0005\u0019AAV\u0003\ryW\u000f\u001e\t\u0006\u0003[\u000b\tlI\u0007\u0003\u0003_S!!\u000e\u0005\n\t\u0005M\u0016q\u0016\u0002\n\u0007>dG.Z2u_JDq!a.\u0001\t\u0003\nI,A\u0004p]RKW.\u001a:\u0015\u000f=\fY,a1\u0002L\"A\u0011QXA[\u0001\u0004\ty,A\u0005uS6,7\u000f^1naB\u00191$!1\n\u0007\u0005uC\u0004\u0003\u0005\u0002\u000e\u0006U\u0006\u0019AAc!\u0011\t\t*a2\n\t\u0005%\u0017q\u0014\u0002\u000f\u001f:$\u0016.\\3s\u0007>tG/\u001a=u\u0011!\tI+!.A\u0002\u0005-\u0006bBAh\u0001\u0011\u0005\u0013\u0011[\u0001\u0006G2|7/\u001a\u000b\u0002_\u0002")
public class GroupAggProcessFunction<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final boolean generateRetraction;
    private final StreamQueryConfig queryConfig;
    private GeneratedAggregations function;
    private CRow newRow;
    private CRow prevRow;
    private boolean firstRow;
    private ValueState<Row> state;
    private ValueState<Long> cntState;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        GroupAggProcessFunction groupAggProcessFunction = this;
        synchronized (groupAggProcessFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private GeneratedAggregationsFunction genAggregations() {
        return this.genAggregations;
    }

    private RowTypeInfo aggregationStateType() {
        return this.aggregationStateType;
    }

    private boolean generateRetraction() {
        return this.generateRetraction;
    }

    private StreamQueryConfig queryConfig() {
        return this.queryConfig;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    private CRow newRow() {
        return this.newRow;
    }

    private void newRow_$eq(CRow x$1) {
        this.newRow = x$1;
    }

    private CRow prevRow() {
        return this.prevRow;
    }

    private void prevRow_$eq(CRow x$1) {
        this.prevRow = x$1;
    }

    private boolean firstRow() {
        return this.firstRow;
    }

    private void firstRow_$eq(boolean x$1) {
        this.firstRow = x$1;
    }

    private ValueState<Row> state() {
        return this.state;
    }

    private void state_$eq(ValueState<Row> x$1) {
        this.state = x$1;
    }

    private ValueState<Long> cntState() {
        return this.cntState;
    }

    private void cntState_$eq(ValueState<Long> x$1) {
        this.cntState = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(36).append("Compiling AggregateHelper: ").append(this.genAggregations()).append(".name \n\n ").append(new StringBuilder(11).append("Code:\n").append(this.genAggregations()).append(".code").toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations().name(), this.genAggregations().code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.newRow_$eq(new CRow(this.function().createOutputRow(), true));
        this.prevRow_$eq(new CRow(this.function().createOutputRow(), false));
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("GroupAggregateState", (TypeInformation)this.aggregationStateType());
        this.state_$eq((ValueState<Row>)this.getRuntimeContext().getState(stateDescriptor));
        ValueStateDescriptor inputCntDescriptor = new ValueStateDescriptor("GroupAggregateInputCounter", Types.LONG());
        this.cntState_$eq((ValueState<Long>)this.getRuntimeContext().getState(inputCntDescriptor));
        this.initCleanupTimeState("GroupAggregateCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        long currentTime = ctx.timerService().currentProcessingTime();
        this.processCleanupTimer(ctx, currentTime);
        Row input = inputC.row();
        Row accumulators = (Row)this.state().value();
        Long inputCnt = (Long)this.cntState().value();
        if (accumulators == null) {
            if (!inputC.change()) {
                return;
            }
            this.firstRow_$eq(true);
            accumulators = this.function().createAccumulators();
        } else {
            this.firstRow_$eq(false);
        }
        if (inputCnt == null) {
            inputCnt = Predef$.MODULE$.long2Long(0L);
        }
        this.function().setForwardedFields(input, this.newRow().row());
        this.function().setForwardedFields(input, this.prevRow().row());
        this.function().setAggregationResults(accumulators, this.prevRow().row());
        if (inputC.change()) {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) + 1L);
            this.function().accumulate(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        } else {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) - 1L);
            this.function().retract(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        }
        if (!BoxesRunTime.equalsNumObject((Number)inputCnt, (Object)BoxesRunTime.boxToInteger((int)0))) {
            this.state().update((Object)accumulators);
            this.cntState().update((Object)inputCnt);
            if (!this.firstRow()) {
                if (this.prevRow().row().equals((Object)this.newRow().row()) && !this.stateCleaningEnabled()) {
                    return;
                }
                if (this.generateRetraction()) {
                    out.collect((Object)this.prevRow());
                }
            }
            out.collect((Object)this.newRow());
        } else {
            out.collect((Object)this.prevRow());
            this.state().clear();
            this.cntState().clear();
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        block0: {
            if (!this.stateCleaningEnabled()) break block0;
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.state(), this.cntState()}));
            this.function().cleanup();
        }
    }

    public void close() {
        this.function().close();
    }

    public GroupAggProcessFunction(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, boolean generateRetraction, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.generateRetraction = generateRetraction;
        this.queryConfig = queryConfig;
        super(queryConfig);
        Compiler.$init$(this);
        Logging.$init$(this);
    }
}

