/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.CalciteConfig;
import org.apache.flink.table.calcite.CalciteConfig$;
import org.apache.flink.table.calcite.CalciteParser;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.executor.StreamExecutor;
import org.apache.flink.table.explain.PlanJsonParser;
import org.apache.flink.table.expressions.ExpressionBridge;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.expressions.PlannerExpressionConverter$;
import org.apache.flink.table.expressions.PlannerTypeInferenceUtilImpl;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.UnregisteredSinkModifyOperation;
import org.apache.flink.table.plan.StreamOptimizer;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.plan.util.UpdatingPlanChecker$;
import org.apache.flink.table.planner.DataStreamConversions$;
import org.apache.flink.table.planner.ParserImpl;
import org.apache.flink.table.planner.PlanningConfigurationBuilder;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.OverwritableTableSink;
import org.apache.flink.table.sinks.PartitionableTableSink;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.TableSinkUtils$;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.util.JavaScalaConversionUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rEc\u0001B\u0001\u0003\u00015\u0011Qb\u0015;sK\u0006l\u0007\u000b\\1o]\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0001H.\u00198oKJT!!\u0002\u0004\u0002\u000bQ\f'\r\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dY\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\t!\u0002Z3mK\u001e\fG/[8o\u0013\tY\u0002DA\u0004QY\u0006tg.\u001a:\t\u0011u\u0001!\u0011!Q\u0001\ny\t\u0001\"\u001a=fGV$xN\u001d\t\u0003/}I!\u0001\t\r\u0003\u0011\u0015CXmY;u_JD\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\u0007G>tg-[4\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011aA1qS&\u0011\u0001&\n\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003=1WO\\2uS>t7)\u0019;bY><\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0005\u0003\u001d\u0019\u0017\r^1m_\u001eL!\u0001M\u0017\u0003\u001f\u0019+hn\u0019;j_:\u001c\u0015\r^1m_\u001eD\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u000fG\u0006$\u0018\r\\8h\u001b\u0006t\u0017mZ3s!\taC'\u0003\u00026[\tq1)\u0019;bY><W*\u00198bO\u0016\u0014\b\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\bF\u0003:wqjd\b\u0005\u0002;\u00015\t!\u0001C\u0003\u001em\u0001\u0007a\u0004C\u0003#m\u0001\u00071\u0005C\u0003+m\u0001\u00071\u0006C\u00033m\u0001\u00071\u0007C\u0004A\u0001\t\u0007I\u0011B!\u0002\u001d%tG/\u001a:oC2\u001c6\r[3nCV\t!\t\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!!\u000e\u001a2d\u0015\t9\u0005\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005%#%!D\"bY\u000eLG/Z*dQ\u0016l\u0017\r\u0003\u0004L\u0001\u0001\u0006IAQ\u0001\u0010S:$XM\u001d8bYN\u001b\u0007.Z7bA!9Q\n\u0001b\u0001\n\u0013q\u0015\u0001E3yaJ,7o]5p]\n\u0013\u0018\u000eZ4f+\u0005y\u0005c\u0001)T+6\t\u0011K\u0003\u0002S\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t!\u0016K\u0001\tFqB\u0014Xm]:j_:\u0014%/\u001b3hKB\u0011\u0001KV\u0005\u0003/F\u0013\u0011\u0003\u00157b]:,'/\u0012=qe\u0016\u001c8/[8o\u0011\u0019I\u0006\u0001)A\u0005\u001f\u0006\tR\r\u001f9sKN\u001c\u0018n\u001c8Ce&$w-\u001a\u0011\t\u000fm\u0003!\u0019!C\u00059\u0006a\u0002\u000f\\1o]&twmQ8oM&<WO]1uS>t')^5mI\u0016\u0014X#A/\u0011\u0005ir\u0016BA0\u0003\u0005q\u0001F.\u00198oS:<7i\u001c8gS\u001e,(/\u0019;j_:\u0014U/\u001b7eKJDa!\u0019\u0001!\u0002\u0013i\u0016!\b9mC:t\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\"vS2$WM\u001d\u0011\t\u0011\r\u0004!\u0019!C\u0001\r\u0011\f\u0011b\u001c9uS6L'0\u001a:\u0016\u0003\u0015\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u0003\u0002\tAd\u0017M\\\u0005\u0003U\u001e\u0014qb\u0015;sK\u0006lw\n\u001d;j[&TXM\u001d\u0005\u0007Y\u0002\u0001\u000b\u0011B3\u0002\u0015=\u0004H/[7ju\u0016\u0014\b\u0005\u000b\u0002l]B\u0011qN]\u0007\u0002a*\u0011\u0011OB\u0001\u000bC:tw\u000e^1uS>t\u0017BA:q\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgn\u001a\u0005\bk\u0002\u0011\r\u0011\"\u0003w\u0003\u0019\u0001\u0018M]:feV\tq\u000f\u0005\u0002\u0018q&\u0011\u0011\u0010\u0007\u0002\u0007!\u0006\u00148/\u001a:\t\rm\u0004\u0001\u0015!\u0003x\u0003\u001d\u0001\u0018M]:fe\u0002BQ! \u0001\u0005By\f\u0011bZ3u!\u0006\u00148/\u001a:\u0015\u0003]Dq!!\u0001\u0001\t\u0003\n\u0019!A\u0005ue\u0006t7\u000f\\1uKR!\u0011QAA\u001f!\u0019\t9!!\u0004\u0002\u00125\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017\u0011\u0012\u0001B;uS2LA!a\u0004\u0002\n\t!A*[:ua\u0011\t\u0019\"!\n\u0011\r\u0005U\u0011QDA\u0011\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011a\u00013bO*\u0011aEB\u0005\u0005\u0003?\t9B\u0001\bUe\u0006t7OZ8s[\u0006$\u0018n\u001c8\u0011\t\u0005\r\u0012Q\u0005\u0007\u0001\t-\t9c`A\u0001\u0002\u0003\u0015\t!!\u000b\u0003\u0007}#\u0013'\u0005\u0003\u0002,\u0005]\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0005\u0005E\u0012!B:dC2\f\u0017\u0002BA\u001b\u0003_\u0011qAT8uQ&tw\r\u0005\u0003\u0002.\u0005e\u0012\u0002BA\u001e\u0003_\u00111!\u00118z\u0011\u001d\tyd a\u0001\u0003\u0003\nq\u0002^1cY\u0016|\u0005/\u001a:bi&|gn\u001d\t\u0007\u0003\u000f\ti!a\u0011\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013\u0005\u0003)y\u0007/\u001a:bi&|gn]\u0005\u0005\u0003\u001b\n9EA\bN_\u0012Lg-_(qKJ\fG/[8o\u0011\u001d\t\t\u0006\u0001C!\u0003'\nq!\u001a=qY\u0006Lg\u000e\u0006\u0004\u0002V\u0005-\u0014Q\u000f\t\u0005\u0003/\n)G\u0004\u0003\u0002Z\u0005\u0005\u0004\u0003BA.\u0003_i!!!\u0018\u000b\u0007\u0005}C\"\u0001\u0004=e>|GOP\u0005\u0005\u0003G\ny#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\nIG\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003G\ny\u0003\u0003\u0005\u0002J\u0005=\u0003\u0019AA7!\u0019\t9!!\u0004\u0002pA!\u0011QIA9\u0013\u0011\t\u0019(a\u0012\u0003\u0013=\u0003XM]1uS>t\u0007\u0002CA<\u0003\u001f\u0002\r!!\u001f\u0002\u0011\u0015DH/\u001a8eK\u0012\u0004B!!\f\u0002|%!\u0011QPA\u0018\u0005\u001d\u0011un\u001c7fC:Dq!!!\u0001\t\u0003\n\u0019)\u0001\nhKR\u001cu.\u001c9mKRLwN\u001c%j]R\u001cHCBAC\u0003\u0017\u000by\t\u0005\u0004\u0002.\u0005\u001d\u0015QK\u0005\u0005\u0003\u0013\u000byCA\u0003BeJ\f\u0017\u0010\u0003\u0005\u0002\u000e\u0006}\u0004\u0019AA+\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0003\u0005\u0002\u0012\u0006}\u0004\u0019AAJ\u0003!\u0001xn]5uS>t\u0007\u0003BA\u0017\u0003+KA!a&\u00020\t\u0019\u0011J\u001c;\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u001cR!\u0011QTATa\u0011\ty*a)\u0011\r\u0005U\u0011QDAQ!\u0011\t\u0019#a)\u0005\u0019\u0005\u0015\u0016\u0011TA\u0001\u0002\u0003\u0015\t!!\u000b\u0003\u0007}##\u0007\u0003\u0005\u0002*\u0006e\u0005\u0019AA\"\u00039!\u0018M\u00197f\u001fB,'/\u0019;j_:Dq!!,\u0001\t\u0013\ty+A\tv]^\u0014\u0018\r])vKJL8i\u001c8gS\u001e,\"!!-\u0011\u0007\u0011\n\u0019,C\u0002\u00026\u0016\u0012\u0011c\u0015;sK\u0006l\u0017+^3ss\u000e{gNZ5h\u0011\u001d\t\t\u0006\u0001C\u0005\u0003s#b!a/\u0002@\u0006\u001d\u0007cA\b\u0002>&\u0019\u0011q\r\t\t\u0011\u0005%\u0016q\u0017a\u0001\u0003\u0003\u0004B!!\u0012\u0002D&!\u0011QYA$\u00059\tV/\u001a:z\u001fB,'/\u0019;j_:D\u0001\"!3\u00028\u0002\u0007\u0011\u0011W\u0001\fcV,'/_\"p]\u001aLw\rC\u0004\u0002N\u0002!I!a4\u0002\u001f\u001d,GO\u00127j].\u0004F.\u00198oKJ,\"!!5\u0011\t\u0005M\u0017q[\u0007\u0003\u0003+T!a\u0012\u0003\n\t\u0005e\u0017Q\u001b\u0002\u0011\r2Lgn\u001b)mC:tWM]%na2D\u0001\"!8\u0001\t\u00031\u0011q\\\u0001\u000eO\u0016$(+\u001a7Ck&dG-\u001a:\u0016\u0005\u0005\u0005\b\u0003BAj\u0003GLA!!:\u0002V\nya\t\\5oWJ+GNQ;jY\u0012,'\u000f\u0003\u0005\u0002j\u0002!\tABAv\u0003%9W\r^\"p]\u001aLw-F\u0001$\u0011!\ty\u000f\u0001C\u0001\r\u0005E\u0018aF4fi\u0016CXmY;uS>tWI\u001c<je>tW.\u001a8u+\t\t\u0019\u0010\u0005\u0003\u0002v\n\u0005QBAA|\u0015\u0011\tI0a?\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\u0006\u0004M\u0005u(bAA\u0000\r\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0005\u0007\t9P\u0001\u000eTiJ,\u0017-\\#yK\u000e,H/[8o\u000b:4\u0018N]8o[\u0016tG\u000fC\u0004\u0003\b\u0001!IA!\u0003\u0002\u001fQ\u0014\u0018M\\:mCR,Gk\\\"S_^$bAa\u0003\u0003(\t]\u0002C\u0002B\u0007\u0005'\u00119\"\u0004\u0002\u0003\u0010)!!\u0011CA~\u0003)!\u0017\r^1tiJ,\u0017-\\\u0005\u0005\u0005+\u0011yA\u0001\u0006ECR\f7\u000b\u001e:fC6\u0004BA!\u0007\u0003$5\u0011!1\u0004\u0006\u0005\u0005;\u0011y\"A\u0003usB,7OC\u0002\u0003\"\u0011\tqA];oi&lW-\u0003\u0003\u0003&\tm!\u0001B\"S_^D\u0001B!\u000b\u0003\u0006\u0001\u0007!1F\u0001\fY><\u0017nY1m!2\fg\u000e\u0005\u0003\u0003.\tMRB\u0001B\u0018\u0015\r\u0011\tDR\u0001\u0004e\u0016d\u0017\u0002\u0002B\u001b\u0005_\u0011qAU3m\u001d>$W\r\u0003\u0005\u0002J\n\u0015\u0001\u0019AAY\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{\t1b\u001e:ji\u0016$vnU5oWV!!q\bB0)!\u0011\tEa\u0013\u0003N\t\r\u0004\u0007\u0002B\"\u0005\u000f\u0002b!!\u0006\u0002\u001e\t\u0015\u0003\u0003BA\u0012\u0005\u000f\"AB!\u0013\u0003:\u0005\u0005\t\u0011!B\u0001\u0003S\u00111a\u0018\u00134\u0011!\tIK!\u000fA\u0002\u0005\u0005\u0007\u0002\u0003B(\u0005s\u0001\rA!\u0015\u0002\tMLgn\u001b\t\u0007\u0005'\u0012IF!\u0018\u000e\u0005\tU#b\u0001B,\t\u0005)1/\u001b8lg&!!1\fB+\u0005%!\u0016M\u00197f'&t7\u000e\u0005\u0003\u0002$\t}C\u0001\u0003B1\u0005s\u0011\r!!\u000b\u0003\u0003QC\u0001\"!3\u0003:\u0001\u0007\u0011\u0011\u0017\u0005\b\u0005O\u0002A\u0011\u0002B5\u0003I9(/\u001b;f)>\u0014V\r\u001e:bGR\u001c\u0016N\\6\u0016\t\t-$Q\u0011\u000b\t\u0005[\u0012YHa\"\u0003\nB\"!q\u000eB<!\u0019\u0011iA!\u001d\u0003v%!!1\u000fB\b\u00059!\u0015\r^1TiJ,\u0017-\\*j].\u0004B!a\t\u0003x\u0011a!\u0011\u0010B3\u0003\u0003\u0005\tQ!\u0001\u0002*\t\u0019q\f\n\u001b\t\u0011\t=#Q\ra\u0001\u0005{\u0002bAa\u0015\u0003\u0000\t\r\u0015\u0002\u0002BA\u0005+\u0012aCU3ue\u0006\u001cGo\u0015;sK\u0006lG+\u00192mKNKgn\u001b\t\u0005\u0003G\u0011)\t\u0002\u0005\u0003b\t\u0015$\u0019AA\u0015\u0011!\tIK!\u001aA\u0002\u0005\u0005\u0007\u0002\u0003BF\u0005K\u0002\r!!-\u0002#M$(/Z1n#V,'/_\"p]\u001aLw\rC\u0004\u0003\u0010\u0002!IA!%\u0002#]\u0014\u0018\u000e^3U_\u0006\u0003\b/\u001a8e'&t7.\u0006\u0003\u0003\u0014\n%F\u0003\u0003BK\u0005?\u0013YK!,1\t\t]%1\u0014\t\u0007\u0005\u001b\u0011\tH!'\u0011\t\u0005\r\"1\u0014\u0003\r\u0005;\u0013i)!A\u0001\u0002\u000b\u0005\u0011\u0011\u0006\u0002\u0004?\u0012*\u0004\u0002\u0003B(\u0005\u001b\u0003\rA!)\u0011\r\tM#1\u0015BT\u0013\u0011\u0011)K!\u0016\u0003+\u0005\u0003\b/\u001a8e'R\u0014X-Y7UC\ndWmU5oWB!\u00111\u0005BU\t!\u0011\tG!$C\u0002\u0005%\u0002\u0002CAU\u0005\u001b\u0003\r!!1\t\u0011\t-%Q\u0012a\u0001\u0003cCqA!-\u0001\t\u0013\u0011\u0019,A\txe&$X\rV8VaN,'\u000f^*j].,BA!.\u0003LRA!q\u0017Ba\u0005\u001b\u0014y\r\r\u0003\u0003:\nu\u0006C\u0002B\u0007\u0005c\u0012Y\f\u0005\u0003\u0002$\tuF\u0001\u0004B`\u0005_\u000b\t\u0011!A\u0003\u0002\u0005%\"aA0%m!A!q\nBX\u0001\u0004\u0011\u0019\r\u0005\u0004\u0003T\t\u0015'\u0011Z\u0005\u0005\u0005\u000f\u0014)FA\u000bVaN,'\u000f^*ue\u0016\fW\u000eV1cY\u0016\u001c\u0016N\\6\u0011\t\u0005\r\"1\u001a\u0003\t\u0005C\u0012yK1\u0001\u0002*!A\u0011\u0011\u0016BX\u0001\u0004\t\t\r\u0003\u0005\u0003\f\n=\u0006\u0019AAY\u0011\u001d\u0011\u0019\u000e\u0001C\u0005\u0005+\fq\u0002\u001e:b]Nd\u0017\r^3U_RK\b/Z\u000b\u0005\u0005/\u0014i\u000e\u0006\u0007\u0003Z\n\u0005(1\u001dBs\u0005S\u0014i\u000f\u0005\u0004\u0003\u000e\tM!1\u001c\t\u0005\u0003G\u0011i\u000e\u0002\u0005\u0003`\nE'\u0019AA\u0015\u0005\u0005\t\u0005bB\u0003\u0003R\u0002\u0007\u0011\u0011\u0019\u0005\t\u0003\u0013\u0014\t\u000e1\u0001\u00022\"A!q\u001dBi\u0001\u0004\tI(A\nva\u0012\fG/Z:BgJ+GO]1di&|g\u000e\u0003\u0005\u0003l\nE\u0007\u0019AA=\u000399\u0018\u000e\u001e5DQ\u0006tw-\u001a$mC\u001eD\u0001Ba<\u0003R\u0002\u0007!\u0011_\u0001\u0004iB,\u0007C\u0002Bz\u0005{\u0014Y.\u0004\u0002\u0003v*!!q\u001fB}\u0003!!\u0018\u0010]3j]\u001a|'\u0002\u0002B~\u00037\taaY8n[>t\u0017\u0002\u0002B\u0000\u0005k\u0014q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\b\u0007\u0007\u0001A\u0011BB\u0003\u0003I!(/\u00198tY\u0006$Xm\u00149uS6L'0\u001a3\u0016\t\r\u001d1Q\u0002\u000b\r\u0007\u0013\u0019yaa\u0005\u0004\u001e\r\u000521\u0005\t\u0007\u0005\u001b\u0011\u0019ba\u0003\u0011\t\u0005\r2Q\u0002\u0003\t\u0005?\u001c\tA1\u0001\u0002*!A1\u0011CB\u0001\u0001\u0004\u0011Y#A\u0007paRLW.\u001b>fIBc\u0017M\u001c\u0005\t\u0007+\u0019\t\u00011\u0001\u0004\u0018\u0005iAn\\4jG\u0006d7k\u00195f[\u0006\u00042\u0001JB\r\u0013\r\u0019Y\"\n\u0002\f)\u0006\u0014G.Z*dQ\u0016l\u0017\r\u0003\u0005\u0003p\u000e\u0005\u0001\u0019AB\u0010!\u0019\u0011\u0019P!@\u0004\f!A\u0011\u0011ZB\u0001\u0001\u0004\t\t\f\u0003\u0005\u0003l\u000e\u0005\u0001\u0019AA=\u0011\u001d\u00199\u0003\u0001C\u0005\u0007S\tabZ3u)\u0006\u0014G.Z*dQ\u0016l\u0017\r\u0006\u0004\u0004\u0018\r-2q\u0006\u0005\t\u0007[\u0019)\u00031\u0001\u0002\u0006\u0006iqN]5hS:\fGNT1nKND\u0001b!\u0005\u0004&\u0001\u0007!1\u0006\u0005\b\u0007g\u0001A\u0011BB\u001b\u000319W\r\u001e+bE2,7+\u001b8l)\u0011\u00199da\u0012\u0011\r\u000552\u0011HB\u001f\u0013\u0011\u0019Y$a\f\u0003\r=\u0003H/[8oa\u0011\u0019yda\u0011\u0011\r\tM#\u0011LB!!\u0011\t\u0019ca\u0011\u0005\u0019\r\u00153\u0011GA\u0001\u0002\u0003\u0015\t!!\u000b\u0003\u0007}#s\u0007\u0003\u0005\u0004J\rE\u0002\u0019AB&\u0003Ay'M[3di&#WM\u001c;jM&,'\u000fE\u0002-\u0007\u001bJ1aa\u0014.\u0005Ay%M[3di&#WM\u001c;jM&,'\u000f")
public class StreamPlanner
implements Planner {
    private final Executor executor;
    private final TableConfig config;
    private final CatalogManager catalogManager;
    private final CalciteSchema internalSchema;
    private final ExpressionBridge<PlannerExpression> expressionBridge;
    private final PlanningConfigurationBuilder org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder;
    @VisibleForTesting
    private final StreamOptimizer optimizer;
    private final Parser parser;

    private CalciteSchema internalSchema() {
        return this.internalSchema;
    }

    private ExpressionBridge<PlannerExpression> expressionBridge() {
        return this.expressionBridge;
    }

    public PlanningConfigurationBuilder org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder() {
        return this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder;
    }

    public StreamOptimizer optimizer() {
        return this.optimizer;
    }

    private Parser parser() {
        return this.parser;
    }

    public Parser getParser() {
        return this.parser();
    }

    public List<Transformation<?>> translate(List<ModifyOperation> tableOperations) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableOperations).asScala()).map((Function1 & Serializable & scala.Serializable)tableOperation -> this.translate((ModifyOperation)tableOperation), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamPlanner.$anonfun$translate$2(x$1)))).asJava();
    }

    public String explain(List<Operation> operations, boolean extended) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Operation operation = x0$1;
            if (!(operation instanceof QueryOperation)) {
                throw new TableException(new StringBuilder(17).append(operation.getClass().getCanonicalName()).append(" is not supported").toString());
            }
            QueryOperation queryOperation = (QueryOperation)operation;
            String string = this.explain(queryOperation, this.unwrapQueryConfig());
            return string;
        }, Buffer$.MODULE$.canBuildFrom())).mkString(new StringBuilder(0).append(System.lineSeparator()).append(System.lineSeparator()).toString());
    }

    public String[] getCompletionHints(String statement, int position) {
        FlinkPlannerImpl planner = this.org$apache$flink$table$planner$StreamPlanner$$getFlinkPlanner();
        return planner.getCompletionHints(statement, position);
    }

    private Transformation<?> translate(ModifyOperation tableOperation) {
        Transformation transformation;
        ModifyOperation modifyOperation = tableOperation;
        if (modifyOperation instanceof UnregisteredSinkModifyOperation) {
            UnregisteredSinkModifyOperation unregisteredSinkModifyOperation = (UnregisteredSinkModifyOperation)modifyOperation;
            transformation = this.writeToSink(unregisteredSinkModifyOperation.getChild(), unregisteredSinkModifyOperation.getSink(), this.unwrapQueryConfig());
        } else if (modifyOperation instanceof CatalogSinkModifyOperation) {
            Transformation t;
            CatalogSinkModifyOperation catalogSinkModifyOperation = (CatalogSinkModifyOperation)modifyOperation;
            Option option = this.getTableSink(catalogSinkModifyOperation.getTableIdentifier()).map((Function1 & Serializable & scala.Serializable)sink -> {
                TableSinkUtils$.MODULE$.validateSink(catalogSinkModifyOperation.getStaticPartitions(), catalogSinkModifyOperation.getChild(), catalogSinkModifyOperation.getTableIdentifier(), (TableSink<?>)sink);
                TableSink tableSink = sink;
                if (tableSink instanceof PartitionableTableSink) {
                    PartitionableTableSink partitionableTableSink = (PartitionableTableSink)tableSink;
                    partitionableTableSink.setStaticPartition(catalogSinkModifyOperation.getStaticPartitions());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                TableSink tableSink2 = sink;
                if (tableSink2 instanceof OverwritableTableSink) {
                    OverwritableTableSink overwritableTableSink = (OverwritableTableSink)tableSink2;
                    overwritableTableSink.setOverwrite(catalogSinkModifyOperation.isOverwrite());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Predef$.MODULE$.assert(!catalogSinkModifyOperation.isOverwrite(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("INSERT OVERWRITE requires ").append(new StringBuilder(18).append(OverwritableTableSink.class.getSimpleName()).append(" but actually got ").toString()).append(sink.getClass().getName()).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return this.writeToSink(catalogSinkModifyOperation.getChild(), (TableSink)sink, this.unwrapQueryConfig());
            });
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new TableException(new StringBuilder(21).append("Sink ").append(catalogSinkModifyOperation.getTableIdentifier()).append(" does not exists").toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Transformation transformation2 = t = (Transformation)some.value();
            transformation = transformation2;
        } else if (modifyOperation instanceof OutputConversionModifyOperation) {
            Tuple2.mcZZ.sp sp2;
            OutputConversionModifyOperation outputConversionModifyOperation = (OutputConversionModifyOperation)modifyOperation;
            OutputConversionModifyOperation.UpdateMode updateMode = outputConversionModifyOperation.getUpdateMode();
            if (OutputConversionModifyOperation.UpdateMode.RETRACT.equals(updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(true, true);
            } else if (OutputConversionModifyOperation.UpdateMode.APPEND.equals(updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(false, false);
            } else if (OutputConversionModifyOperation.UpdateMode.UPSERT.equals(updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(false, true);
            } else {
                throw new MatchError((Object)updateMode);
            }
            Tuple2.mcZZ.sp sp3 = sp2;
            if (sp3 == null) {
                throw new MatchError((Object)sp3);
            }
            boolean isRetract = sp3._1$mcZ$sp();
            boolean withChangeFlag = sp3._2$mcZ$sp();
            Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(isRetract, withChangeFlag);
            Tuple2.mcZZ.sp sp5 = sp4;
            boolean isRetract2 = sp5._1$mcZ$sp();
            boolean withChangeFlag2 = sp5._2$mcZ$sp();
            transformation = this.translateToType(tableOperation.getChild(), this.unwrapQueryConfig(), isRetract2, withChangeFlag2, TypeConversions.fromDataTypeToLegacyInfo((DataType)outputConversionModifyOperation.getType())).getTransformation();
        } else {
            throw new TableException(new StringBuilder(29).append("Unsupported ModifyOperation: ").append(tableOperation).toString());
        }
        return transformation;
    }

    private StreamQueryConfig unwrapQueryConfig() {
        return new StreamQueryConfig(this.config.getMinIdleStateRetentionTime(), this.config.getMaxIdleStateRetentionTime());
    }

    private String explain(QueryOperation tableOperation, StreamQueryConfig queryConfig) {
        RelNode ast = this.getRelBuilder().tableOperation(tableOperation).build();
        RelNode optimizedPlan = this.optimizer().optimize(ast, false, this.getRelBuilder());
        DataStream<CRow> dataStream = this.translateToCRow(optimizedPlan, queryConfig);
        StreamExecutionEnvironment env = dataStream.getExecutionEnvironment();
        String jsonSqlPlan = env.getExecutionPlan();
        String sqlPlan = PlanJsonParser.getSqlExecutionPlan(jsonSqlPlan, Predef$.MODULE$.boolean2Boolean(false));
        return new StringBuilder(83).append("== Abstract Syntax Tree ==").append(System.lineSeparator()).append(String.valueOf(RelOptUtil.toString(ast))).append(System.lineSeparator()).append("== Optimized Logical Plan ==").append(System.lineSeparator()).append(String.valueOf(RelOptUtil.toString(optimizedPlan))).append(System.lineSeparator()).append("== Physical Execution Plan ==").append(System.lineSeparator()).append(String.valueOf(sqlPlan)).toString();
    }

    public FlinkPlannerImpl org$apache$flink$table$planner$StreamPlanner$$getFlinkPlanner() {
        String currentCatalogName = this.catalogManager.getCurrentCatalog();
        String currentDatabase = this.catalogManager.getCurrentDatabase();
        return this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder().createFlinkPlanner(currentCatalogName, currentDatabase);
    }

    public FlinkRelBuilder getRelBuilder() {
        String currentCatalogName = this.catalogManager.getCurrentCatalog();
        String currentDatabase = this.catalogManager.getCurrentDatabase();
        return this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder().createRelBuilder(currentCatalogName, currentDatabase);
    }

    public TableConfig getConfig() {
        return this.config;
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return ((StreamExecutor)this.executor).getExecutionEnvironment();
    }

    private DataStream<CRow> translateToCRow(RelNode logicalPlan, StreamQueryConfig queryConfig) {
        RelNode relNode = logicalPlan;
        if (!(relNode instanceof DataStreamRel)) {
            throw new TableException("Cannot generate DataStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
        }
        DataStreamRel dataStreamRel = (DataStreamRel)relNode;
        this.getExecutionEnvironment().configure((ReadableConfig)this.config.getConfiguration(), Thread.currentThread().getContextClassLoader());
        DataStream<CRow> dataStream = dataStreamRel.translateToPlan(this, queryConfig);
        return dataStream;
    }

    private <T> Transformation<?> writeToSink(QueryOperation tableOperation, TableSink<T> sink, StreamQueryConfig queryConfig) {
        DataStreamSink<?> dataStreamSink;
        TableSink<T> tableSink = sink;
        if (tableSink instanceof RetractStreamTableSink) {
            RetractStreamTableSink retractStreamTableSink = (RetractStreamTableSink)tableSink;
            RetractStreamTableSink retractStreamTableSink2 = retractStreamTableSink;
            if (retractStreamTableSink2 instanceof PartitionableTableSink) {
                throw new TableException("Partitionable sink in retract stream mode is not supported yet!");
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            dataStreamSink = this.writeToRetractSink(retractStreamTableSink, tableOperation, queryConfig);
        } else if (tableSink instanceof UpsertStreamTableSink) {
            UpsertStreamTableSink upsertStreamTableSink = (UpsertStreamTableSink)tableSink;
            UpsertStreamTableSink upsertStreamTableSink2 = upsertStreamTableSink;
            if (upsertStreamTableSink2 instanceof PartitionableTableSink) {
                throw new TableException("Partitionable sink in upsert stream mode is not supported yet!");
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            dataStreamSink = this.writeToUpsertSink(upsertStreamTableSink, tableOperation, queryConfig);
        } else if (tableSink instanceof AppendStreamTableSink) {
            AppendStreamTableSink appendStreamTableSink = (AppendStreamTableSink)tableSink;
            dataStreamSink = this.writeToAppendSink(appendStreamTableSink, tableOperation, queryConfig);
        } else {
            throw new ValidationException("Stream Tables can only be emitted by AppendStreamTableSink, RetractStreamTableSink, or UpsertStreamTableSink.");
        }
        DataStreamSink<?> resultSink = dataStreamSink;
        return resultSink != null ? resultSink.getTransformation() : null;
    }

    private <T> DataStreamSink<?> writeToRetractSink(RetractStreamTableSink<T> sink, QueryOperation tableOperation, StreamQueryConfig streamQueryConfig) {
        TypeInformation outputType = TypeConversions.fromDataTypeToLegacyInfo((DataType)sink.getConsumedDataType());
        DataStream result = this.translateToType(tableOperation, streamQueryConfig, true, true, outputType);
        return sink.consumeDataStream(result);
    }

    private <T> DataStreamSink<?> writeToAppendSink(AppendStreamTableSink<T> sink, QueryOperation tableOperation, StreamQueryConfig streamQueryConfig) {
        RelNode relNode = this.getRelBuilder().tableOperation(tableOperation).build();
        RelNode optimizedPlan = this.optimizer().optimize(relNode, false, this.getRelBuilder());
        if (!UpdatingPlanChecker$.MODULE$.isAppendOnly(optimizedPlan)) {
            throw new TableException("AppendStreamTableSink requires that Table has only insert changes.");
        }
        TypeInformation outputType = TypeConversions.fromDataTypeToLegacyInfo((DataType)sink.getConsumedDataType());
        TableSchema resultType = this.getTableSchema(tableOperation.getTableSchema().getFieldNames(), optimizedPlan);
        DataStream result = this.translateOptimized(optimizedPlan, resultType, outputType, streamQueryConfig, false);
        return sink.consumeDataStream(result);
    }

    /*
     * Unable to fully structure code
     */
    private <T> DataStreamSink<?> writeToUpsertSink(UpsertStreamTableSink<T> sink, QueryOperation tableOperation, StreamQueryConfig streamQueryConfig) {
        block4: {
            block3: {
                relNode = this.getRelBuilder().tableOperation(tableOperation).build();
                optimizedPlan = this.optimizer().optimize(relNode, false, this.getRelBuilder());
                isAppendOnlyTable = UpdatingPlanChecker$.MODULE$.isAppendOnly(optimizedPlan);
                sink.setIsAppendOnly(Predef$.MODULE$.boolean2Boolean(isAppendOnlyTable));
                sinkFieldNames = sink.getTableSchema().getFieldNames();
                tableKeys = UpdatingPlanChecker$.MODULE$.getUniqueKeyFields(optimizedPlan, sinkFieldNames);
                var10_9 = false;
                var11_10 = null;
                var12_11 = tableKeys;
                if (!(var12_11 instanceof Some)) break block3;
                var13_12 = (Some)var12_11;
                keys = (String[])var13_12.value();
                sink.setKeyFields(keys);
                var4_14 = BoxedUnit.UNIT;
                break block4;
            }
            if (!None$.MODULE$.equals(var12_11)) ** GOTO lbl-1000
            var10_9 = true;
            var11_10 = var12_11;
            if (isAppendOnlyTable) {
                sink.setKeyFields(null);
                var4_15 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 2 sources

            {
                if (var10_9 && !isAppendOnlyTable) {
                    throw new TableException("UpsertStreamTableSink requires that Table has full primary keys if it is updated.");
                }
                throw new MatchError(var12_11);
            }
        }
        outputType = TypeConversions.fromDataTypeToLegacyInfo((DataType)sink.getConsumedDataType());
        resultType = this.getTableSchema(tableOperation.getTableSchema().getFieldNames(), optimizedPlan);
        result = this.translateOptimized(optimizedPlan, resultType, outputType, streamQueryConfig, true);
        return sink.consumeDataStream(result);
    }

    private <A> DataStream<A> translateToType(QueryOperation table, StreamQueryConfig queryConfig, boolean updatesAsRetraction, boolean withChangeFlag, TypeInformation<A> tpe) {
        RelNode relNode = this.getRelBuilder().tableOperation(table).build();
        RelNode dataStreamPlan = this.optimizer().optimize(relNode, updatesAsRetraction, this.getRelBuilder());
        TableSchema rowType = this.getTableSchema(table.getTableSchema().getFieldNames(), dataStreamPlan);
        if (!withChangeFlag && !UpdatingPlanChecker$.MODULE$.isAppendOnly(dataStreamPlan)) {
            throw new ValidationException("Table is not an append-only table. Use the toRetractStream() in order to handle add and retract messages.");
        }
        return this.translateOptimized(dataStreamPlan, rowType, tpe, queryConfig, withChangeFlag);
    }

    private <A> DataStream<A> translateOptimized(RelNode optimizedPlan, TableSchema logicalSchema, TypeInformation<A> tpe, StreamQueryConfig queryConfig, boolean withChangeFlag) {
        DataStream<CRow> dataStream = this.translateToCRow(optimizedPlan, queryConfig);
        return DataStreamConversions$.MODULE$.convert(dataStream, logicalSchema, withChangeFlag, tpe, this.config);
    }

    private TableSchema getTableSchema(String[] originalNames, RelNode optimizedPlan) {
        DataType[] fieldTypes = (DataType[])((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(optimizedPlan.getRowType().getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getType(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)relDataType -> FlinkTypeFactory$.MODULE$.toTypeInfo((RelDataType)relDataType), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> TypeConversions.fromLegacyInfoToDataType((TypeInformation)x$1), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
        return TableSchema.builder().fields(originalNames, fieldTypes).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<TableSink<?>> getTableSink(ObjectIdentifier objectIdentifier) {
        Optional sink;
        boolean bl = false;
        Some some = null;
        Option option = JavaScalaConversionUtil$.MODULE$.toScala(this.catalogManager.getTable(objectIdentifier)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getTable());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            CatalogBaseTable s = (CatalogBaseTable)some.value();
            if (s instanceof ConnectorCatalogTable) {
                return JavaScalaConversionUtil$.MODULE$.toScala(((ConnectorCatalogTable)s).getTableSink());
            }
        }
        if (!bl) return None$.MODULE$;
        CatalogBaseTable s = (CatalogBaseTable)some.value();
        if (!(s instanceof CatalogTable)) return None$.MODULE$;
        Optional catalog = this.catalogManager.getCatalog(objectIdentifier.getCatalogName());
        CatalogTable catalogTable = (CatalogTable)s;
        if (catalog.isPresent() && ((Catalog)catalog.get()).getTableFactory().isPresent() && (sink = TableFactoryUtil.createTableSinkForCatalogTable((Catalog)((Catalog)catalog.get()), (CatalogTable)catalogTable, (ObjectPath)objectIdentifier.toObjectPath())).isPresent()) {
            return Option$.MODULE$.apply(sink.get());
        }
        Map sinkProperties = catalogTable.toProperties();
        return Option$.MODULE$.apply((Object)((TableSinkFactory)TableFactoryService.find(TableSinkFactory.class, (Map)sinkProperties)).createTableSink(sinkProperties));
    }

    public static final /* synthetic */ boolean $anonfun$translate$2(Object x$1) {
        return Objects.nonNull(x$1);
    }

    public StreamPlanner(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this.executor = executor;
        this.config = config;
        this.catalogManager = catalogManager;
        functionCatalog.setPlannerTypeInferenceUtil(PlannerTypeInferenceUtilImpl.INSTANCE);
        this.internalSchema = CalciteSchemaBuilder.asRootSchema(new CatalogManagerCalciteSchema(catalogManager, true));
        this.expressionBridge = new ExpressionBridge((FunctionLookup)functionCatalog, PlannerExpressionConverter$.MODULE$.INSTANCE());
        this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder = new PlanningConfigurationBuilder(config, functionCatalog, this.internalSchema(), this.expressionBridge());
        this.optimizer = new StreamOptimizer((Function0<CalciteConfig>)(Function0 & Serializable & scala.Serializable)() -> $this.config.getPlannerConfig().unwrap(CalciteConfig.class).orElse(CalciteConfig$.MODULE$.DEFAULT()), this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder());
        this.parser = new ParserImpl(catalogManager, new Supplier<FlinkPlannerImpl>(this){
            private final /* synthetic */ StreamPlanner $outer;

            public FlinkPlannerImpl get() {
                return this.$outer.org$apache$flink$table$planner$StreamPlanner$$getFlinkPlanner();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Supplier<CalciteParser>(this){
            private final /* synthetic */ StreamPlanner $outer;

            public CalciteParser get() {
                return this.$outer.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder().createCalciteParser();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

