/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner;

import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.codegen.FunctionCodeGenerator;
import org.apache.flink.table.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.codegen.GeneratedExpression;
import org.apache.flink.table.codegen.GeneratedFunction;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.types.Row;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class Conversions$ {
    public static Conversions$ MODULE$;

    static {
        new Conversions$();
    }

    public <OUT> Option<GeneratedFunction<MapFunction<Row, OUT>, OUT>> generateRowConverterFunction(TypeInformation<Row> physicalInputType, TableSchema logicalInputSchema, TypeInformation<OUT> requestedOutputType, String functionName, TableConfig config) {
        TypeInformation typeInfo;
        TypeInformation typeInformation = typeInfo = logicalInputSchema.toRowType();
        TypeInformation<Row> typeInformation2 = physicalInputType;
        if (typeInformation == null ? typeInformation2 != null : !typeInformation.equals(typeInformation2)) {
            throw new TableException(new StringBuilder(122).append("The field types of physical and logical row types do not match. ").append(new StringBuilder(41).append("Physical type is [").append(typeInfo).append("], Logical type is [").append(physicalInputType).append("]. ").toString()).append("This is a bug and should not happen. Please file an issue.").toString());
        }
        if (requestedOutputType instanceof GenericTypeInfo) {
            Class clazz = requestedOutputType.getTypeClass();
            Class<Row> clazz2 = Row.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                return None$.MODULE$;
            }
        }
        TypeInformation[] fieldTypes = logicalInputSchema.getFieldTypes();
        String[] fieldNames = logicalInputSchema.getFieldNames();
        if (requestedOutputType.getArity() != fieldTypes.length) {
            throw new TableException(new StringBuilder(37).append("Arity [").append(fieldTypes.length).append("] of result [").append(fieldTypes).append("] does not match ").append(new StringBuilder(34).append("the number[").append(requestedOutputType.getArity()).append("] of requested type [").append(requestedOutputType).append("].").toString()).toString());
        }
        TypeInformation<OUT> typeInformation3 = requestedOutputType;
        if (typeInformation3 instanceof PojoTypeInfo) {
            PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInformation3;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Conversions$.$anonfun$generateRowConverterFunction$1(pojoTypeInfo, x0$1);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (typeInformation3 instanceof TupleTypeInfoBase) {
            TupleTypeInfoBase tupleTypeInfoBase = (TupleTypeInfoBase)typeInformation3;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldTypes)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Conversions$.$anonfun$generateRowConverterFunction$2(tupleTypeInfoBase, x0$2);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (typeInformation3 != null) {
            TypeInformation<OUT> typeInformation4 = typeInformation3;
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldTypes)).size() != 1) {
                throw new TableException(new StringBuilder(44).append("Requested result type is an atomic type but ").append(new StringBuilder(46).append("result[").append(fieldTypes).append("] has more or less than a single field.").toString()).toString());
            }
            TypeInformation requestedTypeInfo = (TypeInformation)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldTypes)).head();
            Conversions$.validateFieldType$1(requestedTypeInfo);
            TypeInformation typeInformation5 = requestedTypeInfo;
            TypeInformation<OUT> typeInformation6 = typeInformation4;
            if (typeInformation5 == null ? typeInformation6 != null : !typeInformation5.equals(typeInformation6)) {
                throw new TableException(new StringBuilder(44).append("Result field does not match requested type. ").append(new StringBuilder(21).append("Requested: ").append(typeInformation4).append("; Actual: ").append(requestedTypeInfo).toString()).toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new TableException(new StringBuilder(25).append("Unsupported result type: ").append(requestedOutputType).toString());
        }
        FunctionCodeGenerator generator = new FunctionCodeGenerator(config, false, physicalInputType, (Option<TypeInformation<?>>)None$.MODULE$, (Option<int[]>)None$.MODULE$, FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$6());
        GeneratedExpression conversion = generator.generateConverterResultExpression(requestedOutputType, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])fieldNames), generator.generateConverterResultExpression$default$3());
        String body = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(conversion.code()).append("\n         |return ").append(conversion.resultTerm()).append(";\n         |").toString())).stripMargin();
        GeneratedFunction<MapFunction, OUT> generated = generator.generateFunction(functionName, MapFunction.class, body, requestedOutputType);
        return new Some(generated);
    }

    private static final void validateFieldType$1(TypeInformation fieldType) {
        TypeInformation typeInformation = fieldType;
        if (typeInformation instanceof TimeIndicatorTypeInfo) {
            throw new TableException("The time indicator type is an internal type only.");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$generateRowConverterFunction$1(PojoTypeInfo x2$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String fName = (String)tuple2._1();
            TypeInformation fType = (TypeInformation)tuple2._2();
            int pojoIdx = x2$1.getFieldIndex(fName);
            if (pojoIdx < 0) {
                throw new TableException(new StringBuilder(33).append("POJO does not define field name: ").append(fName).toString());
            }
            TypeInformation requestedTypeInfo = x2$1.getTypeAt(pojoIdx);
            Conversions$.validateFieldType$1(requestedTypeInfo);
            TypeInformation typeInformation = fType;
            TypeInformation typeInformation2 = requestedTypeInfo;
            if (typeInformation == null ? typeInformation2 != null : !typeInformation.equals(typeInformation2)) {
                throw new TableException(new StringBuilder(44).append("Result field does not match requested type. ").append(new StringBuilder(21).append("Requested: ").append(requestedTypeInfo).append("; Actual: ").append(fType).toString()).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$generateRowConverterFunction$2(TupleTypeInfoBase x3$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TypeInformation fieldTypeInfo = (TypeInformation)tuple2._1();
            int i = tuple2._2$mcI$sp();
            TypeInformation requestedTypeInfo = x3$1.getTypeAt(i);
            Conversions$.validateFieldType$1(requestedTypeInfo);
            TypeInformation typeInformation = fieldTypeInfo;
            TypeInformation typeInformation2 = requestedTypeInfo;
            if (typeInformation == null ? typeInformation2 != null : !typeInformation.equals(typeInformation2)) {
                throw new TableException(new StringBuilder(44).append("Result field does not match requested type. ").append(new StringBuilder(21).append("Requested: ").append(requestedTypeInfo).append("; Actual: ").append(fieldTypeInfo).toString()).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Conversions$() {
        MODULE$ = this;
    }
}

