/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.plan.rules.logical.PushFilterIntoTableSourceScanRule$;
import org.apache.flink.table.plan.util.RexProgramExtractor$;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001E\u0011\u0011\u0005U;tQ\u001aKG\u000e^3s\u0013:$x\u000eV1cY\u0016\u001cv.\u001e:dKN\u001b\u0017M\u001c*vY\u0016T!a\u0001\u0003\u0002\u000f1|w-[2bY*\u0011QAB\u0001\u0006eVdWm\u001d\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019r#D\u0001\u0015\u0015\t9QC\u0003\u0002\u0017\u0019\u000591-\u00197dSR,\u0017B\u0001\r\u0015\u0005)\u0011V\r\\(qiJ+H.\u001a\u0005\u00065\u0001!\taG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003\tAqa\b\u0001C\u0002\u0013%\u0001%\u0001\beK\u001a\fW\u000f\u001c;DCR\fGn\\4\u0016\u0003\u0005\u0002\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\t1\fgn\u001a\u0006\u0002M\u0005!!.\u0019<b\u0013\tA3E\u0001\u0004TiJLgn\u001a\u0005\u0007U\u0001\u0001\u000b\u0011B\u0011\u0002\u001f\u0011,g-Y;mi\u000e\u000bG/\u00197pO\u0002Bq\u0001\f\u0001C\u0002\u0013%Q&\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0005\u0002\u000f\r\fG/\u00197pO&\u00111\u0007\r\u0002\u000f\u0007\u0006$\u0018\r\\8h\u001b\u0006t\u0017mZ3s\u0011\u0019)\u0004\u0001)A\u0005]\u0005y1-\u0019;bY><W*\u00198bO\u0016\u0014\b\u0005C\u00038\u0001\u0011\u0005\u0003(A\u0004nCR\u001c\u0007.Z:\u0015\u0005ez\u0004C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0001Z\u0002\r!Q\u0001\u0005G\u0006dG\u000e\u0005\u0002\u0014\u0005&\u00111\t\u0006\u0002\u000f%\u0016dw\n\u001d;Sk2,7)\u00197m\u0011\u0015)\u0005\u0001\"\u0011G\u0003\u001dyg.T1uG\"$\"a\u0012&\u0011\u0005iB\u0015BA%<\u0005\u0011)f.\u001b;\t\u000b\u0001#\u0005\u0019A!\t\u000b1\u0003A\u0011B'\u0002%A,8\u000f\u001b$jYR,'/\u00138u_N\u001b\u0017M\u001c\u000b\u0007\u000f:{\u0005,X9\t\u000b\u0001[\u0005\u0019A!\t\u000bA[\u0005\u0019A)\u0002\t\r\fGn\u0019\t\u0003%Zk\u0011a\u0015\u0006\u0003\u0007QS!!\u0016\u0004\u0002\u000b9|G-Z:\n\u0005]\u001b&\u0001\u0005$mS:\\Gj\\4jG\u0006d7)\u00197d\u0011\u0015I6\n1\u0001[\u0003\u0011\u00198-\u00198\u0011\u0005I[\u0016B\u0001/T\u0005m1E.\u001b8l\u0019><\u0017nY1m)\u0006\u0014G.Z*pkJ\u001cWmU2b]\")al\u0013a\u0001?\u0006\u0001b-\u001b7uKJ\f'\r\\3T_V\u00148-\u001a\u0019\u0003A\"\u00042!\u00193g\u001b\u0005\u0011'BA2\t\u0003\u001d\u0019x.\u001e:dKNL!!\u001a2\u0003+\u0019KG\u000e^3sC\ndW\rV1cY\u0016\u001cv.\u001e:dKB\u0011q\r\u001b\u0007\u0001\t%IW,!A\u0001\u0002\u000b\u0005!NA\u0002`II\n\"a\u001b8\u0011\u0005ib\u0017BA7<\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AO8\n\u0005A\\$aA!os\")!o\u0013a\u0001g\u0006YA-Z:de&\u0004H/[8o!\t!8P\u0004\u0002vsB\u0011aoO\u0007\u0002o*\u0011\u0001\u0010E\u0001\u0007yI|w\u000e\u001e \n\u0005i\\\u0014A\u0002)sK\u0012,g-\u0003\u0002)y*\u0011!pO\u0004\u0006}\nA\ta`\u0001\"!V\u001c\bNR5mi\u0016\u0014\u0018J\u001c;p)\u0006\u0014G.Z*pkJ\u001cWmU2b]J+H.\u001a\t\u0004;\u0005\u0005aAB\u0001\u0003\u0011\u0003\t\u0019a\u0005\u0003\u0002\u0002\u0005\u0015\u0001c\u0001\u001e\u0002\b%\u0019\u0011\u0011B\u001e\u0003\r\u0005s\u0017PU3g\u0011\u001dQ\u0012\u0011\u0001C\u0001\u0003\u001b!\u0012a \u0005\u000b\u0003#\t\tA1A\u0005\u0002\u0005M\u0011\u0001C%O'R\u000bejQ#\u0016\u0003IA\u0001\"a\u0006\u0002\u0002\u0001\u0006IAE\u0001\n\u0013:\u001bF+\u0011(D\u000b\u0002\u0002")
public class PushFilterIntoTableSourceScanRule
extends RelOptRule {
    private final String defaultCatalog;
    private final CatalogManager catalogManager = new CatalogManager(this.defaultCatalog(), (Catalog)new GenericInMemoryCatalog(this.defaultCatalog(), "default_database"));

    public static RelOptRule INSTANCE() {
        return PushFilterIntoTableSourceScanRule$.MODULE$.INSTANCE();
    }

    private String defaultCatalog() {
        return this.defaultCatalog;
    }

    private CatalogManager catalogManager() {
        return this.catalogManager;
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean bl;
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        TableSource<?> tableSource = scan.tableSource();
        if (tableSource instanceof FilterableTableSource) {
            TableSource<?> tableSource2 = tableSource;
            bl = calc.getProgram().getCondition() != null && !((FilterableTableSource)tableSource2).isFilterPushedDown();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        FilterableTableSource filterableSource = (FilterableTableSource)scan.tableSource();
        this.pushFilterIntoScan(call, calc, scan, filterableSource, this.description);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, FlinkLogicalCalc calc, FlinkLogicalTableSourceScan scan, FilterableTableSource<?> filterableSource, String description) {
        RexProgram newRexProgram;
        RexProgram rexProgram;
        RexNode rexNode;
        Preconditions.checkArgument((!filterableSource.isFilterPushedDown() ? 1 : 0) != 0);
        RexProgram program = calc.getProgram();
        Tuple2<Expression[], RexNode[]> tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, call.builder().getRexBuilder(), new FunctionCatalog(TableConfig.getDefault(), this.catalogManager(), new ModuleManager()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] predicates = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)predicates, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] predicates2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates2)).isEmpty()) {
            return;
        }
        LinkedList remainingPredicates = new LinkedList();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates2)).foreach((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)remainingPredicates.add(e)));
        TableSource newTableSource = filterableSource.applyPredicate(remainingPredicates);
        if (((FilterableTableSource)newTableSource).isFilterPushedDown() && newTableSource.explainSource().equals(scan.tableSource().explainSource())) {
            throw new TableException("Failed to push filter into table source! table source with pushdown capability must override and change explainSource() API to explain the pushdown applied!");
        }
        RelBuilder relBuilder = call.builder();
        if (!remainingPredicates.isEmpty() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2)).nonEmpty()) {
            relBuilder.push(scan);
            Buffer remainingPrecidatesAsExpr = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(remainingPredicates).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> (PlannerExpression)x$2, Buffer$.MODULE$.canBuildFrom());
            Buffer remainingConditions = ((BufferLike)remainingPrecidatesAsExpr.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toRexNode(relBuilder), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2)));
            rexNode = (RexNode)remainingConditions.reduce((Function2 & Serializable & scala.Serializable)(l, r) -> relBuilder.and((RexNode)l, (RexNode)r));
        } else {
            rexNode = null;
        }
        RexNode remainingCondition = rexNode;
        FlinkLogicalTableSourceScan newScan = scan.copy(scan.getTraitSet(), scan.tableSchema(), newTableSource, scan.selectedFields());
        if (remainingCondition != null || !program.projectsOnlyIdentity()) {
            List expandedProjectList = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(program.getProjectList()).asScala()).map((Function1 & Serializable & scala.Serializable)ref -> program.expandLocalRef((RexLocalRef)ref), Buffer$.MODULE$.canBuildFrom())).asJava();
            rexProgram = RexProgram.create(program.getInputRowType(), (List<? extends RexNode>)expandedProjectList, remainingCondition, program.getOutputRowType(), relBuilder.getRexBuilder());
        } else {
            rexProgram = newRexProgram = null;
        }
        if (newRexProgram != null) {
            Calc newCalc = calc.copy(calc.getTraitSet(), newScan, newRexProgram);
            call.transformTo(newCalc);
        } else {
            call.transformTo(newScan);
        }
    }

    public PushFilterIntoTableSourceScanRule() {
        super(RelOptRule.operand(FlinkLogicalCalc.class, RelOptRule.operand(FlinkLogicalTableSourceScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushFilterIntoTableSourceScanRule");
        this.defaultCatalog = "default_catalog";
    }
}

