/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.logical;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.flink.table.plan.nodes.FlinkConventions$;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalJoin;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0005#\tIb\t\\5oW2{w-[2bY*{\u0017N\\\"p]Z,'\u000f^3s\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011!\u00028pI\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'ii\u0011\u0001\u0006\u0006\u0003+Y\tqaY8om\u0016\u0014HO\u0003\u0002\u00181\u0005\u0019!/\u001a7\u000b\u0005ea\u0011aB2bY\u000eLG/Z\u0005\u00037Q\u0011QbQ8om\u0016\u0014H/\u001a:Sk2,\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0003\u0011\u0015\u0011\u0003\u0001\"\u0011$\u0003\u001di\u0017\r^2iKN$\"\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\u000f\t{w\u000e\\3b]\")1&\ta\u0001Y\u0005!1-\u00197m!\tis&D\u0001/\u0015\t9\u0001$\u0003\u00021]\tq!+\u001a7PaR\u0014V\u000f\\3DC2d\u0007\"B\u000b\u0001\t\u0003\u0012DCA\u001a8!\t!T'D\u0001\u0017\u0013\t1dCA\u0004SK2tu\u000eZ3\t\u000b]\t\u0004\u0019A\u001a\t\u000be\u0002A\u0011\u0002\u001e\u0002+!\f7/R9vC2LG/\u001f)sK\u0012L7-\u0019;fgR\u0011Ae\u000f\u0005\u0006ya\u0002\r!P\u0001\tU>Lg.\u00138g_B\u0011a(Q\u0007\u0002\u007f)\u0011\u0001IF\u0001\u0005G>\u0014X-\u0003\u0002C\u007f\tA!j\\5o\u0013:4w\u000eC\u0003E\u0001\u0011%Q)A\bjgNKgn\u001a7f%><(j\\5o)\t!c\tC\u0003H\u0007\u0002\u0007\u0001*\u0001\u0003k_&t\u0007CA%L\u001b\u0005Q%BA\u0002\u0017\u0013\ta%JA\u0006M_\u001eL7-\u00197K_&t\u0007\"\u0002(\u0001\t\u0013y\u0015aC5t'&tw\r\\3S_^$\"\u0001\n)\t\u000bEk\u0005\u0019A\u001a\u0002\t9|G-\u001a")
public class FlinkLogicalJoinConverter
extends ConverterRule {
    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalJoin join = (LogicalJoin)call.rel(0);
        JoinInfo joinInfo = join.analyzeCondition();
        return this.hasEqualityPredicates(joinInfo) || this.isSingleRowJoin(join);
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalJoin join = (LogicalJoin)rel;
        RelTraitSet traitSet = rel.getTraitSet().replace(FlinkConventions$.MODULE$.LOGICAL());
        RelNode newLeft = RelOptRule.convert(join.getLeft(), FlinkConventions$.MODULE$.LOGICAL());
        RelNode newRight = RelOptRule.convert(join.getRight(), FlinkConventions$.MODULE$.LOGICAL());
        return new FlinkLogicalJoin(rel.getCluster(), traitSet, newLeft, newRight, join.getCondition(), join.getJoinType());
    }

    private boolean hasEqualityPredicates(JoinInfo joinInfo) {
        return !joinInfo.pairs().isEmpty();
    }

    private boolean isSingleRowJoin(LogicalJoin join) {
        JoinRelType joinRelType = join.getJoinType();
        boolean bl = ((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType) && (this.isSingleRow(join.getRight()) || this.isSingleRow(join.getLeft())) ? true : (((Object)((Object)JoinRelType.LEFT)).equals((Object)joinRelType) && this.isSingleRow(join.getRight()) ? true : ((Object)((Object)JoinRelType.RIGHT)).equals((Object)joinRelType) && this.isSingleRow(join.getLeft()));
        return bl;
    }

    private boolean isSingleRow(RelNode node) {
        boolean bl;
        RelNode relNode;
        while (true) {
            if ((relNode = node) instanceof RelSubset) {
                RelSubset relSubset = (RelSubset)relNode;
                node = relSubset.getOriginal();
                continue;
            }
            if (relNode instanceof Project) {
                Project project = (Project)relNode;
                node = project.getInput();
                continue;
            }
            if (relNode instanceof Filter) {
                Filter filter = (Filter)relNode;
                node = filter.getInput();
                continue;
            }
            if (!(relNode instanceof Calc)) break;
            Calc calc = (Calc)relNode;
            node = calc.getInput();
        }
        if (relNode instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)relNode;
            bl = aggregate.getGroupSet().isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public FlinkLogicalJoinConverter() {
        super(LogicalJoin.class, Convention.NONE, FlinkConventions$.MODULE$.LOGICAL(), "FlinkLogicalJoinConverter");
    }
}

