/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.dataset;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.PartitionOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.BatchQueryConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.internal.BatchTableEnvImpl;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.codegen.FunctionCodeGenerator;
import org.apache.flink.table.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.codegen.GeneratedExpression;
import org.apache.flink.table.codegen.GeneratedFunction;
import org.apache.flink.table.plan.nodes.CommonJoin;
import org.apache.flink.table.plan.nodes.FlinkRelNode;
import org.apache.flink.table.plan.nodes.dataset.DataSetRel;
import org.apache.flink.table.runtime.FlatJoinRunner;
import org.apache.flink.table.runtime.FullOuterJoinRunner;
import org.apache.flink.table.runtime.LeftFullOuterJoinGroupReduceRunner;
import org.apache.flink.table.runtime.LeftOuterJoinGroupReduceRunner;
import org.apache.flink.table.runtime.LeftOuterJoinRunner;
import org.apache.flink.table.runtime.RightFullOuterJoinGroupReduceRunner;
import org.apache.flink.table.runtime.RightOuterJoinGroupReduceRunner;
import org.apache.flink.table.runtime.RightOuterJoinRunner;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t]g\u0001B\u0001\u0003\u0001E\u00111\u0002R1uCN+GOS8j]*\u00111\u0001B\u0001\bI\u0006$\u0018m]3u\u0015\t)a!A\u0003o_\u0012,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\n\u001b=A\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0004e\u0016d'BA\f\r\u0003\u001d\u0019\u0017\r\\2ji\u0016L!!\u0007\u000b\u0003\u000b\tK'+\u001a7\u0011\u0005maR\"\u0001\u0003\n\u0005u!!AC\"p[6|gNS8j]B\u0011q\u0004I\u0007\u0002\u0005%\u0011\u0011E\u0001\u0002\u000b\t\u0006$\u0018mU3u%\u0016d\u0007\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u000f\rdWo\u001d;feB\u0011QeJ\u0007\u0002M)\u0011qAF\u0005\u0003Q\u0019\u0012QBU3m\u001fB$8\t\\;ti\u0016\u0014\b\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u0011Q\u0014\u0018-\u001b;TKR\u0004\"!\n\u0017\n\u000552#a\u0003*fYR\u0013\u0018-\u001b;TKRD\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\tY\u00164GOT8eKB\u00111#M\u0005\u0003eQ\u0011qAU3m\u001d>$W\r\u0003\u00055\u0001\t\u0005\t\u0015!\u00031\u0003%\u0011\u0018n\u001a5u\u001d>$W\r\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u00039\u0011xn\u001e*fY\u0012\u000bG/\u0019+za\u0016\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\u000b\u0002\tQL\b/Z\u0005\u0003ye\u00121BU3m\t\u0006$\u0018\rV=qK\"Aa\b\u0001B\u0001B\u0003%q(A\u0007k_&t7i\u001c8eSRLwN\u001c\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005Z\t1A]3y\u0013\t!\u0015IA\u0004SKbtu\u000eZ3\t\u0011\u0019\u0003!\u0011!Q\u0001\n]\n1B[8j]J{w\u000fV=qK\"A\u0001\n\u0001B\u0001B\u0003%\u0011*\u0001\u0005k_&t\u0017J\u001c4p!\tQU*D\u0001L\u0015\taE#\u0001\u0003d_J,\u0017B\u0001(L\u0005!Qu.\u001b8J]\u001a|\u0007\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\u0002\u0011-,\u0017\u0010U1jeN\u00042A\u0015/`\u001d\t\u0019\u0016L\u0004\u0002U/6\tQK\u0003\u0002W!\u00051AH]8pizJ\u0011\u0001W\u0001\u0006g\u000e\fG.Y\u0005\u00035n\u000bq\u0001]1dW\u0006<WMC\u0001Y\u0013\tifL\u0001\u0003MSN$(B\u0001.\\!\t\u0001W-D\u0001b\u0015\t\u00117-A\u0004nCB\u0004\u0018N\\4\u000b\u0005\u00114\u0012\u0001B;uS2L!AZ1\u0003\u000f%sG\u000fU1je\"A\u0001\u000e\u0001B\u0001B\u0003%\u0011.\u0001\u0005k_&tG+\u001f9f!\tQ%.\u0003\u0002l\u0017\nY!j\\5o%\u0016dG+\u001f9f\u0011!i\u0007A!A!\u0002\u0013q\u0017\u0001\u00036pS:D\u0015N\u001c;\u0011\u0007=\f\tBD\u0002q\u0003\u0017q1!]A\u0003\u001d\t\u0011xP\u0004\u0002ty:\u0011AO\u001f\b\u0003kft!A\u001e=\u000f\u0005Q;\u0018\"A\b\n\u00055q\u0011BA\u0006\r\u0013\tY(\"A\u0002ba&L!! @\u0002\r\r|W.\\8o\u0015\tY(\"\u0003\u0003\u0002\u0002\u0005\r\u0011!C8qKJ\fGo\u001c:t\u0015\tih0\u0003\u0003\u0002\b\u0005%\u0011\u0001\u00022bg\u0016TA!!\u0001\u0002\u0004%!\u0011QBA\b\u0003AQu.\u001b8Pa\u0016\u0014\u0018\r^8s\u0005\u0006\u001cXM\u0003\u0003\u0002\b\u0005%\u0011\u0002BA\n\u0003+\u0011\u0001BS8j]\"Kg\u000e\u001e\u0006\u0005\u0003\u001b\ty\u0001\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0005\u00037\tqB];mK\u0012+7o\u0019:jaRLwN\u001c\t\u0005\u0003;\t)C\u0004\u0003\u0002 \u0005\u0005\u0002C\u0001+\\\u0013\r\t\u0019cW\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0012\u0011\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r2\fC\u0004\u0002.\u0001!\t!a\f\u0002\rqJg.\u001b;?)i\t\t$a\r\u00026\u0005]\u0012\u0011HA\u001e\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0013qIA%!\ty\u0002\u0001\u0003\u0004$\u0003W\u0001\r\u0001\n\u0005\u0007U\u0005-\u0002\u0019A\u0016\t\r=\nY\u00031\u00011\u0011\u0019!\u00141\u0006a\u0001a!1a'a\u000bA\u0002]BaAPA\u0016\u0001\u0004y\u0004B\u0002$\u0002,\u0001\u0007q\u0007\u0003\u0004I\u0003W\u0001\r!\u0013\u0005\u0007!\u0006-\u0002\u0019A)\t\r!\fY\u00031\u0001j\u0011\u0019i\u00171\u0006a\u0001]\"A\u0011\u0011DA\u0016\u0001\u0004\tY\u0002C\u0004\u0002N\u0001!\t%a\u0014\u0002\u001b\u0011,'/\u001b<f%><H+\u001f9f)\u00059\u0004bBA*\u0001\u0011\u0005\u0013QK\u0001\u0005G>\u0004\u0018\u0010F\u00031\u0003/\nI\u0006\u0003\u0004+\u0003#\u0002\ra\u000b\u0005\t\u00037\n\t\u00061\u0001\u0002^\u00051\u0011N\u001c9viN\u0004R!a\u0018\u0002hAj!!!\u0019\u000b\u0007\u0011\f\u0019G\u0003\u0002\u0002f\u0005!!.\u0019<b\u0013\ri\u0016\u0011\r\u0005\b\u0003W\u0002A\u0011IA7\u0003!!xn\u0015;sS:<GCAA\u000e\u0011\u001d\t\t\b\u0001C!\u0003g\nA\"\u001a=qY\u0006Lg\u000eV3s[N$B!!\u001e\u0002|A\u00191#a\u001e\n\u0007\u0005eDCA\u0005SK2<&/\u001b;fe\"A\u0011QPA8\u0001\u0004\t)(\u0001\u0002qo\"9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0015aD2p[B,H/Z*fY\u001a\u001cun\u001d;\u0015\r\u0005\u0015\u00151RAK!\r)\u0013qQ\u0005\u0004\u0003\u00133#A\u0003*fY>\u0003HoQ8ti\"A\u0011QRA@\u0001\u0004\ty)A\u0004qY\u0006tg.\u001a:\u0011\u0007\u0015\n\t*C\u0002\u0002\u0014\u001a\u0012QBU3m\u001fB$\b\u000b\\1o]\u0016\u0014\b\u0002CAL\u0003\u007f\u0002\r!!'\u0002\u00115,G/\u00193bi\u0006\u0004B!a'\u0002 6\u0011\u0011Q\u0014\u0006\u0004\u0003/#\u0012\u0002BAQ\u0003;\u0013\u0001CU3m\u001b\u0016$\u0018\rZ1uCF+XM]=\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\u0006yAO]1og2\fG/\u001a+p!2\fg\u000e\u0006\u0004\u0002*\u0006}\u0016\u0011\u001b\t\u0007\u0003W\u000by+a-\u000e\u0005\u00055&bAA3}&!\u0011\u0011WAW\u0005\u001d!\u0015\r^1TKR\u0004B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0004\u0003sS\u0011!\u0002;za\u0016\u001c\u0018\u0002BA_\u0003o\u00131AU8x\u0011!\t\t-a)A\u0002\u0005\r\u0017\u0001\u0003;bE2,WI\u001c<\u0011\t\u0005\u0015\u0017QZ\u0007\u0003\u0003\u000fTA!!3\u0002L\u0006A\u0011N\u001c;fe:\fGN\u0003\u0002|\u0011%!\u0011qZAd\u0005E\u0011\u0015\r^2i)\u0006\u0014G.Z#om&k\u0007\u000f\u001c\u0005\t\u0003'\f\u0019\u000b1\u0001\u0002V\u0006Y\u0011/^3ss\u000e{gNZ5h!\u0011\t9.!7\u000e\u0005\u0005-\u0017\u0002BAn\u0003\u0017\u0014\u0001CQ1uG\"\fV/\u001a:z\u0007>tg-[4\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\u0006a\u0011\r\u001a3J]:,'OS8j]Rq\u0011\u0011VAr\u0003O\fY/!@\u0003\u0002\tE\u0001\u0002CAs\u0003;\u0004\r!!+\u0002\t1,g\r\u001e\u0005\t\u0003S\fi\u000e1\u0001\u0002*\u0006)!/[4ii\"A\u0011Q^Ao\u0001\u0004\ty/\u0001\u0005mK\u001a$8*Z=t!\u0019\t\t0a=\u0002x6\t1,C\u0002\u0002vn\u0013Q!\u0011:sCf\u0004B!!=\u0002z&\u0019\u00111`.\u0003\u0007%sG\u000f\u0003\u0005\u0002\u0000\u0006u\u0007\u0019AAx\u0003%\u0011\u0018n\u001a5u\u0017\u0016L8\u000f\u0003\u0005\u0003\u0004\u0005u\u0007\u0019\u0001B\u0003\u0003)\u0011Xm];miRK\b/\u001a\t\u0007\u0005\u000f\u0011i!a-\u000e\u0005\t%!\u0002\u0002B\u0006\u0003\u0007\t\u0001\u0002^=qK&tgm\\\u0005\u0005\u0005\u001f\u0011IAA\bUsB,\u0017J\u001c4pe6\fG/[8o\u0011!\u0011\u0019\"!8A\u0002\tU\u0011AB2p]\u001aLw\r\u0005\u0003\u0002X\n]\u0011\u0002\u0002B\r\u0003\u0017\u00141\u0002V1cY\u0016\u001cuN\u001c4jO\"9!Q\u0004\u0001\u0005\n\t}\u0011\u0001E1eI2+g\r^(vi\u0016\u0014(j\\5o)9\tIK!\t\u0003$\t\u0015\"q\u0005B\u0015\u0005WA\u0001\"!:\u0003\u001c\u0001\u0007\u0011\u0011\u0016\u0005\t\u0003S\u0014Y\u00021\u0001\u0002*\"A\u0011Q\u001eB\u000e\u0001\u0004\ty\u000f\u0003\u0005\u0002\u0000\nm\u0001\u0019AAx\u0011!\u0011\u0019Aa\u0007A\u0002\t\u0015\u0001\u0002\u0003B\n\u00057\u0001\rA!\u0006\t\u000f\t=\u0002\u0001\"\u0003\u00032\u0005\t\u0012\r\u001a3SS\u001eDGoT;uKJTu.\u001b8\u0015\u001d\u0005%&1\u0007B\u001b\u0005o\u0011IDa\u000f\u0003>!A\u0011Q\u001dB\u0017\u0001\u0004\tI\u000b\u0003\u0005\u0002j\n5\u0002\u0019AAU\u0011!\tiO!\fA\u0002\u0005=\b\u0002CA\u0000\u0005[\u0001\r!a<\t\u0011\t\r!Q\u0006a\u0001\u0005\u000bA\u0001Ba\u0005\u0003.\u0001\u0007!Q\u0003\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0003A\tG\r\u001a$vY2|U\u000f^3s\u0015>Lg\u000e\u0006\b\u0002*\n\u0015#q\tB%\u0005\u0017\u0012iEa\u0014\t\u0011\u0005\u0015(q\ba\u0001\u0003SC\u0001\"!;\u0003@\u0001\u0007\u0011\u0011\u0016\u0005\t\u0003[\u0014y\u00041\u0001\u0002p\"A\u0011q B \u0001\u0004\ty\u000f\u0003\u0005\u0003\u0004\t}\u0002\u0019\u0001B\u0003\u0011!\u0011\u0019Ba\u0010A\u0002\tU\u0001b\u0002B*\u0001\u0011%!QK\u0001\u000eO\u0016$(j\\5o\u001fBt\u0015-\\3\u0016\u0005\u0005m\u0001b\u0002B-\u0001\u0011%!1L\u0001\u001aO\u0016$h)\u001e7m\u0013:$\u0017nY5fg^KG\u000f\u001b)sK\u001aL\u0007\u0010\u0006\u0004\u0002p\nu#\u0011\r\u0005\t\u0005?\u00129\u00061\u0001\u0002p\u0006!1.Z=t\u0011!\u0011\u0019Ga\u0016A\u0002\u0005]\u0018!\u00038v[\u001aKW\r\u001c3t\u0011\u001d\u00119\u0007\u0001C\u0005\u0005S\n\u0001\u0003]1si&$\u0018n\u001c8B]\u0012\u001cvN\u001d;\u0015\r\u0005%&1\u000eB8\u0011!\u0011iG!\u001aA\u0002\u0005%\u0016a\u00023bi\u0006\u001cV\r\u001e\u0005\t\u0005c\u0012)\u00071\u0001\u0002p\u0006i\u0001/\u0019:uSRLwN\\&fsNDqA!\u001e\u0001\t\u0013\u00119(A\tg_2$\u0017\nZ3oi&\u001c\u0017\r\u001c*poN$b!!+\u0003z\tm\u0004\u0002\u0003B7\u0005g\u0002\r!!+\t\u0011\tu$1\u000fa\u0001\u0005\u000b\t1\u0002Z1uCN+G\u000fV=qK\"9!\u0011\u0011\u0001\u0005\n\t\r\u0015!G4f]\u0016\u0014\u0018\r^3Qe\u0016$\u0017nY1uK\u001a+hn\u0019;j_:$\u0002B!\"\u0003*\n5&\u0011\u0017\t\t\u0005\u000f\u0013iI!%\u0003\u001e6\u0011!\u0011\u0012\u0006\u0004\u0005\u0017C\u0011aB2pI\u0016<WM\\\u0005\u0005\u0005\u001f\u0013IIA\tHK:,'/\u0019;fI\u001a+hn\u0019;j_:\u0004\"Ba%\u0003\u001a\u0006M\u00161\u0017BO\u001b\t\u0011)J\u0003\u0003\u0003\u0018\u0006\r\u0011!\u00034v]\u000e$\u0018n\u001c8t\u0013\u0011\u0011YJ!&\u0003\u0019){\u0017N\u001c$v]\u000e$\u0018n\u001c8\u0011\t\t}%QU\u0007\u0003\u0005CSAAa)\u0002d\u0005!A.\u00198h\u0013\u0011\u00119K!)\u0003\u000f\t{w\u000e\\3b]\"A!1\u0016B@\u0001\u0004\u0011)!\u0001\u0005mK\u001a$H+\u001f9f\u0011!\u0011yKa A\u0002\t\u0015\u0011!\u0003:jO\"$H+\u001f9f\u0011!\u0011\u0019Ba A\u0002\tU\u0001b\u0002B[\u0001\u0011%!qW\u0001\u001bO\u0016tWM]1uK\u000e{gN^3sg&|gNR;oGRLwN\u001c\u000b\u000b\u0005s\u0013iLa0\u0003B\n\r\u0007\u0003\u0003BD\u0005\u001b\u0013Y,a-\u0011\u0015\tM%\u0011TAZ\u0003g\u000b\u0019\f\u0003\u0005\u0003,\nM\u0006\u0019\u0001B\u0003\u0011!\u0011yKa-A\u0002\t\u0015\u0001\u0002\u0003B\u0002\u0005g\u0003\rA!\u0002\t\u0011\tM!1\u0017a\u0001\u0005+AABa2\u0001!\u0003\u0005\t\u0011!C\u0001\u0005\u0013\fa\u0002\u001d:pi\u0016\u001cG/\u001a3%Y\u00164G\u000fF\u00021\u0005\u0017D!B!4\u0003F\u0006\u0005\t\u0019AA\u0019\u0003\rAH%\r\u0005\r\u0005#\u0004\u0001\u0013!A\u0001\u0002\u0013\u0005!1[\u0001\u0010aJ|G/Z2uK\u0012$#/[4iiR\u0019\u0001G!6\t\u0015\t5'qZA\u0001\u0002\u0004\t\t\u0004")
public class DataSetJoin
extends BiRel
implements CommonJoin,
DataSetRel {
    private final RelOptCluster cluster;
    private final RelDataType rowRelDataType;
    private final RexNode joinCondition;
    private final RelDataType joinRowType;
    private final JoinInfo joinInfo;
    private final List<IntPair> keyPairs;
    private final JoinRelType joinType;
    private final JoinOperatorBase.JoinHint joinHint;
    private final String ruleDescription;

    @Override
    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        return FlinkRelNode.getExpressionString$(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode.estimateRowSize$(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode.estimateDataTypeSize$(this, t);
    }

    @Override
    public void validatePythonFunctionInJoinCondition(RexNode joinCondition) {
        CommonJoin.validatePythonFunctionInJoinCondition$(this, joinCondition);
    }

    @Override
    public String joinSelectionToString(RelDataType inputType) {
        return CommonJoin.joinSelectionToString$(this, inputType);
    }

    @Override
    public String joinConditionToString(RelDataType inputType, RexNode joinCondition, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression) {
        return CommonJoin.joinConditionToString$(this, inputType, joinCondition, expression);
    }

    @Override
    public String joinTypeToString(JoinRelType joinType) {
        return CommonJoin.joinTypeToString$(this, joinType);
    }

    @Override
    public String temporalJoinToString(RelDataType inputType, RexNode joinCondition, JoinRelType joinType, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression) {
        return CommonJoin.temporalJoinToString$(this, inputType, joinCondition, joinType, expression);
    }

    @Override
    public String joinToString(RelDataType inputType, RexNode joinCondition, JoinRelType joinType, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression) {
        return CommonJoin.joinToString$(this, inputType, joinCondition, joinType, expression);
    }

    @Override
    public RelWriter joinExplainTerms(RelWriter pw, RelDataType inputType, RexNode joinCondition, JoinRelType joinType, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression) {
        return CommonJoin.joinExplainTerms$(this, pw, inputType, joinCondition, joinType, expression);
    }

    public /* synthetic */ RelNode protected$left(DataSetJoin x$1) {
        return x$1.left;
    }

    public /* synthetic */ RelNode protected$right(DataSetJoin x$1) {
        return x$1.right;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.rowRelDataType;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, java.util.List<RelNode> inputs) {
        return new DataSetJoin(this.cluster, traitSet, inputs.get(0), inputs.get(1), this.getRowType(), this.joinCondition, this.joinRowType, this.joinInfo, this.keyPairs, this.joinType, this.joinHint, this.ruleDescription);
    }

    @Override
    public String toString() {
        return this.joinToString(this.joinRowType, this.joinCondition, this.joinType, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable));
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.joinExplainTerms(super.explainTerms(pw), this.joinRowType, this.joinCondition, this.joinType, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable));
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery metadata) {
        Double leftRowCnt = metadata.getRowCount(this.getLeft());
        double leftRowSize = this.estimateRowSize(this.getLeft().getRowType());
        Double rightRowCnt = metadata.getRowCount(this.getRight());
        double rightRowSize = this.estimateRowSize(this.getRight().getRowType());
        double ioCost = Predef$.MODULE$.Double2double(leftRowCnt) * leftRowSize + Predef$.MODULE$.Double2double(rightRowCnt) * rightRowSize;
        double cpuCost = Predef$.MODULE$.Double2double(leftRowCnt) + Predef$.MODULE$.Double2double(rightRowCnt);
        double rowCnt = Predef$.MODULE$.Double2double(leftRowCnt) + Predef$.MODULE$.Double2double(rightRowCnt);
        return planner.getCostFactory().makeCost(rowCnt, cpuCost, ioCost);
    }

    @Override
    public DataSet<Row> translateToPlan(BatchTableEnvImpl tableEnv, BatchQueryConfig queryConfig) {
        DataSet<Row> dataSet;
        TableConfig config = tableEnv.getConfig();
        TypeInformation<Row> returnType = FlinkTypeFactory$.MODULE$.toInternalRowTypeInfo(this.getRowType());
        ArrayBuffer leftKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer rightKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        if (this.keyPairs.isEmpty()) {
            throw new TableException(new StringBuilder(51).append("Joins should have at least one equality condition.\n").append(new StringBuilder(9).append("\tLeft: ").append(this.left.toString()).append(",\n").toString()).append(new StringBuilder(10).append("\tRight: ").append(this.right.toString()).append(",\n").toString()).append(new StringBuilder(14).append("\tCondition: (").append(this.joinConditionToString(this.joinRowType, this.joinCondition, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable))).append(")").toString()).toString());
        }
        java.util.List<RelDataTypeField> leftFields = this.left.getRowType().getFieldList();
        java.util.List<RelDataTypeField> rightFields = this.right.getRowType().getFieldList();
        this.keyPairs.foreach((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)DataSetJoin.$anonfun$translateToPlan$2(this, leftKeys, rightKeys, leftFields, rightFields, pair)));
        DataSet<Row> leftDataSet = ((DataSetRel)this.left).translateToPlan(tableEnv, queryConfig);
        DataSet<Row> rightDataSet = ((DataSetRel)this.right).translateToPlan(tableEnv, queryConfig);
        JoinRelType joinRelType = this.joinType;
        if (((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType)) {
            dataSet = this.addInnerJoin(leftDataSet, rightDataSet, (int[])leftKeys.toArray(ClassTag$.MODULE$.Int()), (int[])rightKeys.toArray(ClassTag$.MODULE$.Int()), returnType, config);
        } else if (((Object)((Object)JoinRelType.LEFT)).equals((Object)joinRelType)) {
            dataSet = this.addLeftOuterJoin(leftDataSet, rightDataSet, (int[])leftKeys.toArray(ClassTag$.MODULE$.Int()), (int[])rightKeys.toArray(ClassTag$.MODULE$.Int()), returnType, config);
        } else if (((Object)((Object)JoinRelType.RIGHT)).equals((Object)joinRelType)) {
            dataSet = this.addRightOuterJoin(leftDataSet, rightDataSet, (int[])leftKeys.toArray(ClassTag$.MODULE$.Int()), (int[])rightKeys.toArray(ClassTag$.MODULE$.Int()), returnType, config);
        } else if (((Object)((Object)JoinRelType.FULL)).equals((Object)joinRelType)) {
            dataSet = this.addFullOuterJoin(leftDataSet, rightDataSet, (int[])leftKeys.toArray(ClassTag$.MODULE$.Int()), (int[])rightKeys.toArray(ClassTag$.MODULE$.Int()), returnType, config);
        } else {
            throw new TableException(new StringBuilder(18).append((Object)this.joinType).append(" is not supported.").toString());
        }
        return dataSet;
    }

    private DataSet<Row> addInnerJoin(DataSet<Row> left, DataSet<Row> right, int[] leftKeys, int[] rightKeys, TypeInformation<Row> resultType, TableConfig config) {
        FunctionCodeGenerator generator = new FunctionCodeGenerator(config, false, (TypeInformation<?>)left.getType(), (Option<TypeInformation<?>>)new Some((Object)right.getType()), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$5(), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$6());
        GeneratedExpression conversion = generator.generateConverterResultExpression(resultType, (Seq<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.joinRowType.getFieldNames()), generator.generateConverterResultExpression$default$3());
        GeneratedExpression condition = generator.generateExpression(this.joinCondition);
        String body = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n         |").append(condition.code()).append("\n         |if (").append(condition.resultTerm()).append(") {\n         |  ").append(conversion.code()).append("\n         |  ").append(generator.collectorTerm()).append(".collect(").append(conversion.resultTerm()).append(");\n         |}\n         |").toString())).stripMargin();
        GeneratedFunction<FlatJoinFunction, Row> genFunction = generator.generateFunction(this.ruleDescription, FlatJoinFunction.class, body, resultType);
        FlatJoinRunner joinFun = new FlatJoinRunner(genFunction.name(), genFunction.code(), genFunction.returnType());
        return left.join(right).where(leftKeys).equalTo(rightKeys).with(joinFun).name(this.getJoinOpName());
    }

    private DataSet<Row> addLeftOuterJoin(DataSet<Row> left, DataSet<Row> right, int[] leftKeys, int[] rightKeys, TypeInformation<Row> resultType, TableConfig config) {
        if (!Predef$.MODULE$.Boolean2boolean(config.getNullCheck())) {
            throw new TableException("Null check in TableConfig must be enabled for outer joins.");
        }
        String joinOpName = this.getJoinOpName();
        RowTypeInfo leftType = new RowTypeInfo(((RowTypeInfo)left.getType()).getFieldTypes());
        RowTypeInfo rightType = (RowTypeInfo)right.getType();
        DataSet<Row> partitionedSortedLeft = this.partitionAndSort(left, leftKeys);
        DataSet<Row> foldedRowsLeft = this.foldIdenticalRows(partitionedSortedLeft, (TypeInformation<Row>)leftType);
        GeneratedFunction<JoinFunction<Row, Row, Boolean>, Boolean> predFun = this.generatePredicateFunction((TypeInformation<Row>)leftType, (TypeInformation<Row>)rightType, config);
        RowTypeInfo joinOutType = new RowTypeInfo(new TypeInformation[]{leftType, rightType, Types.INT()});
        LeftOuterJoinRunner joinFun = new LeftOuterJoinRunner(predFun.name(), predFun.code(), (TypeInformation<Row>)joinOutType);
        String[] nestedLeftKeys = (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(leftKeys)).map((Function1 & Serializable & scala.Serializable)i -> DataSetJoin.$anonfun$addLeftOuterJoin$1(BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        JoinOperator joinPairs = (JoinOperator)foldedRowsLeft.leftOuterJoin(right, JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE).where(nestedLeftKeys).equalTo(rightKeys).with((FlatJoinFunction)joinFun).withForwardedFieldsFirst(new String[]{"f0->f0"}).name(joinOpName);
        GeneratedFunction<JoinFunction<Row, Row, Row>, Row> convFun = this.generateConversionFunction((TypeInformation<Row>)leftType, (TypeInformation<Row>)rightType, resultType, config);
        LeftOuterJoinGroupReduceRunner reduceFun = new LeftOuterJoinGroupReduceRunner(convFun.name(), convFun.code(), convFun.returnType());
        return ((SingleInputUdfOperator)joinPairs.groupBy(new String[]{"f0"}).reduceGroup((GroupReduceFunction)reduceFun).name(joinOpName)).returns(resultType);
    }

    private DataSet<Row> addRightOuterJoin(DataSet<Row> left, DataSet<Row> right, int[] leftKeys, int[] rightKeys, TypeInformation<Row> resultType, TableConfig config) {
        if (!Predef$.MODULE$.Boolean2boolean(config.getNullCheck())) {
            throw new TableException("Null check in TableConfig must be enabled for outer joins.");
        }
        String joinOpName = this.getJoinOpName();
        RowTypeInfo leftType = (RowTypeInfo)left.getType();
        RowTypeInfo rightType = new RowTypeInfo(((RowTypeInfo)right.getType()).getFieldTypes());
        DataSet<Row> partitionedSortedRight = this.partitionAndSort(right, rightKeys);
        DataSet<Row> foldedRowsRight = this.foldIdenticalRows(partitionedSortedRight, (TypeInformation<Row>)rightType);
        GeneratedFunction<JoinFunction<Row, Row, Boolean>, Boolean> predFun = this.generatePredicateFunction((TypeInformation<Row>)leftType, (TypeInformation<Row>)rightType, config);
        RowTypeInfo joinOutType = new RowTypeInfo(new TypeInformation[]{leftType, rightType, Types.INT()});
        RightOuterJoinRunner joinFun = new RightOuterJoinRunner(predFun.name(), predFun.code(), (TypeInformation<Row>)joinOutType);
        String[] nestedRightKeys = (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(rightKeys)).map((Function1 & Serializable & scala.Serializable)i -> DataSetJoin.$anonfun$addRightOuterJoin$1(BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        JoinOperator joinPairs = (JoinOperator)left.rightOuterJoin(foldedRowsRight, JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE).where(leftKeys).equalTo(nestedRightKeys).with((FlatJoinFunction)joinFun).withForwardedFieldsSecond(new String[]{"f0->f1"}).name(joinOpName);
        GeneratedFunction<JoinFunction<Row, Row, Row>, Row> convFun = this.generateConversionFunction((TypeInformation<Row>)leftType, (TypeInformation<Row>)rightType, resultType, config);
        RightOuterJoinGroupReduceRunner reduceFun = new RightOuterJoinGroupReduceRunner(convFun.name(), convFun.code(), convFun.returnType());
        return ((SingleInputUdfOperator)joinPairs.groupBy(new String[]{"f1"}).reduceGroup((GroupReduceFunction)reduceFun).name(joinOpName)).returns(resultType);
    }

    private DataSet<Row> addFullOuterJoin(DataSet<Row> left, DataSet<Row> right, int[] leftKeys, int[] rightKeys, TypeInformation<Row> resultType, TableConfig config) {
        if (!Predef$.MODULE$.Boolean2boolean(config.getNullCheck())) {
            throw new TableException("Null check in TableConfig must be enabled for outer joins.");
        }
        String joinOpName = this.getJoinOpName();
        RowTypeInfo leftType = new RowTypeInfo(((RowTypeInfo)left.getType()).getFieldTypes());
        RowTypeInfo rightType = new RowTypeInfo(((RowTypeInfo)right.getType()).getFieldTypes());
        DataSet<Row> partitionedSortedLeft = this.partitionAndSort(left, leftKeys);
        DataSet<Row> partitionedSortedRight = this.partitionAndSort(right, rightKeys);
        DataSet<Row> foldedRowsLeft = this.foldIdenticalRows(partitionedSortedLeft, (TypeInformation<Row>)leftType);
        DataSet<Row> foldedRowsRight = this.foldIdenticalRows(partitionedSortedRight, (TypeInformation<Row>)rightType);
        GeneratedFunction<JoinFunction<Row, Row, Boolean>, Boolean> predFun = this.generatePredicateFunction((TypeInformation<Row>)leftType, (TypeInformation<Row>)rightType, config);
        RowTypeInfo joinOutType = new RowTypeInfo(new TypeInformation[]{leftType, rightType, Types.INT(), Types.INT()});
        FullOuterJoinRunner joinFun = new FullOuterJoinRunner(predFun.name(), predFun.code(), (TypeInformation<Row>)joinOutType);
        String[] nestedLeftKeys = (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(leftKeys)).map((Function1 & Serializable & scala.Serializable)i -> DataSetJoin.$anonfun$addFullOuterJoin$1(BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] nestedRightKeys = (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(rightKeys)).map((Function1 & Serializable & scala.Serializable)i -> DataSetJoin.$anonfun$addFullOuterJoin$2(BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        JoinOperator joinPairs = (JoinOperator)foldedRowsLeft.fullOuterJoin(foldedRowsRight, JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE).where(nestedLeftKeys).equalTo(nestedRightKeys).with((FlatJoinFunction)joinFun).withForwardedFieldsFirst(new String[]{"f0->f0"}).withForwardedFieldsSecond(new String[]{"f0->f1"}).name(joinOpName);
        GeneratedFunction<JoinFunction<Row, Row, Row>, Row> convFun = this.generateConversionFunction((TypeInformation<Row>)leftType, (TypeInformation<Row>)rightType, resultType, config);
        LeftFullOuterJoinGroupReduceRunner leftReduceFun = new LeftFullOuterJoinGroupReduceRunner(convFun.name(), convFun.code(), convFun.returnType());
        RightFullOuterJoinGroupReduceRunner rightReduceFun = new RightFullOuterJoinGroupReduceRunner(convFun.name(), convFun.code(), convFun.returnType());
        GroupReduceOperator joinedAndLeftPreserved = (GroupReduceOperator)((SingleInputUdfOperator)joinPairs.filter((FilterFunction)new FilterFunction<Row>(null){

            public boolean filter(Row row) {
                return row.getField(0) != null;
            }
        }).groupBy(new String[]{"f0"}).reduceGroup((GroupReduceFunction)leftReduceFun).name(joinOpName)).returns(resultType);
        GroupReduceOperator rightPreserved = (GroupReduceOperator)((SingleInputUdfOperator)joinPairs.filter((FilterFunction)new FilterFunction<Row>(null){

            public boolean filter(Row row) {
                return row.getField(1) != null;
            }
        }).groupBy(new String[]{"f1"}).reduceGroup((GroupReduceFunction)rightReduceFun).name(joinOpName)).returns(resultType);
        return joinedAndLeftPreserved.union((DataSet)rightPreserved);
    }

    private String getJoinOpName() {
        return new StringBuilder(11).append("where: (").append(this.joinConditionToString(this.joinRowType, this.joinCondition, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable))).append("), ").append(new StringBuilder(8).append("join: (").append(this.joinSelectionToString(this.joinRowType)).append(")").toString()).toString();
    }

    private int[] getFullIndiciesWithPrefix(int[] keys, int numFields) {
        IndexedSeq nonKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFields).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> !new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys)).contains((Object)BoxesRunTime.boxToInteger((int)x$1)));
        return (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys)).$plus$plus((GenTraversableOnce)nonKeys, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    private DataSet<Row> partitionAndSort(DataSet<Row> dataSet, int[] partitionKeys) {
        int[] sortKeys = this.getFullIndiciesWithPrefix(partitionKeys, dataSet.getType().getArity());
        PartitionOperator partitioned = dataSet.partitionByHash(partitionKeys);
        return (DataSet)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sortKeys)).foldLeft((Object)partitioned, (Function2 & Serializable & scala.Serializable)(d, i) -> d.sortPartition(BoxesRunTime.unboxToInt((Object)i), Order.ASCENDING));
    }

    private DataSet<Row> foldIdenticalRows(DataSet<Row> dataSet, TypeInformation<Row> dataSetType) {
        RowTypeInfo resultType = new RowTypeInfo(new TypeInformation[]{dataSetType, Types.INT()});
        Range groupKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), dataSetType.getArity());
        return dataSet.groupBy((int[])groupKeys.toArray(ClassTag$.MODULE$.Int())).reduceGroup((GroupReduceFunction)new GroupReduceFunction<Row, Row>(null){
            private final Row outTuple;

            private Row outTuple() {
                return this.outTuple;
            }

            public void reduce(Iterable<Row> values, Collector<Row> out) {
                int cnt = 0;
                Iterator<Row> it = values.iterator();
                while (it.hasNext()) {
                    this.outTuple().setField(0, (Object)it.next());
                    ++cnt;
                }
                this.outTuple().setField(1, (Object)BoxesRunTime.boxToInteger((int)cnt));
                out.collect((Object)this.outTuple());
            }
            {
                this.outTuple = new Row(2);
            }
        }).returns((TypeInformation)resultType).withForwardedFields(new String[]{"*->f0"}).name("fold identical rows");
    }

    private GeneratedFunction<JoinFunction<Row, Row, Boolean>, Boolean> generatePredicateFunction(TypeInformation<Row> leftType, TypeInformation<Row> rightType, TableConfig config) {
        FunctionCodeGenerator predGenerator = new FunctionCodeGenerator(config, false, leftType, (Option<TypeInformation<?>>)new Some(rightType), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$5(), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$6());
        GeneratedExpression condition = predGenerator.generateExpression(this.joinCondition);
        String predCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(43).append("\n         |").append(condition.code()).append("\n         |return (").append(condition.resultTerm()).append(");\n         |").toString())).stripMargin();
        return predGenerator.generateFunction("OuterJoinPredicate", JoinFunction.class, predCode, Types.BOOLEAN());
    }

    private GeneratedFunction<JoinFunction<Row, Row, Row>, Row> generateConversionFunction(TypeInformation<Row> leftType, TypeInformation<Row> rightType, TypeInformation<Row> resultType, TableConfig config) {
        FunctionCodeGenerator conversionGenerator = new FunctionCodeGenerator(config, true, leftType, (Option<TypeInformation<?>>)new Some(rightType), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$5(), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$6());
        GeneratedExpression conversion = conversionGenerator.generateConverterResultExpression(resultType, (Seq<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.joinRowType.getFieldNames()), conversionGenerator.generateConverterResultExpression$default$3());
        String convCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(conversion.code()).append("\n         |return ").append(conversion.resultTerm()).append(";\n         |").toString())).stripMargin();
        return conversionGenerator.generateFunction("OuterJoinConverter", JoinFunction.class, convCode, resultType);
    }

    public static final /* synthetic */ boolean $anonfun$translateToPlan$2(DataSetJoin $this, ArrayBuffer leftKeys$1, ArrayBuffer rightKeys$1, java.util.List leftFields$1, java.util.List rightFields$1, IntPair pair) {
        SqlTypeName leftKeyType = ((RelDataTypeField)leftFields$1.get(pair.source)).getType().getSqlTypeName();
        SqlTypeName rightKeyType = ((RelDataTypeField)rightFields$1.get(pair.target)).getType().getSqlTypeName();
        SqlTypeName sqlTypeName = leftKeyType;
        SqlTypeName sqlTypeName2 = rightKeyType;
        if (sqlTypeName != null ? !((Object)((Object)sqlTypeName)).equals((Object)sqlTypeName2) : sqlTypeName2 != null) {
            throw new TableException(new StringBuilder(47).append("Equality join predicate on incompatible types.\n").append(new StringBuilder(9).append("\tLeft: ").append($this.protected$left($this).toString()).append(",\n").toString()).append(new StringBuilder(10).append("\tRight: ").append($this.protected$right($this).toString()).append(",\n").toString()).append(new StringBuilder(14).append("\tCondition: (").append($this.joinConditionToString($this.joinRowType, $this.joinCondition, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> $this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable))).append(")").toString()).toString());
        }
        JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)leftKeys$1).add(BoxesRunTime.boxToInteger((int)pair.source));
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)rightKeys$1).add(BoxesRunTime.boxToInteger((int)pair.target));
    }

    public static final /* synthetic */ String $anonfun$addLeftOuterJoin$1(int i) {
        return new StringBuilder(4).append("f0.f").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$addRightOuterJoin$1(int i) {
        return new StringBuilder(4).append("f0.f").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$addFullOuterJoin$1(int i) {
        return new StringBuilder(4).append("f0.f").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$addFullOuterJoin$2(int i) {
        return new StringBuilder(4).append("f0.f").append(i).toString();
    }

    public DataSetJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode leftNode, RelNode rightNode, RelDataType rowRelDataType, RexNode joinCondition, RelDataType joinRowType, JoinInfo joinInfo, List<IntPair> keyPairs, JoinRelType joinType, JoinOperatorBase.JoinHint joinHint, String ruleDescription) {
        this.cluster = cluster;
        this.rowRelDataType = rowRelDataType;
        this.joinCondition = joinCondition;
        this.joinRowType = joinRowType;
        this.joinInfo = joinInfo;
        this.keyPairs = keyPairs;
        this.joinType = joinType;
        this.joinHint = joinHint;
        this.ruleDescription = ruleDescription;
        super(cluster, traitSet, leftNode, rightNode);
        CommonJoin.$init$(this);
        FlinkRelNode.$init$(this);
    }
}

