/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.expressions.Literal;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.expressions.PlannerResolvedFieldReference;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import scala.runtime.BoxesRunTime;

public final class PlannerExpressionUtils$ {
    public static PlannerExpressionUtils$ MODULE$;

    static {
        new PlannerExpressionUtils$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTimeIntervalLiteral(PlannerExpression expr) {
        PlannerExpression plannerExpression = expr;
        if (!(plannerExpression instanceof Literal)) return false;
        Literal literal = (Literal)plannerExpression;
        TypeInformation<?> typeInformation = literal.resultType();
        TimeIntervalTypeInfo timeIntervalTypeInfo = TimeIntervalTypeInfo.INTERVAL_MILLIS;
        TypeInformation<?> typeInformation2 = typeInformation;
        if (timeIntervalTypeInfo != null) {
            if (!timeIntervalTypeInfo.equals(typeInformation2)) return false;
            return true;
        }
        if (typeInformation2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRowCountLiteral(PlannerExpression expr) {
        PlannerExpression plannerExpression = expr;
        if (!(plannerExpression instanceof Literal)) return false;
        Literal literal = (Literal)plannerExpression;
        TypeInformation<?> typeInformation = literal.resultType();
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.LONG_TYPE_INFO;
        TypeInformation<?> typeInformation2 = typeInformation;
        if (basicTypeInfo != null) {
            if (!basicTypeInfo.equals(typeInformation2)) return false;
            return true;
        }
        if (typeInformation2 == null) return true;
        return false;
    }

    public boolean isTimeAttribute(PlannerExpression expr) {
        PlannerResolvedFieldReference plannerResolvedFieldReference;
        PlannerExpression plannerExpression = expr;
        boolean bl = plannerExpression instanceof PlannerResolvedFieldReference && FlinkTypeFactory$.MODULE$.isTimeIndicatorType((plannerResolvedFieldReference = (PlannerResolvedFieldReference)plannerExpression).resultType());
        return bl;
    }

    public boolean isRowtimeAttribute(PlannerExpression expr) {
        PlannerResolvedFieldReference plannerResolvedFieldReference;
        PlannerExpression plannerExpression = expr;
        boolean bl = plannerExpression instanceof PlannerResolvedFieldReference && FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType((plannerResolvedFieldReference = (PlannerResolvedFieldReference)plannerExpression).resultType());
        return bl;
    }

    public boolean isProctimeAttribute(PlannerExpression expr) {
        PlannerResolvedFieldReference plannerResolvedFieldReference;
        PlannerExpression plannerExpression = expr;
        boolean bl = plannerExpression instanceof PlannerResolvedFieldReference && FlinkTypeFactory$.MODULE$.isProctimeIndicatorType((plannerResolvedFieldReference = (PlannerResolvedFieldReference)plannerExpression).resultType());
        return bl;
    }

    public Time toTime(PlannerExpression expr) {
        long l;
        block3: {
            block2: {
                PlannerExpression plannerExpression = expr;
                if (!(plannerExpression instanceof Literal)) break block2;
                Literal literal = (Literal)plannerExpression;
                Object value = literal.value();
                TypeInformation<?> typeInformation = literal.resultType();
                if (!(value instanceof Long)) break block2;
                l = BoxesRunTime.unboxToLong((Object)value);
                TimeIntervalTypeInfo timeIntervalTypeInfo = TimeIntervalTypeInfo.INTERVAL_MILLIS;
                TypeInformation<?> typeInformation2 = typeInformation;
                if (!(timeIntervalTypeInfo != null ? !timeIntervalTypeInfo.equals(typeInformation2) : typeInformation2 != null)) break block3;
            }
            throw new IllegalArgumentException();
        }
        Time time = Time.milliseconds((long)l);
        return time;
    }

    public long toLong(PlannerExpression expr) {
        long l;
        block3: {
            block2: {
                PlannerExpression plannerExpression = expr;
                if (!(plannerExpression instanceof Literal)) break block2;
                Literal literal = (Literal)plannerExpression;
                Object value = literal.value();
                TypeInformation<?> typeInformation = literal.resultType();
                if (!(value instanceof Long)) break block2;
                l = BoxesRunTime.unboxToLong((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.LONG_TYPE_INFO;
                TypeInformation<?> typeInformation2 = typeInformation;
                if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null)) break block3;
            }
            throw new IllegalArgumentException();
        }
        long l2 = l;
        return l2;
    }

    private PlannerExpressionUtils$() {
        MODULE$ = this;
    }
}

