/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ExtendedSqlNode;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class SqlCreateFunction
extends SqlCreate
implements ExtendedSqlNode {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE FUNCTION", SqlKind.CREATE_FUNCTION);
    private final SqlIdentifier functionIdentifier;
    private final SqlCharStringLiteral functionClassName;
    private final String functionLanguage;
    private final boolean isTemporary;
    private final boolean isSystemFunction;

    public SqlCreateFunction(SqlParserPos pos, SqlIdentifier functionIdentifier, SqlCharStringLiteral functionClassName, String functionLanguage, boolean ifNotExists, boolean isTemporary, boolean isSystemFunction) {
        super(OPERATOR, pos, false, ifNotExists);
        this.functionIdentifier = Objects.requireNonNull(functionIdentifier);
        this.functionClassName = Objects.requireNonNull(functionClassName);
        this.isSystemFunction = Objects.requireNonNull(isSystemFunction);
        this.isTemporary = isTemporary;
        this.functionLanguage = functionLanguage;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.functionIdentifier, this.functionClassName);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.isTemporary) {
            writer.keyword("TEMPORARY");
        }
        if (this.isSystemFunction) {
            writer.keyword("SYSTEM");
        }
        writer.keyword("FUNCTION");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.functionIdentifier.unparse(writer, leftPrec, rightPrec);
        writer.keyword("AS");
        this.functionClassName.unparse(writer, leftPrec, rightPrec);
        if (this.functionLanguage != null) {
            writer.keyword("LANGUAGE");
            writer.keyword(this.functionLanguage);
        }
    }

    @Override
    public void validate() throws SqlValidateException {
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public boolean isSystemFunction() {
        return this.isSystemFunction;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public SqlCharStringLiteral getFunctionClassName() {
        return this.functionClassName;
    }

    public String getFunctionLanguage() {
        return this.functionLanguage;
    }

    public String[] getFunctionIdentifier() {
        return this.functionIdentifier.names.toArray(new String[0]);
    }
}

