/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableFilter;
import org.apache.calcite.adapter.enumerable.EnumerableProject;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;

public interface EnumerableRel
extends RelNode {
    public static final RelFactories.FilterFactory FILTER_FACTORY = (input, condition, variablesSet) -> {
        Preconditions.checkArgument(variablesSet.isEmpty(), "EnumerableFilter does not allow variables");
        return EnumerableFilter.create(input, condition);
    };
    public static final RelFactories.ProjectFactory PROJECT_FACTORY = EnumerableProject::create;

    public Result implement(EnumerableRelImplementor var1, Prefer var2);

    public static class Result {
        public final BlockStatement block;
        public final PhysType physType;
        public final JavaRowFormat format;

        public Result(BlockStatement block, PhysType physType, JavaRowFormat format) {
            this.block = block;
            this.physType = physType;
            this.format = format;
        }
    }

    public static enum Prefer {
        ARRAY,
        ARRAY_NICE,
        CUSTOM,
        CUSTOM_NICE,
        ANY;


        public JavaRowFormat preferCustom() {
            return this.prefer(JavaRowFormat.CUSTOM);
        }

        public JavaRowFormat preferArray() {
            return this.prefer(JavaRowFormat.ARRAY);
        }

        public JavaRowFormat prefer(JavaRowFormat format) {
            switch (this) {
                case CUSTOM: {
                    return JavaRowFormat.CUSTOM;
                }
                case ARRAY: {
                    return JavaRowFormat.ARRAY;
                }
            }
            return format;
        }

        public Prefer of(JavaRowFormat format) {
            switch (format) {
                case ARRAY: {
                    return ARRAY;
                }
            }
            return CUSTOM;
        }
    }
}

