/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.ClassFileIClass;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.FilterWarningHandler;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.InternalCompilerException;
import org.codehaus.janino.JaninoOption;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.Benchmark;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.StringPattern;
import org.codehaus.janino.util.resource.DirectoryResourceCreator;
import org.codehaus.janino.util.resource.DirectoryResourceFinder;
import org.codehaus.janino.util.resource.FileResource;
import org.codehaus.janino.util.resource.FileResourceCreator;
import org.codehaus.janino.util.resource.PathResourceFinder;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceCreator;
import org.codehaus.janino.util.resource.ResourceFinder;

public class Compiler {
    private static final Logger LOGGER = Logger.getLogger(Compiler.class.getName());
    private static final String USAGE = "Usage:%n%n  java " + Compiler.class.getName() + " [ <option> ] ... <source-file> ...%n" + "%n" + "Supported <option>s are:%n" + "  -d <output-dir>           Where to save class files%n" + "  -sourcepath <dirlist>     Where to look for other source files%n" + "  -classpath <dirlist>      Where to look for other class files%n" + "  -extdirs <dirlist>        Where to look for other class files%n" + "  -bootclasspath <dirlist>  Where to look for other class files%n" + "  -encoding <encoding>      Encoding of source files, e.g. \"UTF-8\" or \"ISO-8859-1\"%n" + "  -verbose%n" + "  -g                        Generate all debugging info%n" + "  -g:none                   Generate no debugging info%n" + "  -g:{source,lines,vars}    Generate only some debugging info%n" + "  -warn:<pattern-list>      Issue certain warnings; examples:%n" + "    -warn:*                 Enables all warnings%n" + "    -warn:IASF              Only warn against implicit access to static fields%n" + "    -warn:*-IASF            Enables all warnings, except those against implicit%n" + "                            access to static fields%n" + "    -warn:*-IA*+IASF        Enables all warnings, except those against implicit%n" + "                            accesses, but do warn against implicit access to%n" + "                            static fields%n" + "  -rebuild                  Compile all source files, even if the class files%n" + "                            seems up-to-date%n" + "  -help%n" + "%n" + "The default encoding in this environment is \"" + Charset.defaultCharset().toString() + "\".";
    @Nullable
    public static final ResourceFinder FIND_NEXT_TO_SOURCE_FILE = null;
    @Nullable
    public static final ResourceCreator CREATE_NEXT_TO_SOURCE_FILE = null;
    @Nullable
    private ResourceCreator classFileCreator;
    @Nullable
    private ResourceFinder classFileFinder;
    @Nullable
    private String characterEncoding;
    private Benchmark benchmark = new Benchmark(false);
    private boolean debugSource;
    private boolean debugLines;
    private boolean debugVars;
    @Nullable
    private WarningHandler warningHandler;
    @Nullable
    private ErrorHandler compileErrorHandler;
    private EnumSet<JaninoOption> options = EnumSet.noneOf(JaninoOption.class);
    private final IClassLoader iClassLoader;
    private final List<UnitCompiler> parsedCompilationUnits = new ArrayList<UnitCompiler>();
    @Nullable
    public static final File NO_DESTINATION_DIRECTORY = null;
    public static final StringPattern[] DEFAULT_WARNING_HANDLE_PATTERNS = StringPattern.PATTERNS_NONE;

    public static void main(String[] args) {
        String arg;
        int i;
        File destinationDirectory = NO_DESTINATION_DIRECTORY;
        File[] sourcePath = null;
        File[] classPath = new File[]{new File(".")};
        File[] extDirs = null;
        File[] bootClassPath = null;
        String characterEncoding = null;
        boolean verbose = false;
        boolean debugSource = true;
        boolean debugLines = true;
        boolean debugVars = false;
        StringPattern[] warningHandlePatterns = DEFAULT_WARNING_HANDLE_PATTERNS;
        boolean rebuild = false;
        for (i = 0; i < args.length && (arg = args[i]).charAt(0) == '-'; ++i) {
            if ("-d".equals(arg)) {
                destinationDirectory = new File(args[++i]);
                continue;
            }
            if ("-sourcepath".equals(arg)) {
                sourcePath = PathResourceFinder.parsePath(args[++i]);
                continue;
            }
            if ("-classpath".equals(arg)) {
                classPath = PathResourceFinder.parsePath(args[++i]);
                continue;
            }
            if ("-extdirs".equals(arg)) {
                extDirs = PathResourceFinder.parsePath(args[++i]);
                continue;
            }
            if ("-bootclasspath".equals(arg)) {
                bootClassPath = PathResourceFinder.parsePath(args[++i]);
                continue;
            }
            if ("-encoding".equals(arg)) {
                characterEncoding = args[++i];
                continue;
            }
            if ("-verbose".equals(arg)) {
                verbose = true;
                continue;
            }
            if ("-g".equals(arg)) {
                debugSource = true;
                debugLines = true;
                debugVars = true;
                continue;
            }
            if (arg.startsWith("-g:")) {
                if (arg.indexOf("none") != -1) {
                    debugVars = false;
                    debugLines = false;
                    debugSource = false;
                }
                if (arg.indexOf("source") != -1) {
                    debugSource = true;
                }
                if (arg.indexOf("lines") != -1) {
                    debugLines = true;
                }
                if (arg.indexOf("vars") == -1) continue;
                debugVars = true;
                continue;
            }
            if (arg.startsWith("-warn:")) {
                warningHandlePatterns = StringPattern.parseCombinedPattern(arg.substring(6));
                continue;
            }
            if ("-rebuild".equals(arg)) {
                rebuild = true;
                continue;
            }
            if ("-help".equals(arg)) {
                System.out.printf(USAGE, (Object[])null);
                System.exit(1);
                continue;
            }
            System.err.println("Unrecognized command line option \"" + arg + "\"; try \"-help\".");
            System.exit(1);
        }
        if (i == args.length) {
            System.err.println("No source files given on command line; try \"-help\".");
            System.exit(1);
        }
        File[] sourceFiles = new File[args.length - i];
        for (int j = i; j < args.length; ++j) {
            sourceFiles[j - i] = new File(args[j]);
        }
        Compiler compiler = new Compiler(sourcePath, classPath, extDirs, bootClassPath, destinationDirectory, characterEncoding, verbose, debugSource, debugLines, debugVars, warningHandlePatterns, rebuild);
        try {
            compiler.compile(sourceFiles);
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            } else {
                System.err.println(e.toString());
            }
            System.exit(1);
        }
    }

    public Compiler(@Nullable File[] sourcePath, File[] classPath, @Nullable File[] extDirs, @Nullable File[] bootClassPath, @Nullable File destinationDirectory, @Nullable String characterEncoding, boolean verbose, boolean debugSource, boolean debugLines, boolean debugVars, StringPattern[] warningHandlePatterns, boolean rebuild) {
        this(new PathResourceFinder(sourcePath == null ? classPath : sourcePath), IClassLoader.createJavacLikePathIClassLoader(bootClassPath, extDirs, classPath));
        this.setClassFileFinder(rebuild ? ResourceFinder.EMPTY_RESOURCE_FINDER : (destinationDirectory == null ? FIND_NEXT_TO_SOURCE_FILE : new DirectoryResourceFinder(destinationDirectory)));
        this.setClassFileCreator(destinationDirectory == null ? CREATE_NEXT_TO_SOURCE_FILE : new DirectoryResourceCreator(destinationDirectory));
        this.setCharacterEncoding(characterEncoding);
        this.setVerbose(verbose);
        this.setDebugSource(debugSource);
        this.setDebugLines(debugLines);
        this.setDebugVars(debugVars);
        this.setWarningHandler(new FilterWarningHandler(warningHandlePatterns, new WarningHandler(){

            @Override
            public void handleWarning(@Nullable String handle, String message, @Nullable Location location) {
                StringBuilder sb = new StringBuilder();
                if (location != null) {
                    sb.append(location).append(": ");
                }
                if (handle == null) {
                    sb.append("Warning: ");
                } else {
                    sb.append("Warning ").append(handle).append(": ");
                }
                sb.append(message);
                System.err.println(sb.toString());
            }
        }));
        this.benchmark.report("*** JANINO - an embedded compiler for the Java(TM) programming language");
        this.benchmark.report("*** For more information visit http://janino.codehaus.org");
        this.benchmark.report("Source path", sourcePath);
        this.benchmark.report("Class path", classPath);
        this.benchmark.report("Ext dirs", extDirs);
        this.benchmark.report("Boot class path", bootClassPath);
        this.benchmark.report("Destination directory", destinationDirectory);
        this.benchmark.report("Character encoding", characterEncoding);
        this.benchmark.report("Verbose", new Boolean(verbose));
        this.benchmark.report("Debug source", new Boolean(debugSource));
        this.benchmark.report("Debug lines", new Boolean(debugSource));
        this.benchmark.report("Debug vars", new Boolean(debugSource));
        this.benchmark.report("Warning handle patterns", warningHandlePatterns);
        this.benchmark.report("Rebuild", new Boolean(rebuild));
    }

    public Compiler(ResourceFinder sourceFinder, @Nullable IClassLoader parentIClassLoader) {
        this.iClassLoader = new CompilerIClassLoader(sourceFinder, parentIClassLoader);
    }

    public void setCompileErrorHandler(@Nullable ErrorHandler compileErrorHandler) {
        this.compileErrorHandler = compileErrorHandler;
    }

    public void setWarningHandler(@Nullable WarningHandler warningHandler) {
        this.warningHandler = warningHandler;
    }

    public EnumSet<JaninoOption> options() {
        return this.options;
    }

    public Compiler options(EnumSet<JaninoOption> options) {
        this.options = options;
        return this;
    }

    public boolean compile(File[] sourceFiles) throws CompileException, IOException {
        this.benchmark.report("Source files", sourceFiles);
        Resource[] sourceFileResources = new Resource[sourceFiles.length];
        for (int i = 0; i < sourceFiles.length; ++i) {
            sourceFileResources[i] = new FileResource(sourceFiles[i]);
        }
        this.compile(sourceFileResources);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compile(Resource[] sourceResources) throws CompileException, IOException {
        this.benchmark.beginReporting();
        try {
            this.parsedCompilationUnits.clear();
            for (Resource sourceResource : sourceResources) {
                LOGGER.log(Level.FINE, "Compiling \"{0}\"", sourceResource);
                UnitCompiler uc = new UnitCompiler(this.parseCompilationUnit(sourceResource.getFileName(), new BufferedInputStream(sourceResource.open()), this.characterEncoding), this.iClassLoader);
                uc.options(this.options);
                this.parsedCompilationUnits.add(uc);
            }
            for (int i = 0; i < this.parsedCompilationUnits.size(); ++i) {
                ClassFile[] classFiles;
                UnitCompiler unitCompiler = this.parsedCompilationUnits.get(i);
                Java.CompilationUnit compilationUnit = unitCompiler.getCompilationUnit();
                if (compilationUnit.optionalFileName == null) {
                    throw new InternalCompilerException();
                }
                File sourceFile = new File(compilationUnit.optionalFileName);
                unitCompiler.setCompileErrorHandler(this.compileErrorHandler);
                unitCompiler.setWarningHandler(this.warningHandler);
                this.benchmark.beginReporting("Compiling compilation unit \"" + sourceFile + "\"");
                try {
                    classFiles = unitCompiler.compileUnit(this.debugSource, this.debugLines, this.debugVars);
                }
                finally {
                    this.benchmark.endReporting();
                }
                this.benchmark.beginReporting("Storing " + classFiles.length + " class file(s) resulting from compilation unit \"" + sourceFile + "\"");
                try {
                    for (ClassFile classFile : classFiles) {
                        this.storeClassFile(classFile, sourceFile);
                    }
                    continue;
                }
                finally {
                    this.benchmark.endReporting();
                }
            }
        }
        finally {
            this.benchmark.endReporting("Compiled " + this.parsedCompilationUnits.size() + " compilation unit(s)");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Java.CompilationUnit parseCompilationUnit(String fileName, InputStream inputStream, @Nullable String characterEncoding) throws CompileException, IOException {
        try {
            Scanner scanner = new Scanner(fileName, inputStream, characterEncoding);
            Parser parser = new Parser(scanner);
            parser.setWarningHandler(this.warningHandler);
            this.benchmark.beginReporting("Parsing \"" + fileName + "\"");
            try {
                Java.CompilationUnit compilationUnit = parser.parseCompilationUnit();
                this.benchmark.endReporting();
                return compilationUnit;
            }
            catch (Throwable throwable) {
                this.benchmark.endReporting();
                throw throwable;
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static File getClassFile(String className, File sourceFile, @Nullable File destinationDirectory) {
        if (destinationDirectory != null) {
            return new File(destinationDirectory, ClassFile.getClassFileResourceName(className));
        }
        int idx = className.lastIndexOf(46);
        return new File(sourceFile.getParentFile(), ClassFile.getClassFileResourceName(className.substring(idx + 1)));
    }

    public void storeClassFile(ClassFile classFile, final File sourceFile) throws IOException {
        ResourceCreator rc;
        String classFileResourceName = ClassFile.getClassFileResourceName(classFile.getThisClassName());
        if (this.classFileCreator != CREATE_NEXT_TO_SOURCE_FILE) {
            rc = this.classFileCreator;
            assert (rc != null);
        } else {
            rc = new FileResourceCreator(){

                @Override
                protected File getFile(String resourceName) {
                    return new File(sourceFile.getParentFile(), resourceName.substring(resourceName.lastIndexOf(47) + 1));
                }
            };
        }
        OutputStream os = rc.createResource(classFileResourceName);
        try {
            classFile.store(os);
        }
        catch (IOException ioe) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            os = null;
            if (!rc.deleteResource(classFileResourceName)) {
                IOException ioe2 = new IOException("Could not delete incompletely written class file \"" + classFileResourceName + "\"");
                ioe2.initCause(ioe);
                throw ioe2;
            }
            throw ioe;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setClassFileFinder(@Nullable ResourceFinder classFileFinder) {
        this.classFileFinder = classFileFinder;
    }

    public void setClassFileCreator(@Nullable ResourceCreator classFileCreator) {
        this.classFileCreator = classFileCreator;
    }

    public void setCharacterEncoding(@Nullable String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setDebugSource(boolean debugSource) {
        this.debugSource = debugSource;
    }

    public void setDebugLines(boolean debugLines) {
        this.debugLines = debugLines;
    }

    public void setDebugVars(boolean debugVars) {
        this.debugVars = debugVars;
    }

    public void setVerbose(boolean verbose) {
        this.benchmark = new Benchmark(verbose);
    }

    private class CompilerIClassLoader
    extends IClassLoader {
        private final ResourceFinder sourceFinder;

        CompilerIClassLoader(@Nullable ResourceFinder sourceFinder, IClassLoader parentIClassLoader) {
            super(parentIClassLoader);
            this.sourceFinder = sourceFinder;
            super.postConstruct();
        }

        @Override
        @Nullable
        protected IClass findIClass(String type) throws ClassNotFoundException {
            Resource classFileResource;
            LOGGER.entering(null, "findIClass", type);
            String className = Descriptor.toClassName(type);
            LOGGER.log(Level.FINE, "className={0}", className);
            if (className.startsWith("java.")) {
                return null;
            }
            int idx = className.indexOf(36);
            String topLevelClassName = idx == -1 ? className : className.substring(0, idx);
            for (int i = 0; i < Compiler.this.parsedCompilationUnits.size(); ++i) {
                UnitCompiler uc = (UnitCompiler)Compiler.this.parsedCompilationUnits.get(i);
                IClass res = uc.findClass(topLevelClassName);
                if (res == null) continue;
                if (!className.equals(topLevelClassName) && (res = uc.findClass(className)) == null) {
                    return null;
                }
                this.defineIClass(res);
                return res;
            }
            Resource sourceResource = this.sourceFinder.findResource(ClassFile.getSourceResourceName(className));
            if (sourceResource == null) {
                return null;
            }
            ResourceFinder cff = Compiler.this.classFileFinder;
            if (cff != FIND_NEXT_TO_SOURCE_FILE) {
                assert (cff != null);
                classFileResource = cff.findResource(ClassFile.getClassFileResourceName(className));
            } else {
                if (!(sourceResource instanceof FileResource)) {
                    return null;
                }
                File classFile = new File(((FileResource)sourceResource).getFile().getParentFile(), ClassFile.getClassFileResourceName(className.substring(className.lastIndexOf(46) + 1)));
                Resource resource = classFileResource = classFile.exists() ? new FileResource(classFile) : null;
            }
            if (classFileResource != null && sourceResource.lastModified() <= classFileResource.lastModified()) {
                return this.defineIClassFromClassFileResource(classFileResource);
            }
            return this.defineIClassFromSourceResource(sourceResource, className);
        }

        private IClass defineIClassFromSourceResource(Resource sourceResource, String className) throws ClassNotFoundException {
            UnitCompiler uc;
            try {
                Java.CompilationUnit cu = Compiler.this.parseCompilationUnit(sourceResource.getFileName(), new BufferedInputStream(sourceResource.open()), Compiler.this.characterEncoding);
                uc = new UnitCompiler(cu, Compiler.this.iClassLoader).options(Compiler.this.options);
            }
            catch (IOException ex) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", ex);
            }
            catch (CompileException ex) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", ex);
            }
            Compiler.this.parsedCompilationUnits.add(uc);
            IClass res = uc.findClass(className);
            if (res == null) {
                throw new ClassNotFoundException("\"" + sourceResource + "\" does not declare \"" + className + "\"");
            }
            this.defineIClass(res);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IClass defineIClassFromClassFileResource(Resource classFileResource) throws ClassNotFoundException {
            Compiler.this.benchmark.beginReporting("Loading class file \"" + classFileResource.getFileName() + "\"");
            try {
                ClassFile cf;
                InputStream is = null;
                try {
                    is = classFileResource.open();
                    cf = new ClassFile(new BufferedInputStream(is));
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Opening class file resource \"" + classFileResource + "\"", ex);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                ClassFileIClass result = new ClassFileIClass(cf, this);
                this.defineIClass(result);
                result.resolveAllClasses();
                ClassFileIClass classFileIClass = result;
                return classFileIClass;
            }
            finally {
                Compiler.this.benchmark.endReporting();
            }
        }
    }
}

