/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.runtime.CRowWrappingCollector;
import org.apache.flink.table.runtime.join.BaseTwoInputStreamOperatorWithStateRetention;
import org.apache.flink.table.runtime.join.RowtimeComparator;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.typeutils.TypeCheckUtils$;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t}f\u0001B\u0001\u0003\u0001=\u00111\u0003V3na>\u0014\u0018\r\u001c*poRLW.\u001a&pS:T!a\u0001\u0003\u0002\t)|\u0017N\u001c\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001BC\u000b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011AFQ1tKR;x.\u00138qkR\u001cFO]3b[>\u0003XM]1u_J<\u0016\u000e\u001e5Ti\u0006$XMU3uK:$\u0018n\u001c8\u0011\u0007UA\"$D\u0001\u0017\u0015\t9b!A\u0004d_\u0012,w-\u001a8\n\u0005e1\"\u0001C\"p[BLG.\u001a:\u0011\u000bm\u0011C\u0005\n\u0013\u000e\u0003qQ!!\b\u0010\u0002\u0013\u0019,hn\u0019;j_:\u001c(BA\u0010!\u0003\u0019\u0019w.\\7p]*\u0011\u0011\u0005C\u0001\u0004CBL\u0017BA\u0012\u001d\u0005A1E.\u0019;K_&tg)\u001e8di&|g\u000e\u0005\u0002&Q5\taE\u0003\u0002(\u0011\u0005)A/\u001f9fg&\u0011\u0011F\n\u0002\u0004%><\bCA\u0016/\u001b\u0005a#BA\u0017\u0007\u0003\u0011)H/\u001b7\n\u0005=b#a\u0002'pO\u001eLgn\u001a\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u0005AA.\u001a4u)f\u0004X\rE\u00024m\u0011j\u0011\u0001\u000e\u0006\u0003ky\t\u0001\u0002^=qK&tgm\\\u0005\u0003oQ\u0012q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\ts\u0001\u0011\t\u0011)A\u0005e\u0005I!/[4iiRK\b/\u001a\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u0005yq-\u001a8K_&tg)\u001e8d\u001d\u0006lW\r\u0005\u0002>\r:\u0011a\b\u0012\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003:\ta\u0001\u0010:p_Rt$\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013\u0015A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\"\t\u0011)\u0003!\u0011!Q\u0001\nq\nqbZ3o\u0015>LgNR;oG\u000e{G-\u001a\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\u0006Y\u0011/^3ss\u000e{gNZ5h!\tq\u0005+D\u0001P\u0015\t\tc!\u0003\u0002R\u001f\n\t2\u000b\u001e:fC6\fV/\u001a:z\u0007>tg-[4\t\u0011M\u0003!\u0011!Q\u0001\nQ\u000b\u0011\u0003\\3giRKW.Z!uiJL'-\u001e;f!\t)f+D\u0001C\u0013\t9&IA\u0002J]RD\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006I\u0001V\u0001\u0013e&<\u0007\u000e\u001e+j[\u0016\fE\u000f\u001e:jEV$X\rC\u0003\\\u0001\u0011\u0005A,\u0001\u0004=S:LGO\u0010\u000b\t;z{\u0006-\u00192dIB\u0011\u0011\u0003\u0001\u0005\u0006ci\u0003\rA\r\u0005\u0006si\u0003\rA\r\u0005\u0006wi\u0003\r\u0001\u0010\u0005\u0006\u0015j\u0003\r\u0001\u0010\u0005\u0006\u0019j\u0003\r!\u0014\u0005\u0006'j\u0003\r\u0001\u0016\u0005\u00063j\u0003\r\u0001\u0016\u0005\bM\u0002\u0011\r\u0011\"\u0003h\u0003iqU\t\u0017+`\u0019\u00163EkX%O\t\u0016Cvl\u0015+B)\u0016{f*Q'F+\u0005A\u0007CA5o\u001b\u0005Q'BA6m\u0003\u0011a\u0017M\\4\u000b\u00035\fAA[1wC&\u0011qI\u001b\u0005\u0007a\u0002\u0001\u000b\u0011\u00025\u000279+\u0005\fV0M\u000b\u001a#v,\u0013(E\u000bb{6\u000bV!U\u000b~s\u0015)T#!\u0011\u001d\u0011\bA1A\u0005\n\u001d\fq\u0002T#G)~\u001bF+\u0011+F?:\u000bU*\u0012\u0005\u0007i\u0002\u0001\u000b\u0011\u00025\u0002!1+e\tV0T)\u0006#Vi\u0018(B\u001b\u0016\u0003\u0003b\u0002<\u0001\u0005\u0004%IaZ\u0001\u0011%&;\u0005\nV0T)\u0006#Vi\u0018(B\u001b\u0016Ca\u0001\u001f\u0001!\u0002\u0013A\u0017!\u0005*J\u000f\"#vl\u0015+B)\u0016{f*Q'FA!9!\u0010\u0001b\u0001\n\u00139\u0017a\u0007*F\u000f&\u001bF+\u0012*F\t~#\u0016*T#S?N#\u0016\tV#`\u001d\u0006kU\t\u0003\u0004}\u0001\u0001\u0006I\u0001[\u0001\u001d%\u0016;\u0015j\u0015+F%\u0016#u\fV%N\u000bJ{6\u000bV!U\u000b~s\u0015)T#!\u0011\u001dq\bA1A\u0005\n\u001d\f\u0011\u0003V%N\u000bJ\u001bvl\u0015+B)\u0016{f*Q'F\u0011\u001d\t\t\u0001\u0001Q\u0001\n!\f!\u0003V%N\u000bJ\u001bvl\u0015+B)\u0016{f*Q'FA!I\u0011Q\u0001\u0001C\u0002\u0013%\u0011qA\u0001\u0017e&<\u0007\u000e\u001e*poRLW.Z\"p[B\f'/\u0019;peV\u0011\u0011\u0011\u0002\t\u0004#\u0005-\u0011bAA\u0007\u0005\t\t\"k\\<uS6,7i\\7qCJ\fGo\u001c:\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0013\tqC]5hQR\u0014vn\u001e;j[\u0016\u001cu.\u001c9be\u0006$xN\u001d\u0011\t\u0017\u0005U\u0001\u00011AA\u0002\u0013%\u0011qC\u0001\u000e]\u0016DH\u000fT3gi&sG-\u001a=\u0016\u0005\u0005e\u0001CBA\u000e\u0003C\t)#\u0004\u0002\u0002\u001e)\u0019\u0011q\u0004\u0010\u0002\u000bM$\u0018\r^3\n\t\u0005\r\u0012Q\u0004\u0002\u000b-\u0006dW/Z*uCR,\u0007cA5\u0002(%\u0019\u0011\u0011\u00066\u0003\t1{gn\u001a\u0005\f\u0003[\u0001\u0001\u0019!a\u0001\n\u0013\ty#A\toKb$H*\u001a4u\u0013:$W\r_0%KF$B!!\r\u00028A\u0019Q+a\r\n\u0007\u0005U\"I\u0001\u0003V]&$\bBCA\u001d\u0003W\t\t\u00111\u0001\u0002\u001a\u0005\u0019\u0001\u0010J\u0019\t\u0017\u0005u\u0002\u00011A\u0001B\u0003&\u0011\u0011D\u0001\u000f]\u0016DH\u000fT3gi&sG-\u001a=!\u0011-\t\t\u0005\u0001a\u0001\u0002\u0004%I!a\u0011\u0002\u00131,g\r^*uCR,WCAA#!\u001d\tY\"a\u0012\u0002&\u0011JA!!\u0013\u0002\u001e\tAQ*\u00199Ti\u0006$X\rC\u0006\u0002N\u0001\u0001\r\u00111A\u0005\n\u0005=\u0013!\u00047fMR\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005E\u0003BCA\u001d\u0003\u0017\n\t\u00111\u0001\u0002F!Y\u0011Q\u000b\u0001A\u0002\u0003\u0005\u000b\u0015BA#\u0003)aWM\u001a;Ti\u0006$X\r\t\u0005\f\u00033\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019%\u0001\u0006sS\u001eDGo\u0015;bi\u0016D1\"!\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002`\u0005q!/[4iiN#\u0018\r^3`I\u0015\fH\u0003BA\u0019\u0003CB!\"!\u000f\u0002\\\u0005\u0005\t\u0019AA#\u0011-\t)\u0007\u0001a\u0001\u0002\u0003\u0006K!!\u0012\u0002\u0017ILw\r\u001b;Ti\u0006$X\r\t\u0005\f\u0003S\u0002\u0001\u0019!a\u0001\n\u0013\t9\"A\bsK\u001eL7\u000f^3sK\u0012$\u0016.\\3s\u0011-\ti\u0007\u0001a\u0001\u0002\u0004%I!a\u001c\u0002'I,w-[:uKJ,G\rV5nKJ|F%Z9\u0015\t\u0005E\u0012\u0011\u000f\u0005\u000b\u0003s\tY'!AA\u0002\u0005e\u0001bCA;\u0001\u0001\u0007\t\u0011)Q\u0005\u00033\t\u0001C]3hSN$XM]3e)&lWM\u001d\u0011\t\u0017\u0005e\u0004\u00011AA\u0002\u0013%\u00111P\u0001\fGJ{wo\u0016:baB,'/\u0006\u0002\u0002~A!\u0011qPAA\u001b\u0005!\u0011bAAB\t\t)2IU8x/J\f\u0007\u000f]5oO\u000e{G\u000e\\3di>\u0014\bbCAD\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013\u000bqb\u0019*po^\u0013\u0018\r\u001d9fe~#S-\u001d\u000b\u0005\u0003c\tY\t\u0003\u0006\u0002:\u0005\u0015\u0015\u0011!a\u0001\u0003{B1\"a$\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002~\u0005a1MU8x/J\f\u0007\u000f]3sA!Y\u00111\u0013\u0001A\u0002\u0003\u0007I\u0011BAK\u0003%\u0019w\u000e\u001c7fGR|'/\u0006\u0002\u0002\u0018B1\u0011\u0011TAS\u0003Sk!!a'\u000b\t\u0005u\u0015qT\u0001\n_B,'/\u0019;peNT1!IAQ\u0015\r\t\u0019\u000bC\u0001\ngR\u0014X-Y7j]\u001eLA!a*\u0002\u001c\n!B+[7fgR\fW\u000e]3e\u0007>dG.Z2u_J\u0004B!a+\u000206\u0011\u0011Q\u0016\u0006\u0003O\u0011IA!!-\u0002.\n!1IU8x\u0011-\t)\f\u0001a\u0001\u0002\u0004%I!a.\u0002\u001b\r|G\u000e\\3di>\u0014x\fJ3r)\u0011\t\t$!/\t\u0015\u0005e\u00121WA\u0001\u0002\u0004\t9\nC\u0006\u0002>\u0002\u0001\r\u0011!Q!\n\u0005]\u0015AC2pY2,7\r^8sA!Y\u0011\u0011\u0019\u0001A\u0002\u0003\u0007I\u0011BAb\u00031Qw.\u001b8Gk:\u001cG/[8o+\u0005Q\u0002bCAd\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013\f\u0001C[8j]\u001a+hn\u0019;j_:|F%Z9\u0015\t\u0005E\u00121\u001a\u0005\n\u0003s\t)-!AA\u0002iA!\"a4\u0001\u0001\u0004\u0005\t\u0015)\u0003\u001b\u00035Qw.\u001b8Gk:\u001cG/[8oA!9\u00111\u001b\u0001\u0005B\u0005U\u0017\u0001B8qK:$\"!!\r\t\u000f\u0005e\u0007\u0001\"\u0011\u0002\\\u0006y\u0001O]8dKN\u001cX\t\\3nK:$\u0018\u0007\u0006\u0003\u00022\u0005u\u0007\u0002CAp\u0003/\u0004\r!!9\u0002\u000f\u0015dW-\\3oiB1\u00111]Av\u0003Sk!!!:\u000b\t\u0005\u001d\u0018\u0011^\u0001\rgR\u0014X-Y7sK\u000e|'\u000f\u001a\u0006\u0004\u000b\u0005\u0005\u0016\u0002BAw\u0003K\u0014Ab\u0015;sK\u0006l'+Z2pe\u0012Dq!!=\u0001\t\u0003\n\u00190A\bqe>\u001cWm]:FY\u0016lWM\u001c;3)\u0011\t\t$!>\t\u0011\u0005}\u0017q\u001ea\u0001\u0003CDq!!?\u0001\t\u0003\nY0A\u0006p]\u00163XM\u001c;US6,G\u0003BA\u0019\u0003{D\u0001\"a@\u0002x\u0002\u0007!\u0011A\u0001\u0006i&lWM\u001d\t\t\u00033\u0013\u0019Aa\u0002\u0003\u000e%!!QAAN\u00055Ie\u000e^3s]\u0006dG+[7feB\u0019QK!\u0003\n\u0007\t-!IA\u0002B]f\u0004BAa\u0004\u0003\u00165\u0011!\u0011\u0003\u0006\u0005\u0003?\u0011\u0019B\u0003\u0002\u0006\u0011%!!q\u0003B\t\u000551v.\u001b3OC6,7\u000f]1dK\"9!1\u0004\u0001\u0005B\u0005U\u0017!B2m_N,\u0007b\u0002B\u0010\u0001\u0011%!\u0011E\u0001\u0016e\u0016<\u0017n\u001d;feNk\u0017\r\u001c7fgR$\u0016.\\3s)\u0011\t\tDa\t\t\u0011\t\u0015\"Q\u0004a\u0001\u0005O\t\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0007U\u0013I#C\u0002\u0002*\tCqA!\f\u0001\t\u0013\u0011y#A\u0007sK\u001eL7\u000f^3s)&lWM\u001d\u000b\u0005\u0003c\u0011\t\u0004\u0003\u0005\u0003&\t-\u0002\u0019\u0001B\u0014\u0011\u001d\u0011)\u0004\u0001C\u0005\u0005o\t\u0011$Z7jiJ+7/\u001e7u\u0003:$7\t\\3b]V\u00038\u000b^1uKR!!q\u0005B\u001d\u0011!\u0011YDa\rA\u0002\t\u001d\u0012A\u0004;j[\u0016\u0014H+[7fgR\fW\u000e\u001d\u0005\b\u0005\u007f\u0001A\u0011\u0002B!\u00031\u0019G.Z1o+B\u001cF/\u0019;f)\u0019\t\tDa\u0011\u0003F!A!1\bB\u001f\u0001\u0004\u00119\u0003\u0003\u0005\u0003H\tu\u0002\u0019\u0001B%\u0003=\u0011\u0018n\u001a5u%><8oU8si\u0016$\u0007#\u0002B&\u0005\u001f\"SB\u0001B'\u0015\tiC.\u0003\u0003\u0003R\t5#\u0001\u0002'jgRDqAa\u0010\u0001\t\u0003\u0012)\u0006\u0006\u0003\u00022\t]\u0003\u0002\u0003B-\u0005'\u0002\rAa\n\u0002\tQLW.\u001a\u0005\b\u0005;\u0002A\u0011\u0002B0\u0003A1\u0017N]:u\u0013:$W\r\u001f+p\u0017\u0016,\u0007\u000fF\u0003U\u0005C\u0012\u0019\u0007\u0003\u0005\u0003<\tm\u0003\u0019\u0001B\u0014\u0011!\u00119Ea\u0017A\u0002\t%\u0003b\u0002B4\u0001\u0011%!\u0011N\u0001\"S:$W\r_(g\r&\u00148\u000f^#mK6,g\u000e\u001e(fo\u0016\u0014H\u000b[1o)&lWM\u001d\u000b\u0006)\n-$Q\u000e\u0005\t\u0005w\u0011)\u00071\u0001\u0003(!A!q\u000eB3\u0001\u0004\u0011I%\u0001\u0003mSN$\bb\u0002B:\u0001\u0011%!QO\u0001\u0015Y\u0006$Xm\u001d;SS\u001eDGOU8x)>Tu.\u001b8\u0015\r\t]$Q\u0010B@!\u0015\u0011YE!\u001f%\u0013\u0011\u0011YH!\u0014\u0003\u0011=\u0003H/[8oC2D\u0001Ba\u0012\u0003r\u0001\u0007!\u0011\n\u0005\t\u0005\u0003\u0013\t\b1\u0001\u0003(\u0005AA.\u001a4u)&lW\rC\u0004\u0003t\u0001!IA!\"\u0015\u0015\t]$q\u0011BE\u0005\u001b\u0013\t\n\u0003\u0005\u0003H\t\r\u0005\u0019\u0001B%\u0011\u001d\u0011YIa!A\u0002Q\u000b1\u0001\\8x\u0011\u001d\u0011yIa!A\u0002Q\u000bA\u0001[5hQ\"A!\u0011\u0011BB\u0001\u0004\u00119\u0003C\u0004\u0003\u0016\u0002!IAa&\u0002%\u001d,GOU5hQR\u0014vn^:T_J$X\r\u001a\u000b\u0005\u0005\u0013\u0012I\n\u0003\u0005\u0003\u001c\nM\u0005\u0019AA\u0005\u0003E\u0011xn\u001e;j[\u0016\u001cu.\u001c9be\u0006$xN\u001d\u0005\b\u0005?\u0003A\u0011\u0002BQ\u0003A9W\r\u001e(fqRdUM\u001a;J]\u0012,\u00070\u0006\u0002\u0002&!9!Q\u0015\u0001\u0005\n\t\u001d\u0016aC4fi2+g\r\u001e+j[\u0016$BAa\n\u0003*\"9!1\u0016BR\u0001\u0004!\u0013a\u00027fMR\u0014vn\u001e\u0005\b\u0005_\u0003A\u0011\u0002BY\u000319W\r\u001e*jO\"$H+[7f)\u0011\u00119Ca-\t\u000f\tU&Q\u0016a\u0001I\u0005A!/[4iiJ{w\u000fC\u0004\u0003:\u0002!IAa/\u0002%\rDWmY6O_R\u0014V\r\u001e:bGRLwN\u001c\u000b\u0005\u0003c\u0011i\f\u0003\u0005\u0002`\n]\u0006\u0019AAq\u0001")
public class TemporalRowtimeJoin
extends BaseTwoInputStreamOperatorWithStateRetention
implements Compiler<FlatJoinFunction<Row, Row, Row>>,
Logging {
    private final TypeInformation<Row> leftType;
    private final TypeInformation<Row> rightType;
    private final String genJoinFuncName;
    private final String genJoinFuncCode;
    private final int leftTimeAttribute;
    private final int rightTimeAttribute;
    private final String NEXT_LEFT_INDEX_STATE_NAME;
    private final String LEFT_STATE_NAME;
    private final String RIGHT_STATE_NAME;
    private final String REGISTERED_TIMER_STATE_NAME;
    private final String TIMERS_STATE_NAME;
    private final RowtimeComparator rightRowtimeComparator;
    private ValueState<Long> nextLeftIndex;
    private MapState<Long, Row> leftState;
    private MapState<Long, Row> rightState;
    private ValueState<Long> registeredTimer;
    private CRowWrappingCollector cRowWrapper;
    private TimestampedCollector<CRow> collector;
    private FlatJoinFunction<Row, Row, Row> joinFunction;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<FlatJoinFunction<Row, Row, Row>> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        TemporalRowtimeJoin temporalRowtimeJoin = this;
        synchronized (temporalRowtimeJoin) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private String NEXT_LEFT_INDEX_STATE_NAME() {
        return this.NEXT_LEFT_INDEX_STATE_NAME;
    }

    private String LEFT_STATE_NAME() {
        return this.LEFT_STATE_NAME;
    }

    private String RIGHT_STATE_NAME() {
        return this.RIGHT_STATE_NAME;
    }

    private String REGISTERED_TIMER_STATE_NAME() {
        return this.REGISTERED_TIMER_STATE_NAME;
    }

    private String TIMERS_STATE_NAME() {
        return this.TIMERS_STATE_NAME;
    }

    private RowtimeComparator rightRowtimeComparator() {
        return this.rightRowtimeComparator;
    }

    private ValueState<Long> nextLeftIndex() {
        return this.nextLeftIndex;
    }

    private void nextLeftIndex_$eq(ValueState<Long> x$1) {
        this.nextLeftIndex = x$1;
    }

    private MapState<Long, Row> leftState() {
        return this.leftState;
    }

    private void leftState_$eq(MapState<Long, Row> x$1) {
        this.leftState = x$1;
    }

    private MapState<Long, Row> rightState() {
        return this.rightState;
    }

    private void rightState_$eq(MapState<Long, Row> x$1) {
        this.rightState = x$1;
    }

    private ValueState<Long> registeredTimer() {
        return this.registeredTimer;
    }

    private void registeredTimer_$eq(ValueState<Long> x$1) {
        this.registeredTimer = x$1;
    }

    private CRowWrappingCollector cRowWrapper() {
        return this.cRowWrapper;
    }

    private void cRowWrapper_$eq(CRowWrappingCollector x$1) {
        this.cRowWrapper = x$1;
    }

    private TimestampedCollector<CRow> collector() {
        return this.collector;
    }

    private void collector_$eq(TimestampedCollector<CRow> x$1) {
        this.collector = x$1;
    }

    private FlatJoinFunction<Row, Row, Row> joinFunction() {
        return this.joinFunction;
    }

    private void joinFunction_$eq(FlatJoinFunction<Row, Row, Row> x$1) {
        this.joinFunction = x$1;
    }

    @Override
    public void open() {
        this.LOG().debug(new StringBuilder(38).append("Compiling FlatJoinFunction: ").append(this.genJoinFuncName).append(" \n\n Code:\n").append(this.genJoinFuncCode).toString());
        Class<FlatJoinFunction<Row, Row, Row>> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genJoinFuncName, this.genJoinFuncCode);
        this.LOG().debug("Instantiating FlatJoinFunction.");
        this.joinFunction_$eq(clazz.newInstance());
        FunctionUtils.setFunctionRuntimeContext(this.joinFunction(), (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.joinFunction(), (Configuration)new Configuration());
        this.nextLeftIndex_$eq((ValueState<Long>)this.getRuntimeContext().getState(new ValueStateDescriptor(this.NEXT_LEFT_INDEX_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO)));
        this.leftState_$eq((MapState<Long, Row>)this.getRuntimeContext().getMapState(new MapStateDescriptor(this.LEFT_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, this.leftType)));
        this.rightState_$eq((MapState<Long, Row>)this.getRuntimeContext().getMapState(new MapStateDescriptor(this.RIGHT_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, this.rightType)));
        this.registeredTimer_$eq((ValueState<Long>)this.getRuntimeContext().getState(new ValueStateDescriptor(this.REGISTERED_TIMER_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO)));
        this.collector_$eq((TimestampedCollector<CRow>)new TimestampedCollector(this.output));
        this.cRowWrapper_$eq(new CRowWrappingCollector());
        this.cRowWrapper().out_$eq((Collector<CRow>)this.collector());
        this.cRowWrapper().setChange(true);
        super.open();
    }

    public void processElement1(StreamRecord<CRow> element) {
        this.checkNotRetraction(element);
        this.leftState().put((Object)this.getNextLeftIndex(), (Object)((CRow)element.getValue()).row());
        this.registerSmallestTimer(this.getLeftTime(((CRow)element.getValue()).row()));
        this.registerProcessingCleanUpTimer();
    }

    public void processElement2(StreamRecord<CRow> element) {
        this.checkNotRetraction(element);
        long rowTime = this.getRightTime(((CRow)element.getValue()).row());
        this.rightState().put((Object)Predef$.MODULE$.long2Long(rowTime), (Object)((CRow)element.getValue()).row());
        this.registerSmallestTimer(rowTime);
        this.registerProcessingCleanUpTimer();
    }

    public void onEventTime(InternalTimer<Object, VoidNamespace> timer) {
        block3: {
            this.registeredTimer().clear();
            long lastUnprocessedTime = this.emitResultAndCleanUpState(this.timerService().currentWatermark());
            if (lastUnprocessedTime < Long.MAX_VALUE) {
                this.registerTimer(lastUnprocessedTime);
            }
            if (!this.stateCleaningEnabled()) break block3;
            if (lastUnprocessedTime < Long.MAX_VALUE || !this.rightState().isEmpty()) {
                this.registerProcessingCleanUpTimer();
            } else {
                this.cleanUpLastTimer();
            }
        }
    }

    public void close() {
        FunctionUtils.closeFunction(this.joinFunction());
    }

    private void registerSmallestTimer(long timestamp) {
        block1: {
            Long currentRegisteredTimer;
            block0: {
                currentRegisteredTimer = (Long)this.registeredTimer().value();
                if (currentRegisteredTimer != null) break block0;
                this.registerTimer(timestamp);
                break block1;
            }
            if (currentRegisteredTimer == null || Predef$.MODULE$.Long2long(currentRegisteredTimer) <= timestamp) break block1;
            this.timerService().deleteEventTimeTimer(Predef$.MODULE$.Long2long(currentRegisteredTimer));
            this.registerTimer(timestamp);
        }
    }

    private void registerTimer(long timestamp) {
        this.registeredTimer().update((Object)Predef$.MODULE$.long2Long(timestamp));
        this.timerService().registerEventTimeTimer(timestamp);
    }

    private long emitResultAndCleanUpState(long timerTimestamp) {
        List<Row> rightRowsSorted = this.getRightRowsSorted(this.rightRowtimeComparator());
        long lastUnprocessedTime = Long.MAX_VALUE;
        Iterator leftIterator = this.leftState().entries().iterator();
        while (leftIterator.hasNext()) {
            Map.Entry leftEntry = (Map.Entry)leftIterator.next();
            Row leftRow = (Row)leftEntry.getValue();
            long leftTime = this.getLeftTime(leftRow);
            if (leftTime <= timerTimestamp) {
                Optional<Row> rightRow = this.latestRightRowToJoin(rightRowsSorted, leftTime);
                if (rightRow.isPresent()) {
                    this.joinFunction().join((Object)leftRow, (Object)rightRow.get(), (Collector)this.cRowWrapper());
                }
                leftIterator.remove();
                continue;
            }
            lastUnprocessedTime = Math.min(lastUnprocessedTime, leftTime);
        }
        this.cleanUpState(timerTimestamp, rightRowsSorted);
        return lastUnprocessedTime;
    }

    private void cleanUpState(long timerTimestamp, List<Row> rightRowsSorted) {
        int indexToKeep = this.firstIndexToKeep(timerTimestamp, rightRowsSorted);
        for (int i = 0; i < indexToKeep; ++i) {
            long rightTime = this.getRightTime(rightRowsSorted.get(i));
            this.rightState().remove((Object)Predef$.MODULE$.long2Long(rightTime));
        }
    }

    @Override
    public void cleanUpState(long time) {
        this.leftState().clear();
        this.rightState().clear();
    }

    private int firstIndexToKeep(long timerTimestamp, List<Row> rightRowsSorted) {
        int firstIndexNewerThenTimer = this.indexOfFirstElementNewerThanTimer(timerTimestamp, rightRowsSorted);
        return firstIndexNewerThenTimer < 0 ? rightRowsSorted.size() - 1 : firstIndexNewerThenTimer - 1;
    }

    private int indexOfFirstElementNewerThanTimer(long timerTimestamp, List<Row> list) {
        ListIterator<Row> iter = list.listIterator();
        while (iter.hasNext()) {
            if (this.getRightTime(iter.next()) <= timerTimestamp) continue;
            return iter.previousIndex();
        }
        return -1;
    }

    private Optional<Row> latestRightRowToJoin(List<Row> rightRowsSorted, long leftTime) {
        return this.latestRightRowToJoin(rightRowsSorted, 0, rightRowsSorted.size() - 1, leftTime);
    }

    private Optional<Row> latestRightRowToJoin(List<Row> rightRowsSorted, int low, int high, long leftTime) {
        Optional<Row> optional;
        block3: {
            Row midRow;
            while (true) {
                if (low > high) {
                    optional = low - 1 < 0 ? Optional.empty() : Optional.of(rightRowsSorted.get(low - 1));
                    break block3;
                }
                int mid = low + high >>> 1;
                midRow = rightRowsSorted.get(mid);
                long midTime = this.getRightTime(midRow);
                int cmp = Predef$.MODULE$.long2Long(midTime).compareTo(Predef$.MODULE$.long2Long(leftTime));
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp <= 0) break;
                high = mid - 1;
            }
            optional = Optional.of(midRow);
        }
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    private List<Row> getRightRowsSorted(RowtimeComparator rowtimeComparator) {
        void var2_2;
        ArrayList<Row> rightRows = new ArrayList<Row>();
        JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable(this.rightState().values()).foreach((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)rightRows.add(row)));
        rightRows.sort(rowtimeComparator);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Long getNextLeftIndex() {
        void var1_1;
        Long index = (Long)this.nextLeftIndex().value();
        if (index == null) {
            index = Predef$.MODULE$.long2Long(0L);
        }
        this.nextLeftIndex().update((Object)Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(index) + 1L));
        return var1_1;
    }

    private long getLeftTime(Row leftRow) {
        return BoxesRunTime.unboxToLong((Object)leftRow.getField(this.leftTimeAttribute));
    }

    private long getRightTime(Row rightRow) {
        return BoxesRunTime.unboxToLong((Object)rightRow.getField(this.rightTimeAttribute));
    }

    private void checkNotRetraction(StreamRecord<CRow> element) {
        if (!((CRow)element.getValue()).change()) {
            throw new IllegalStateException(new StringBuilder(95).append("Retractions are not supported by [").append(TemporalRowtimeJoin.class.getSimpleName()).append("]. ").append("If this can happen it should be validated during planning!").toString());
        }
    }

    public TemporalRowtimeJoin(TypeInformation<Row> leftType, TypeInformation<Row> rightType, String genJoinFuncName, String genJoinFuncCode, StreamQueryConfig queryConfig, int leftTimeAttribute, int rightTimeAttribute) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.genJoinFuncName = genJoinFuncName;
        this.genJoinFuncCode = genJoinFuncCode;
        this.leftTimeAttribute = leftTimeAttribute;
        this.rightTimeAttribute = rightTimeAttribute;
        super(queryConfig);
        Compiler.$init$(this);
        Logging.$init$(this);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", leftType);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", rightType);
        this.NEXT_LEFT_INDEX_STATE_NAME = "next-index";
        this.LEFT_STATE_NAME = "left";
        this.RIGHT_STATE_NAME = "right";
        this.REGISTERED_TIMER_STATE_NAME = "timer";
        this.TIMERS_STATE_NAME = "timers";
        this.rightRowtimeComparator = new RowtimeComparator(rightTimeAttribute);
    }
}

