/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.io.Serializable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.RowComparator;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.runtime.aggregate.CollectionRowComparator;
import org.apache.flink.table.runtime.aggregate.ProcTimeSortProcessFunction;
import org.apache.flink.table.runtime.aggregate.RowTimeSortProcessFunction;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.runtime.types.CRowTypeInfo$;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SortUtil$ {
    public static SortUtil$ MODULE$;

    static {
        new SortUtil$();
    }

    public KeyedProcessFunction<Byte, CRow, CRow> createRowTimeSortFunction(RelCollation collationSort, RelDataType inputType, TypeInformation<Row> inputTypeInfo, ExecutionConfig execCfg) {
        None$ none$;
        Preconditions.checkArgument((collationSort.getFieldCollations().size() > 0 ? 1 : 0) != 0);
        int rowtimeIdx = collationSort.getFieldCollations().get(0).getFieldIndex();
        if (collationSort.getFieldCollations().size() > 1) {
            RowComparator rowComp = this.createRowComparator(inputType, (Seq<RelFieldCollation>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(collationSort.getFieldCollations()).asScala()).tail()), execCfg);
            none$ = new Some((Object)new CollectionRowComparator((TypeComparator<Row>)rowComp));
        } else {
            none$ = None$.MODULE$;
        }
        None$ collectionRowComparator = none$;
        CRowTypeInfo inputCRowType = CRowTypeInfo$.MODULE$.apply(inputTypeInfo);
        return new RowTimeSortProcessFunction<Byte>(inputCRowType, rowtimeIdx, (Option<CollectionRowComparator>)collectionRowComparator);
    }

    public KeyedProcessFunction<Byte, CRow, CRow> createProcTimeSortFunction(RelCollation collationSort, RelDataType inputType, TypeInformation<Row> inputTypeInfo, ExecutionConfig execCfg) {
        RowComparator rowComp = this.createRowComparator(inputType, (Seq<RelFieldCollation>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(collationSort.getFieldCollations()).asScala()).tail()), execCfg);
        CollectionRowComparator collectionRowComparator = new CollectionRowComparator((TypeComparator<Row>)rowComp);
        CRowTypeInfo inputCRowType = CRowTypeInfo$.MODULE$.apply(inputTypeInfo);
        return new ProcTimeSortProcessFunction<Byte>(inputCRowType, collectionRowComparator);
    }

    public RowComparator createRowComparator(RelDataType inputType, Seq<RelFieldCollation> fieldCollations, ExecutionConfig execConfig) {
        Seq sortFields = (Seq)fieldCollations.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.getFieldIndex()), Seq$.MODULE$.canBuildFrom());
        Seq sortDirections = (Seq)((TraversableLike)fieldCollations.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.direction, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SortUtil$.$anonfun$createRowComparator$3(x0$1)), Seq$.MODULE$.canBuildFrom());
        Seq fieldComps = (Seq)((TraversableLike)sortFields.zip((GenIterable)sortDirections, Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SortUtil$.$anonfun$createRowComparator$4(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            TypeComparator typeComparator;
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                int k = tuple2._1$mcI$sp();
                boolean o = tuple2._2$mcZ$sp();
                TypeInformation<?> typeInformation = FlinkTypeFactory$.MODULE$.toTypeInfo(inputType.getFieldList().get(k).getType());
                if (!(typeInformation instanceof AtomicType)) {
                    if (typeInformation != null) {
                        TypeInformation<?> typeInformation2 = typeInformation;
                        throw new TableException(new StringBuilder(35).append("Unsupported field type ").append(typeInformation2).append(" to sort on.").toString());
                    }
                    throw new MatchError(typeInformation);
                }
                TypeInformation<?> typeInformation3 = typeInformation;
                typeComparator = ((AtomicType)typeInformation3).createComparator(o, execConfig);
            } else {
                throw new MatchError((Object)tuple2);
            }
            TypeComparator typeComparator2 = typeComparator;
            return typeComparator2;
        }, Seq$.MODULE$.canBuildFrom());
        return new RowComparator(new RowSchema(inputType).arity(), (int[])sortFields.toArray(ClassTag$.MODULE$.Int()), (TypeComparator[])fieldComps.toArray(ClassTag$.MODULE$.apply(TypeComparator.class)), new TypeSerializer[0], (boolean[])sortDirections.toArray(ClassTag$.MODULE$.Boolean()));
    }

    public RelFieldCollation.Direction getFirstSortDirection(RelCollation collationSort) {
        Preconditions.checkArgument((collationSort.getFieldCollations().size() > 0 ? 1 : 0) != 0);
        return collationSort.getFieldCollations().get((int)0).direction;
    }

    public RelDataTypeField getFirstSortField(RelCollation collationSort, RelDataType rowType) {
        Preconditions.checkArgument((collationSort.getFieldCollations().size() > 0 ? 1 : 0) != 0);
        int idx = collationSort.getFieldCollations().get(0).getFieldIndex();
        return rowType.getFieldList().get(idx);
    }

    public Order directionToOrder(RelFieldCollation.Direction direction) {
        Order order;
        RelFieldCollation.Direction direction2 = direction;
        boolean bl = ((Object)((Object)RelFieldCollation.Direction.ASCENDING)).equals((Object)direction2) ? true : ((Object)((Object)RelFieldCollation.Direction.STRICTLY_ASCENDING)).equals((Object)direction2);
        if (bl) {
            order = Order.ASCENDING;
        } else {
            boolean bl2 = ((Object)((Object)RelFieldCollation.Direction.DESCENDING)).equals((Object)direction2) ? true : ((Object)((Object)RelFieldCollation.Direction.STRICTLY_DESCENDING)).equals((Object)direction2);
            if (bl2) {
                order = Order.DESCENDING;
            } else {
                throw new IllegalArgumentException("Unsupported direction.");
            }
        }
        return order;
    }

    public static final /* synthetic */ boolean $anonfun$createRowComparator$3(RelFieldCollation.Direction x0$1) {
        boolean bl;
        RelFieldCollation.Direction direction = x0$1;
        if (((Object)((Object)RelFieldCollation.Direction.ASCENDING)).equals((Object)direction)) {
            bl = true;
        } else if (((Object)((Object)RelFieldCollation.Direction.DESCENDING)).equals((Object)direction)) {
            bl = false;
        } else {
            throw new TableException("SQL/Table does not support such sorting");
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createRowComparator$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private SortUtil$() {
        MODULE$ = this;
    }
}

