/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\u0001\u0003\u0001=\u0011qCU8x)&lWMQ8v]\u0012,GMU1oO\u0016|e/\u001a:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001U\u0011\u0001cF\n\u0005\u0001EI#\u0007E\u0003\u0013'U\u00193%D\u0001\u0003\u0013\t!\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\t1*\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\u000bQL\b/Z:\n\u0005!*#\u0001B\"S_^\u00042AK\u00170\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u001d\u0019w\u000eZ3hK:L!AL\u0016\u0003\u0011\r{W\u000e]5mKJ\u0004\"A\u0005\u0019\n\u0005E\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tA!\u001e;jY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0011!I\u0004A!A!\u0002\u0013Q\u0014aD4f]\u0006;wM]3hCRLwN\\:\u0011\u0005)Z\u0014B\u0001\u001f,\u0005u9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]N4UO\\2uS>t\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \u0002)\u0005<wM]3hCRLwN\\*uCR,G+\u001f9f!\t\u0001u)D\u0001B\u0015\t\u00115)A\u0005usB,W\u000f^5mg*\u0011A)R\u0001\u0005U\u00064\u0018M\u0003\u0002G\u0011\u0005\u0019\u0011\r]5\n\u0005!\u000b%a\u0003*poRK\b/Z%oM>D\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IaS\u0001\rS:\u0004X\u000f\u001e*poRK\b/\u001a\t\u0003I1K!!T\u0013\u0003\u0019\r\u0013vn\u001e+za\u0016LeNZ8\t\u0011=\u0003!\u0011!Q\u0001\nA\u000bq\u0002\u001d:fG\u0016$\u0017N\\4PM\u001a\u001cX\r\u001e\t\u00037EK!A\u0015\u000f\u0003\t1{gn\u001a\u0005\t)\u0002\u0011\t\u0011)A\u0005+\u0006Q!o\\<US6,\u0017\n\u001a=\u0011\u0005m1\u0016BA,\u001d\u0005\rIe\u000e\u001e\u0005\t3\u0002\u0011\t\u0011)A\u00055\u0006Y\u0011/^3ss\u000e{gNZ5h!\tYV,D\u0001]\u0015\t1e!\u0003\u0002_9\n\t2\u000b\u001e:fC6\fV/\u001a:z\u0007>tg-[4\t\u000b\u0001\u0004A\u0011A1\u0002\rqJg.\u001b;?)\u001d\u00117\rZ3gO\"\u00042A\u0005\u0001\u0016\u0011\u0015It\f1\u0001;\u0011\u0015qt\f1\u0001@\u0011\u0015Qu\f1\u0001L\u0011\u0015yu\f1\u0001Q\u0011\u0015!v\f1\u0001V\u0011\u0015Iv\f1\u0001[\u0011%Q\u0007\u00011AA\u0002\u0013%1.\u0001\u0004pkR\u0004X\u000f^\u000b\u0002G!IQ\u000e\u0001a\u0001\u0002\u0004%IA\\\u0001\u000b_V$\b/\u001e;`I\u0015\fHCA8s!\tY\u0002/\u0003\u0002r9\t!QK\\5u\u0011\u001d\u0019H.!AA\u0002\r\n1\u0001\u001f\u00132\u0011%)\b\u00011A\u0001B\u0003&1%A\u0004pkR\u0004X\u000f\u001e\u0011\t\u0013]\u0004\u0001\u0019!a\u0001\n\u0013A\u0018!\u00067bgR$&/[4hKJLgn\u001a+t'R\fG/Z\u000b\u0002sB\u0019!p )\u000e\u0003mT!\u0001`?\u0002\u000bM$\u0018\r^3\u000b\u0005y,\u0015AB2p[6|g.C\u0002\u0002\u0002m\u0014!BV1mk\u0016\u001cF/\u0019;f\u0011-\t)\u0001\u0001a\u0001\u0002\u0004%I!a\u0002\u000231\f7\u000f\u001e+sS\u001e<WM]5oOR\u001b8\u000b^1uK~#S-\u001d\u000b\u0004_\u0006%\u0001\u0002C:\u0002\u0004\u0005\u0005\t\u0019A=\t\u0015\u00055\u0001\u00011A\u0001B\u0003&\u00110\u0001\fmCN$HK]5hO\u0016\u0014\u0018N\\4UgN#\u0018\r^3!\u0011-\t\t\u0002\u0001a\u0001\u0002\u0004%I!a\u0005\u0002!\u0005\u001c7-^7vY\u0006$xN]*uCR,WCAA\u000b!\u0011Qx0a\u0006\u0011\t\u0005e\u0011QD\u0007\u0003\u00037Q!A\n\u0005\n\t\u0005}\u00111\u0004\u0002\u0004%><\bbCA\u0012\u0001\u0001\u0007\t\u0019!C\u0005\u0003K\tA#Y2dk6,H.\u0019;peN#\u0018\r^3`I\u0015\fHcA8\u0002(!I1/!\t\u0002\u0002\u0003\u0007\u0011Q\u0003\u0005\f\u0003W\u0001\u0001\u0019!A!B\u0013\t)\"A\tbG\u000e,X.\u001e7bi>\u00148\u000b^1uK\u0002B1\"a\f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00022\u0005IA-\u0019;b'R\fG/Z\u000b\u0003\u0003g\u0001bA_A\u001b!\u0006e\u0012bAA\u001cw\nAQ*\u00199Ti\u0006$X\r\u0005\u0004\u0002<\u0005\u0005\u0013qC\u0007\u0003\u0003{Q1!NA \u0015\u0005!\u0015\u0002BA\"\u0003{\u0011A\u0001T5ti\"Y\u0011q\t\u0001A\u0002\u0003\u0007I\u0011BA%\u00035!\u0017\r^1Ti\u0006$Xm\u0018\u0013fcR\u0019q.a\u0013\t\u0013M\f)%!AA\u0002\u0005M\u0002bCA(\u0001\u0001\u0007\t\u0011)Q\u0005\u0003g\t!\u0002Z1uCN#\u0018\r^3!\u0011-\t\u0019\u0006\u0001a\u0001\u0002\u0004%I!!\u0016\u0002\u0011\u0019,hn\u0019;j_:,\u0012a\f\u0005\f\u00033\u0002\u0001\u0019!a\u0001\n\u0013\tY&\u0001\u0007gk:\u001cG/[8o?\u0012*\u0017\u000fF\u0002p\u0003;B\u0001b]A,\u0003\u0003\u0005\ra\f\u0005\u000b\u0003C\u0002\u0001\u0019!A!B\u0013y\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011\u001d\t)\u0007\u0001C!\u0003O\nAa\u001c9f]R\u0019q.!\u001b\t\u0011\u0005-\u00141\ra\u0001\u0003[\naaY8oM&<\u0007\u0003BA8\u0003kj!!!\u001d\u000b\u0007\u0005M\u0004\"A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003o\n\tHA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0003w\u0002A\u0011IA?\u00039\u0001(o\\2fgN,E.Z7f]R$ra\\A@\u0003\u0007\u000by\nC\u0004\u0002\u0002\u0006e\u0004\u0019A\u0012\u0002\r%t\u0007/\u001e;D\u0011!\t))!\u001fA\u0002\u0005\u001d\u0015aA2uqB!\u0011\u0011RAN!\u001d\tY)a&\u0016G\rj!!!$\u000b\t\u0005=\u0015\u0011S\u0001\nMVt7\r^5p]NT1ARAJ\u0015\r\t)\nC\u0001\ngR\u0014X-Y7j]\u001eLA!!'\u0002\u000e\n!2*Z=fIB\u0013xnY3tg\u001a+hn\u0019;j_:LA!!(\u0002\u0018\n91i\u001c8uKb$\b\u0002CAQ\u0003s\u0002\r!a)\u0002\u0007=,H\u000fE\u0003\u0002&\u0006%6%\u0004\u0002\u0002(*\u0011Q\u0007C\u0005\u0005\u0003W\u000b9KA\u0005D_2dWm\u0019;pe\"9\u0011q\u0016\u0001\u0005B\u0005E\u0016aB8o)&lWM\u001d\u000b\b_\u0006M\u0016qWA`\u0011\u001d\t),!,A\u0002A\u000b\u0011\u0002^5nKN$\u0018-\u001c9\t\u0011\u0005\u0015\u0015Q\u0016a\u0001\u0003s\u0003B!!#\u0002<&!\u0011QXAL\u00059ye\u000eV5nKJ\u001cuN\u001c;fqRD\u0001\"!)\u0002.\u0002\u0007\u00111\u0015\u0005\b\u0003\u0007\u0004A\u0011IAc\u0003\u0015\u0019Gn\\:f)\u0005y\u0007")
public class RowTimeBoundedRangeOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        RowTimeBoundedRangeOver rowTimeBoundedRangeOver = this;
        synchronized (rowTimeBoundedRangeOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(30).append("Compiling AggregateHelper: ").append(this.genAggregations.name()).append(" \n\n").append(new StringBuilder(6).append("Code:\n").append(this.genAggregations.code()).toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRangeOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        block2: {
            Row input = inputC.row();
            this.processCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
            long triggeringTs = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
            long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
            if (triggeringTs <= lastTriggeringTs) break block2;
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)triggeringTs));
            if (data != null) {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), (Object)data);
            } else {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            }
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled()) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            int dataListIndex = 0;
            boolean aggregatesIndex = false;
            if (accumulators == null) {
                accumulators = this.function().createAccumulators();
                aggregatesIndex = false;
            }
            Iterator iter = this.dataState().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                long dataTs = BoxesRunTime.unboxToLong(entry.getKey());
                long offset = timestamp - dataTs;
                if (offset <= this.precedingOffset) continue;
                List retractDataList = (List)entry.getValue();
                for (dataListIndex = 0; dataListIndex < retractDataList.size(); ++dataListIndex) {
                    Row retractRow = (Row)retractDataList.get(dataListIndex);
                    this.function().retract(accumulators, retractRow);
                }
                iter.remove();
            }
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                Row curRow = (Row)inputs.get(dataListIndex);
                this.function().accumulate(accumulators, curRow);
            }
            this.function().setAggregationResults(accumulators, this.output().row());
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                aggregatesIndex = false;
                this.function().setForwardedFields((Row)inputs.get(dataListIndex), this.output().row());
                out.collect((Object)this.output());
            }
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() {
        this.function().close();
    }

    public RowTimeBoundedRangeOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, int rowTimeIdx, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(queryConfig);
        Compiler.$init$(this);
        Logging.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

