/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u0001=\u0011q\u0003\u0015:pGRKW.\u001a\"pk:$W\r\u001a*poN|e/\u001a:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001U\u0011\u0001cF\n\u0005\u0001EI#\u0007E\u0003\u0013'U\u00193%D\u0001\u0003\u0013\t!\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\t1*\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\u000bQL\b/Z:\n\u0005!*#\u0001B\"S_^\u00042AK\u00170\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u001d\u0019w\u000eZ3hK:L!AL\u0016\u0003\u0011\r{W\u000e]5mKJ\u0004\"A\u0005\u0019\n\u0005E\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tA!\u001e;jY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0011!I\u0004A!A!\u0002\u0013Q\u0014aD4f]\u0006;wM]3hCRLwN\\:\u0011\u0005)Z\u0014B\u0001\u001f,\u0005u9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]N4UO\\2uS>t\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \u0002\u001fA\u0014XmY3eS:<wJ\u001a4tKR\u0004\"a\u0007!\n\u0005\u0005c\"\u0001\u0002'p]\u001eD\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001R\u0001\u0013C\u001e<'/Z4bi\u0016\u001cH+\u001f9f\u0013:4w\u000e\u0005\u0002F\u00196\taI\u0003\u0002H\u0011\u0006IA/\u001f9fkRLGn\u001d\u0006\u0003\u0013*\u000bAA[1wC*\u00111\nC\u0001\u0004CBL\u0017BA'G\u0005-\u0011vn\u001e+za\u0016LeNZ8\t\u0011=\u0003!\u0011!Q\u0001\nA\u000b\u0011\"\u001b8qkR$\u0016\u0010]3\u0011\u0007E36%D\u0001S\u0015\t\u0019F+\u0001\u0005usB,\u0017N\u001c4p\u0015\t)&*\u0001\u0004d_6lwN\\\u0005\u0003/J\u0013q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\t3\u0002\u0011\t\u0011)A\u00055\u0006Y\u0011/^3ss\u000e{gNZ5h!\tYV,D\u0001]\u0015\tYe!\u0003\u0002_9\n\t2\u000b\u001e:fC6\fV/\u001a:z\u0007>tg-[4\t\u000b\u0001\u0004A\u0011A1\u0002\rqJg.\u001b;?)\u0019\u00117\rZ3gOB\u0019!\u0003A\u000b\t\u000bez\u0006\u0019\u0001\u001e\t\u000byz\u0006\u0019A \t\u000b\r{\u0006\u0019\u0001#\t\u000b={\u0006\u0019\u0001)\t\u000be{\u0006\u0019\u0001.\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0013Q\u0017\u0001E1dGVlW\u000f\\1u_J\u001cF/\u0019;f+\u0005Y\u0007c\u00017pc6\tQN\u0003\u0002o)\u0006)1\u000f^1uK&\u0011\u0001/\u001c\u0002\u000b-\u0006dW/Z*uCR,\u0007C\u0001:u\u001b\u0005\u0019(B\u0001\u0014\t\u0013\t)8OA\u0002S_^D\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002=\u0002)\u0005\u001c7-^7vY\u0006$xN]*uCR,w\fJ3r)\tIH\u0010\u0005\u0002\u001cu&\u00111\u0010\b\u0002\u0005+:LG\u000fC\u0004~m\u0006\u0005\t\u0019A6\u0002\u0007a$\u0013\u0007C\u0005\u0000\u0001\u0001\u0007\t\u0011)Q\u0005W\u0006\t\u0012mY2v[Vd\u0017\r^8s'R\fG/\u001a\u0011\t\u0017\u0005\r\u0001\u00011AA\u0002\u0013%\u0011QA\u0001\fe><X*\u00199Ti\u0006$X-\u0006\u0002\u0002\bA1A.!\u0003@\u0003\u001bI1!a\u0003n\u0005!i\u0015\r]*uCR,\u0007#BA\b\u0003+\tXBAA\t\u0015\r)\u00141\u0003\u0006\u0002\u0013&!\u0011qCA\t\u0005\u0011a\u0015n\u001d;\t\u0017\u0005m\u0001\u00011AA\u0002\u0013%\u0011QD\u0001\u0010e><X*\u00199Ti\u0006$Xm\u0018\u0013fcR\u0019\u00110a\b\t\u0013u\fI\"!AA\u0002\u0005\u001d\u0001bCA\u0012\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000f\tAB]8x\u001b\u0006\u00048\u000b^1uK\u0002B1\"a\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002*\u00051q.\u001e;qkR,\u0012a\t\u0005\f\u0003[\u0001\u0001\u0019!a\u0001\n\u0013\ty#\u0001\u0006pkR\u0004X\u000f^0%KF$2!_A\u0019\u0011!i\u00181FA\u0001\u0002\u0004\u0019\u0003BCA\u001b\u0001\u0001\u0007\t\u0011)Q\u0005G\u00059q.\u001e;qkR\u0004\u0003bCA\u001d\u0001\u0001\u0007\t\u0019!C\u0005\u0003w\tAbY8v]R,'o\u0015;bi\u0016,\"!!\u0010\u0011\u00071|w\bC\u0006\u0002B\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0013\u0001E2pk:$XM]*uCR,w\fJ3r)\rI\u0018Q\t\u0005\n{\u0006}\u0012\u0011!a\u0001\u0003{A1\"!\u0013\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002>\u0005i1m\\;oi\u0016\u00148\u000b^1uK\u0002B1\"!\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002<\u0005y1/\\1mY\u0016\u001cH\u000fV:Ti\u0006$X\rC\u0006\u0002R\u0001\u0001\r\u00111A\u0005\n\u0005M\u0013aE:nC2dWm\u001d;UgN#\u0018\r^3`I\u0015\fHcA=\u0002V!IQ0a\u0014\u0002\u0002\u0003\u0007\u0011Q\b\u0005\f\u00033\u0002\u0001\u0019!A!B\u0013\ti$\u0001\tt[\u0006dG.Z:u)N\u001cF/\u0019;fA!Y\u0011Q\f\u0001A\u0002\u0003\u0007I\u0011BA0\u0003!1WO\\2uS>tW#A\u0018\t\u0017\u0005\r\u0004\u00011AA\u0002\u0013%\u0011QM\u0001\rMVt7\r^5p]~#S-\u001d\u000b\u0004s\u0006\u001d\u0004\u0002C?\u0002b\u0005\u0005\t\u0019A\u0018\t\u0015\u0005-\u0004\u00011A\u0001B\u0003&q&A\u0005gk:\u001cG/[8oA!9\u0011q\u000e\u0001\u0005B\u0005E\u0014\u0001B8qK:$2!_A:\u0011!\t)(!\u001cA\u0002\u0005]\u0014AB2p]\u001aLw\r\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\ti\bC\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005\u0005\u00151\u0010\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002\b\u0006q\u0001O]8dKN\u001cX\t\\3nK:$HcB=\u0002\n\u00065\u0015\u0011\u0016\u0005\b\u0003\u0017\u000b\u0019\t1\u0001$\u0003\u0019Ig\u000e];u\u0007\"A\u0011qRAB\u0001\u0004\t\t*A\u0002dib\u0004B!a%\u0002&B9\u0011QSAQ+\r\u001aSBAAL\u0015\u0011\tI*a'\u0002\u0013\u0019,hn\u0019;j_:\u001c(bA&\u0002\u001e*\u0019\u0011q\u0014\u0005\u0002\u0013M$(/Z1nS:<\u0017\u0002BAR\u0003/\u0013AcS3zK\u0012\u0004&o\\2fgN4UO\\2uS>t\u0017\u0002BAT\u0003C\u0013qaQ8oi\u0016DH\u000f\u0003\u0005\u0002,\u0006\r\u0005\u0019AAW\u0003\ryW\u000f\u001e\t\u0006\u0003_\u000b\u0019lI\u0007\u0003\u0003cS!!\u000e\u0005\n\t\u0005U\u0016\u0011\u0017\u0002\n\u0007>dG.Z2u_JDq!!/\u0001\t\u0003\nY,A\u0004p]RKW.\u001a:\u0015\u000fe\fi,!1\u0002J\"9\u0011qXA\\\u0001\u0004y\u0014!\u0003;j[\u0016\u001cH/Y7q\u0011!\ty)a.A\u0002\u0005\r\u0007\u0003BAJ\u0003\u000bLA!a2\u0002\"\nqqJ\u001c+j[\u0016\u00148i\u001c8uKb$\b\u0002CAV\u0003o\u0003\r!!,\t\u000f\u00055\u0007\u0001\"\u0011\u0002P\u0006)1\r\\8tKR\t\u0011\u0010")
public class ProcTimeBoundedRowsOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final long precedingOffset;
    private final RowTypeInfo aggregatesTypeInfo;
    private final TypeInformation<CRow> inputType;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private CRow output;
    private ValueState<Object> counterState;
    private ValueState<Object> smallestTsState;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        ProcTimeBoundedRowsOver procTimeBoundedRowsOver = this;
        synchronized (procTimeBoundedRowsOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> counterState() {
        return this.counterState;
    }

    private void counterState_$eq(ValueState<Object> x$1) {
        this.counterState = x$1;
    }

    private ValueState<Object> smallestTsState() {
        return this.smallestTsState;
    }

    private void smallestTsState_$eq(ValueState<Object> x$1) {
        this.smallestTsState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(30).append("Compiling AggregateHelper: ").append(this.genAggregations.name()).append(" \n\n").append(new StringBuilder(6).append("Code:\n").append(this.genAggregations.code()).toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("windowBufferMapState", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        ValueStateDescriptor aggregationStateDescriptor = new ValueStateDescriptor("aggregationState", (TypeInformation)this.aggregatesTypeInfo);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(aggregationStateDescriptor));
        ValueStateDescriptor processedCountDescriptor = new ValueStateDescriptor("processedCountState", Long.TYPE);
        this.counterState_$eq((ValueState<Object>)this.getRuntimeContext().getState(processedCountDescriptor));
        ValueStateDescriptor smallestTimestampDescriptor = new ValueStateDescriptor("smallestTSState", Long.TYPE);
        this.smallestTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(smallestTimestampDescriptor));
        this.initCleanupTimeState("ProcTimeBoundedRowsOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        long counter;
        long smallestTs;
        Row input = inputC.row();
        long currentTime = ctx.timerService().currentProcessingTime();
        this.processCleanupTimer(ctx, currentTime);
        Row accumulators = (Row)this.accumulatorState().value();
        if (accumulators == null) {
            accumulators = this.function().createAccumulators();
        }
        if ((smallestTs = BoxesRunTime.unboxToLong((Object)this.smallestTsState().value())) == 0L) {
            smallestTs = currentTime;
            this.smallestTsState().update((Object)BoxesRunTime.boxToLong((long)smallestTs));
        }
        if ((counter = BoxesRunTime.unboxToLong((Object)this.counterState().value())) == this.precedingOffset) {
            List retractList = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)smallestTs));
            Row retractRow = (Row)retractList.get(0);
            this.function().retract(accumulators, retractRow);
            retractList.remove(0);
            if (!retractList.isEmpty()) {
                this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)smallestTs), (Object)retractList);
            } else {
                this.rowMapState().remove((Object)BoxesRunTime.boxToLong((long)smallestTs));
                Iterator iter = this.rowMapState().keys().iterator();
                long currentTs = 0L;
                long newSmallestTs = Long.MAX_VALUE;
                while (iter.hasNext()) {
                    currentTs = BoxesRunTime.unboxToLong(iter.next());
                    if (currentTs >= newSmallestTs) continue;
                    newSmallestTs = currentTs;
                }
                this.smallestTsState().update((Object)BoxesRunTime.boxToLong((long)newSmallestTs));
            }
        } else {
            this.counterState().update((Object)BoxesRunTime.boxToLong((long)(++counter)));
        }
        this.function().setForwardedFields(input, this.output().row());
        this.function().accumulate(accumulators, input);
        this.function().setAggregationResults(accumulators, this.output().row());
        List currentTimeState = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)currentTime));
        if (currentTimeState != null) {
            currentTimeState.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)currentTime), (Object)currentTimeState);
        } else {
            ArrayList<Row> newList = new ArrayList<Row>();
            newList.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)currentTime), newList);
        }
        this.accumulatorState().update((Object)accumulators);
        out.collect((Object)this.output());
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        block0: {
            if (!this.stateCleaningEnabled()) break block0;
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState(), this.counterState(), this.smallestTsState()}));
            this.function().cleanup();
        }
    }

    public void close() {
        this.function().close();
    }

    public ProcTimeBoundedRowsOver(GeneratedAggregationsFunction genAggregations, long precedingOffset, RowTypeInfo aggregatesTypeInfo, TypeInformation<CRow> inputType, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.precedingOffset = precedingOffset;
        this.aggregatesTypeInfo = aggregatesTypeInfo;
        this.inputType = inputType;
        super(queryConfig);
        Compiler.$init$(this);
        Logging.$init$(this);
        Preconditions.checkArgument((precedingOffset > 0L ? 1 : 0) != 0);
    }
}

