/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u0001=\u0011\u0001\u0004\u0015:pGRKW.\u001a\"pk:$W\r\u001a*b]\u001e,wJ^3s\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001)\"\u0001E\f\u0014\t\u0001\t\u0012F\r\t\u0006%M)2eI\u0007\u0002\u0005%\u0011AC\u0001\u0002 !J|7-Z:t\rVt7\r^5p]^KG\u000f[\"mK\u0006tW\u000f]*uCR,\u0007C\u0001\f\u0018\u0019\u0001!Q\u0001\u0007\u0001C\u0002e\u0011\u0011aS\t\u00035\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011qAT8uQ&tw\r\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\u0004\u0003:L\bC\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0005\u0003\u0015!\u0018\u0010]3t\u0013\tASE\u0001\u0003D%><\bc\u0001\u0016._5\t1F\u0003\u0002-\r\u000591m\u001c3fO\u0016t\u0017B\u0001\u0018,\u0005!\u0019u.\u001c9jY\u0016\u0014\bC\u0001\n1\u0013\t\t$AA\u000bHK:,'/\u0019;fI\u0006;wM]3hCRLwN\\:\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U2\u0011\u0001B;uS2L!a\u000e\u001b\u0003\u000f1{wmZ5oO\"A\u0011\b\u0001B\u0001B\u0003%!(A\bhK:\fum\u001a:fO\u0006$\u0018n\u001c8t!\tQ3(\u0003\u0002=W\tir)\u001a8fe\u0006$X\rZ!hOJ,w-\u0019;j_:\u001ch)\u001e8di&|g\u000e\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0003U\u0001(/Z2fI&tw\rV5nK\n{WO\u001c3bef\u0004\"a\u0007!\n\u0005\u0005c\"\u0001\u0002'p]\u001eD\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001R\u0001\u0013C\u001e<'/Z4bi\u0016\u001cH+\u001f9f\u0013:4w\u000e\u0005\u0002F\u00196\taI\u0003\u0002H\u0011\u0006IA/\u001f9fkRLGn\u001d\u0006\u0003\u0013*\u000bAA[1wC*\u00111\nC\u0001\u0004CBL\u0017BA'G\u0005-\u0011vn\u001e+za\u0016LeNZ8\t\u0011=\u0003!\u0011!Q\u0001\nA\u000b\u0011\"\u001b8qkR$\u0016\u0010]3\u0011\u0007E36%D\u0001S\u0015\t\u0019F+\u0001\u0005usB,\u0017N\u001c4p\u0015\t)&*\u0001\u0004d_6lwN\\\u0005\u0003/J\u0013q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\t3\u0002\u0011\t\u0011)A\u00055\u0006Y\u0011/^3ss\u000e{gNZ5h!\tYV,D\u0001]\u0015\tYe!\u0003\u0002_9\n\t2\u000b\u001e:fC6\fV/\u001a:z\u0007>tg-[4\t\u000b\u0001\u0004A\u0011A1\u0002\rqJg.\u001b;?)\u0019\u00117\rZ3gOB\u0019!\u0003A\u000b\t\u000bez\u0006\u0019\u0001\u001e\t\u000byz\u0006\u0019A \t\u000b\r{\u0006\u0019\u0001#\t\u000b={\u0006\u0019\u0001)\t\u000be{\u0006\u0019\u0001.\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0013Q\u0017AB8viB,H/F\u0001$\u0011%a\u0007\u00011AA\u0002\u0013%Q.\u0001\u0006pkR\u0004X\u000f^0%KF$\"A\\9\u0011\u0005my\u0017B\u00019\u001d\u0005\u0011)f.\u001b;\t\u000fI\\\u0017\u0011!a\u0001G\u0005\u0019\u0001\u0010J\u0019\t\u0013Q\u0004\u0001\u0019!A!B\u0013\u0019\u0013aB8viB,H\u000f\t\u0005\nm\u0002\u0001\r\u00111A\u0005\n]\f\u0001#Y2dk6,H.\u0019;peN#\u0018\r^3\u0016\u0003a\u00042!\u001f?\u007f\u001b\u0005Q(BA>U\u0003\u0015\u0019H/\u0019;f\u0013\ti(P\u0001\u0006WC2,Xm\u0015;bi\u0016\u00042a`A\u0002\u001b\t\t\tA\u0003\u0002'\u0011%!\u0011QAA\u0001\u0005\r\u0011vn\u001e\u0005\f\u0003\u0013\u0001\u0001\u0019!a\u0001\n\u0013\tY!\u0001\u000bbG\u000e,X.\u001e7bi>\u00148\u000b^1uK~#S-\u001d\u000b\u0004]\u00065\u0001\u0002\u0003:\u0002\b\u0005\u0005\t\u0019\u0001=\t\u0015\u0005E\u0001\u00011A\u0001B\u0003&\u00010A\tbG\u000e,X.\u001e7bi>\u00148\u000b^1uK\u0002B1\"!\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0018\u0005Y!o\\<NCB\u001cF/\u0019;f+\t\tI\u0002\u0005\u0004z\u00037y\u0014qD\u0005\u0004\u0003;Q(\u0001C'baN#\u0018\r^3\u0011\u000b\u0005\u0005\u0012q\u0005@\u000e\u0005\u0005\r\"bA\u001b\u0002&)\t\u0011*\u0003\u0003\u0002*\u0005\r\"\u0001\u0002'jgRD1\"!\f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00020\u0005y!o\\<NCB\u001cF/\u0019;f?\u0012*\u0017\u000fF\u0002o\u0003cA\u0011B]A\u0016\u0003\u0003\u0005\r!!\u0007\t\u0017\u0005U\u0002\u00011A\u0001B\u0003&\u0011\u0011D\u0001\re><X*\u00199Ti\u0006$X\r\t\u0005\f\u0003s\u0001\u0001\u0019!a\u0001\n\u0013\tY$\u0001\u0005gk:\u001cG/[8o+\u0005y\u0003bCA \u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003\nABZ;oGRLwN\\0%KF$2A\\A\"\u0011!\u0011\u0018QHA\u0001\u0002\u0004y\u0003BCA$\u0001\u0001\u0007\t\u0011)Q\u0005_\u0005Ia-\u001e8di&|g\u000e\t\u0005\b\u0003\u0017\u0002A\u0011IA'\u0003\u0011y\u0007/\u001a8\u0015\u00079\fy\u0005\u0003\u0005\u0002R\u0005%\u0003\u0019AA*\u0003\u0019\u0019wN\u001c4jOB!\u0011QKA.\u001b\t\t9FC\u0002\u0002Z!\tQbY8oM&<WO]1uS>t\u0017\u0002BA/\u0003/\u0012QbQ8oM&<WO]1uS>t\u0007bBA1\u0001\u0011\u0005\u00131M\u0001\u000faJ|7-Z:t\u000b2,W.\u001a8u)\u001dq\u0017QMA5\u0003\u000bCq!a\u001a\u0002`\u0001\u00071%A\u0003j]B,H\u000f\u0003\u0005\u0002l\u0005}\u0003\u0019AA7\u0003\r\u0019G\u000f\u001f\t\u0005\u0003_\n\t\tE\u0004\u0002r\u0005uTcI\u0012\u000e\u0005\u0005M$\u0002BA;\u0003o\n\u0011BZ;oGRLwN\\:\u000b\u0007-\u000bIHC\u0002\u0002|!\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\t\u0005}\u00141\u000f\u0002\u0015\u0017\u0016LX\r\u001a)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\n\t\u0005\r\u0015Q\u0010\u0002\b\u0007>tG/\u001a=u\u0011!\t9)a\u0018A\u0002\u0005%\u0015aA8viB)\u00111RAHG5\u0011\u0011Q\u0012\u0006\u0003k!IA!!%\u0002\u000e\nI1i\u001c7mK\u000e$xN\u001d\u0005\b\u0003+\u0003A\u0011IAL\u0003\u001dyg\u000eV5nKJ$rA\\AM\u0003;\u000b)\u000bC\u0004\u0002\u001c\u0006M\u0005\u0019A \u0002\u0013QLW.Z:uC6\u0004\b\u0002CA6\u0003'\u0003\r!a(\u0011\t\u0005=\u0014\u0011U\u0005\u0005\u0003G\u000biH\u0001\bP]RKW.\u001a:D_:$X\r\u001f;\t\u0011\u0005\u001d\u00151\u0013a\u0001\u0003\u0013Cq!!+\u0001\t\u0003\nY+A\u0003dY>\u001cX\rF\u0001o\u0001")
public class ProcTimeBoundedRangeOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final long precedingTimeBoundary;
    private final RowTypeInfo aggregatesTypeInfo;
    private final TypeInformation<CRow> inputType;
    private CRow output;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        ProcTimeBoundedRangeOver procTimeBoundedRangeOver = this;
        synchronized (procTimeBoundedRangeOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(30).append("Compiling AggregateHelper: ").append(this.genAggregations.name()).append(" \n\n").append(new StringBuilder(6).append("Code:\n").append(this.genAggregations.code()).toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("rowmapstate", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("overState", (TypeInformation)this.aggregatesTypeInfo);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(stateDescriptor));
        this.initCleanupTimeState("ProcTimeBoundedRangeOverCleanupTime");
    }

    public void processElement(CRow input, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        long currentTime = ctx.timerService().currentProcessingTime();
        this.processCleanupTimer(ctx, currentTime);
        ArrayList<Row> rowList = (ArrayList<Row>)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)currentTime));
        if (rowList == null) {
            rowList = new ArrayList<Row>();
            ctx.timerService().registerProcessingTimeTimer(currentTime + 1L);
        }
        rowList.add(input.row());
        this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)currentTime), rowList);
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        int iElemenets;
        Long cleanupTime;
        if (this.stateCleaningEnabled() && (cleanupTime = (Long)this.cleanupTimeState().value()) != null && BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)timestamp), (Object)cleanupTime)) {
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState()}));
            this.function().cleanup();
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        long currentTime = timestamp - 1L;
        List currentElements = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)currentTime));
        if (currentElements == null) {
            return;
        }
        Row accumulators = (Row)this.accumulatorState().value();
        if (accumulators == null) {
            accumulators = this.function().createAccumulators();
        }
        long limit = currentTime - this.precedingTimeBoundary;
        Iterator iter = this.rowMapState().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            long elementKey = BoxesRunTime.unboxToLong(entry.getKey());
            if (elementKey >= limit) continue;
            List elementsRemove = (List)entry.getValue();
            for (int iRemove = 0; iRemove < elementsRemove.size(); ++iRemove) {
                Row retractRow = (Row)elementsRemove.get(iRemove);
                this.function().retract(accumulators, retractRow);
            }
            iter.remove();
        }
        for (iElemenets = 0; iElemenets < currentElements.size(); ++iElemenets) {
            Row input = (Row)currentElements.get(iElemenets);
            this.function().accumulate(accumulators, input);
        }
        for (iElemenets = 0; iElemenets < currentElements.size(); ++iElemenets) {
            Row input = (Row)currentElements.get(iElemenets);
            this.function().setForwardedFields(input, this.output().row());
            this.function().setAggregationResults(accumulators, this.output().row());
            out.collect((Object)this.output());
        }
        this.accumulatorState().update((Object)accumulators);
    }

    public void close() {
        this.function().close();
    }

    public ProcTimeBoundedRangeOver(GeneratedAggregationsFunction genAggregations, long precedingTimeBoundary, RowTypeInfo aggregatesTypeInfo, TypeInformation<CRow> inputType, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.precedingTimeBoundary = precedingTimeBoundary;
        this.aggregatesTypeInfo = aggregatesTypeInfo;
        this.inputType = inputType;
        super(queryConfig);
        Compiler.$init$(this);
        Logging.$init$(this);
    }
}

