/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner;

import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.codegen.GeneratedFunction;
import org.apache.flink.table.planner.Conversions$;
import org.apache.flink.table.runtime.CRowMapRunner;
import org.apache.flink.table.runtime.OutputRowtimeProcessFunction;
import org.apache.flink.table.runtime.conversion.CRowToJavaTupleMapFunction;
import org.apache.flink.table.runtime.conversion.CRowToJavaTupleMapRunner;
import org.apache.flink.table.runtime.conversion.CRowToRowMapFunction;
import org.apache.flink.table.runtime.conversion.CRowToScalaTupleMapFunction;
import org.apache.flink.table.runtime.conversion.CRowToScalaTupleMapRunner;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.runtime.types.CRowTypeInfo$;
import org.apache.flink.types.Row;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DataStreamConversions$ {
    public static DataStreamConversions$ MODULE$;

    static {
        new DataStreamConversions$();
    }

    public <A> DataStream<A> convert(DataStream<CRow> inputDataStream, TableSchema logicalType, boolean withChangeFlag, TypeInformation<A> requestedOutputType, TableConfig config) {
        Object object;
        Tuple2[] rowtimeFields = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logicalType.getFieldTypes())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])logicalType.getFieldNames()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType((TypeInformation)((Tuple2)f._1())._1())));
        if (rowtimeFields.length > 1) {
            throw new TableException(new StringBuilder(229).append("Found more than one rowtime field: [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowtimeFields)).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)((Tuple2)x$1._1())._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).append("] in ").append("the table that should be converted to a DataStream.\n").append("Please select the rowtime field that should be used as event-time timestamp for the ").append("DataStream by casting all other fields to TIMESTAMP.").toString());
        }
        if (rowtimeFields.length == 1) {
            RowTypeInfo origRowType = ((CRowTypeInfo)inputDataStream.getType()).rowType();
            TypeInformation[] convFieldTypes = (TypeInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])origRowType.getFieldTypes())).map((Function1 & Serializable & scala.Serializable)t -> FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType((TypeInformation<?>)t) ? SqlTimeTypeInfo.TIMESTAMP : t, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)));
            object = CRowTypeInfo$.MODULE$.apply((TypeInformation<Row>)new RowTypeInfo(convFieldTypes, origRowType.getFieldNames()));
        } else {
            object = inputDataStream.getType();
        }
        TypeInformation convType = object;
        MapFunction<CRow, A> conversion = withChangeFlag ? this.getConversionMapperWithChanges((TypeInformation<CRow>)convType, logicalType, requestedOutputType, "DataStreamSinkConversion", config) : this.getConversionMapper((TypeInformation<CRow>)convType, logicalType, requestedOutputType, "DataStreamSinkConversion", config);
        int rootParallelism = inputDataStream.getParallelism();
        SingleOutputStreamOperator withRowtime = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowtimeFields)).isEmpty() ? inputDataStream.map(conversion) : inputDataStream.process(new OutputRowtimeProcessFunction<A>(conversion, ((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowtimeFields)).head())._2$mcI$sp()));
        return withRowtime.returns(requestedOutputType).name(new StringBuilder(4).append("to: ").append(requestedOutputType.getTypeClass().getSimpleName()).toString()).setParallelism(rootParallelism);
    }

    private <OUT> MapFunction<CRow, OUT> getConversionMapper(TypeInformation<CRow> physicalInputType, TableSchema logicalInputSchema, TypeInformation<OUT> requestedOutputType, String functionName, TableConfig config) {
        Object object;
        Option<GeneratedFunction<MapFunction<Row, OUT>, OUT>> converterFunction = Conversions$.MODULE$.generateRowConverterFunction((TypeInformation<Row>)((CRowTypeInfo)physicalInputType).rowType(), logicalInputSchema, requestedOutputType, functionName, config);
        Option<GeneratedFunction<MapFunction<Row, OUT>, OUT>> option = converterFunction;
        if (option instanceof Some) {
            Some some = (Some)option;
            GeneratedFunction func = (GeneratedFunction)some.value();
            object = new CRowMapRunner(func.name(), func.code(), func.returnType());
        } else {
            object = new CRowToRowMapFunction();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private <OUT> MapFunction<CRow, OUT> getConversionMapperWithChanges(TypeInformation<CRow> physicalInputType, TableSchema logicalInputSchema, TypeInformation<OUT> requestedOutputType, String functionName, TableConfig config) {
        Object object;
        void var6_18;
        TypeInformation<OUT> typeInformation = requestedOutputType;
        if (typeInformation instanceof CaseClassTypeInfo) {
            CaseClassTypeInfo caseClassTypeInfo = (CaseClassTypeInfo)typeInformation;
            Class clazz = caseClassTypeInfo.getTypeClass();
            Class<Tuple2> clazz2 = Tuple2.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                TypeInformation typeInformation2 = caseClassTypeInfo.getTypeAt(0);
                TypeInformation typeInformation3 = Types.BOOLEAN();
                if (!(typeInformation2 != null ? !typeInformation2.equals(typeInformation3) : typeInformation3 != null)) {
                    Object object2;
                    TypeInformation reqType = caseClassTypeInfo.getTypeAt(1);
                    Option converterFunction = Conversions$.MODULE$.generateRowConverterFunction((TypeInformation<Row>)((CRowTypeInfo)physicalInputType).rowType(), logicalInputSchema, reqType, functionName, config);
                    Option option = converterFunction;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        GeneratedFunction func = (GeneratedFunction)some.value();
                        object2 = new CRowToScalaTupleMapRunner(func.name(), func.code(), requestedOutputType);
                    } else {
                        object2 = new CRowToScalaTupleMapFunction();
                    }
                    CRowToScalaTupleMapFunction cRowToScalaTupleMapFunction = object2;
                    return var6_18;
                }
            }
        }
        if (!(typeInformation instanceof TupleTypeInfo)) throw new MatchError(typeInformation);
        TupleTypeInfo tupleTypeInfo = (TupleTypeInfo)typeInformation;
        Class clazz = tupleTypeInfo.getTypeClass();
        Class<org.apache.flink.api.java.tuple.Tuple2> clazz3 = org.apache.flink.api.java.tuple.Tuple2.class;
        if (clazz == null) {
            if (clazz3 != null) {
                throw new MatchError(typeInformation);
            }
        } else if (!clazz.equals(clazz3)) throw new MatchError(typeInformation);
        TypeInformation typeInformation4 = tupleTypeInfo.getTypeAt(0);
        TypeInformation typeInformation5 = Types.BOOLEAN();
        if (typeInformation4 == null) {
            if (typeInformation5 != null) {
                throw new MatchError(typeInformation);
            }
        } else if (!typeInformation4.equals(typeInformation5)) throw new MatchError(typeInformation);
        TypeInformation reqType = tupleTypeInfo.getTypeAt(1);
        Option converterFunction = Conversions$.MODULE$.generateRowConverterFunction((TypeInformation<Row>)((CRowTypeInfo)physicalInputType).rowType(), logicalInputSchema, reqType, functionName, config);
        Option option = converterFunction;
        if (option instanceof Some) {
            Some some = (Some)option;
            GeneratedFunction func = (GeneratedFunction)some.value();
            object = new CRowToJavaTupleMapRunner(func.name(), func.code(), requestedOutputType);
        } else {
            object = new CRowToJavaTupleMapFunction();
        }
        CRowToJavaTupleMapFunction cRowToJavaTupleMapFunction = object;
        return var6_18;
    }

    private DataStreamConversions$() {
        MODULE$ = this;
    }
}

