/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.dataset;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapPartitionOperator;
import org.apache.flink.api.java.operators.PartitionOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.table.api.BatchQueryConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.BatchTableEnvImpl;
import org.apache.flink.table.plan.nodes.CommonSort;
import org.apache.flink.table.plan.nodes.FlinkRelNode;
import org.apache.flink.table.plan.nodes.dataset.DataSetRel;
import org.apache.flink.table.runtime.CountPartitionFunction;
import org.apache.flink.table.runtime.LimitFilterFunction;
import org.apache.flink.table.runtime.aggregate.SortUtil$;
import org.apache.flink.types.Row;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0001\u0003\u0001E\u00111\u0002R1uCN+GoU8si*\u00111\u0001B\u0001\bI\u0006$\u0018m]3u\u0015\t)a!A\u0003o_\u0012,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\n\u001b=A\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0004e\u0016d'BA\f\r\u0003\u001d\u0019\u0017\r\\2ji\u0016L!!\u0007\u000b\u0003\u0013MKgn\u001a7f%\u0016d\u0007CA\u000e\u001d\u001b\u0005!\u0011BA\u000f\u0005\u0005)\u0019u.\\7p]N{'\u000f\u001e\t\u0003?\u0001j\u0011AA\u0005\u0003C\t\u0011!\u0002R1uCN+GOU3m\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013aB2mkN$XM\u001d\t\u0003K\u001dj\u0011A\n\u0006\u0003\u000fYI!\u0001\u000b\u0014\u0003\u001bI+Gn\u00149u\u00072,8\u000f^3s\u0011!Q\u0003A!A!\u0002\u0013Y\u0013\u0001\u0003;sC&$8+\u001a;\u0011\u0005\u0015b\u0013BA\u0017'\u0005-\u0011V\r\u001c+sC&$8+\u001a;\t\u0011=\u0002!\u0011!Q\u0001\nA\n1!\u001b8q!\t\u0019\u0012'\u0003\u00023)\t9!+\u001a7O_\u0012,\u0007\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\u0015\r|G\u000e\\1uS>t7\u000f\u0005\u0002\u0014m%\u0011q\u0007\u0006\u0002\r%\u0016d7i\u001c7mCRLwN\u001c\u0005\ts\u0001\u0011\t\u0011)A\u0005u\u0005q!o\\<SK2$\u0015\r^1UsB,\u0007CA\u001e?\u001b\u0005a$BA\u001f\u0015\u0003\u0011!\u0018\u0010]3\n\u0005}b$a\u0003*fY\u0012\u000bG/\u0019+za\u0016D\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u0007_\u001a47/\u001a;\u0011\u0005\r3U\"\u0001#\u000b\u0005\u00153\u0012a\u0001:fq&\u0011q\t\u0012\u0002\b%\u0016Dhj\u001c3f\u0011!I\u0005A!A!\u0002\u0013\u0011\u0015!\u00024fi\u000eD\u0007\"B&\u0001\t\u0003a\u0015A\u0002\u001fj]&$h\b\u0006\u0005N\u001d>\u0003\u0016KU*U!\ty\u0002\u0001C\u0003$\u0015\u0002\u0007A\u0005C\u0003+\u0015\u0002\u00071\u0006C\u00030\u0015\u0002\u0007\u0001\u0007C\u00035\u0015\u0002\u0007Q\u0007C\u0003:\u0015\u0002\u0007!\bC\u0003B\u0015\u0002\u0007!\tC\u0003J\u0015\u0002\u0007!\tC\u0004W\u0001\t\u0007I\u0011B,\u0002\u00151LW.\u001b;Ti\u0006\u0014H/F\u0001Y!\tIF,D\u0001[\u0015\u0005Y\u0016!B:dC2\f\u0017BA/[\u0005\u0011auN\\4\t\r}\u0003\u0001\u0015!\u0003Y\u0003-a\u0017.\\5u'R\f'\u000f\u001e\u0011\t\u000f\u0005\u0004!\u0019!C\u0005/\u0006AA.[7ji\u0016sG\r\u0003\u0004d\u0001\u0001\u0006I\u0001W\u0001\nY&l\u0017\u000e^#oI\u0002BQ!\u001a\u0001\u0005B\u0019\fQ\u0002Z3sSZ,'k\\<UsB,G#\u0001\u001e\t\u000b!\u0004A\u0011I5\u0002\t\r|\u0007/\u001f\u000b\u0004a)\\\u0007\"\u0002\u0016h\u0001\u0004Y\u0003\"\u00027h\u0001\u0004i\u0017AB5oaV$8\u000fE\u0002ogBj\u0011a\u001c\u0006\u0003aF\fA!\u001e;jY*\t!/\u0001\u0003kCZ\f\u0017B\u0001;p\u0005\u0011a\u0015n\u001d;\t\u000bY\u0004A\u0011I<\u0002!\u0015\u001cH/[7bi\u0016\u0014vn^\"pk:$HC\u0001=|!\tI\u00160\u0003\u0002{5\n1Ai\\;cY\u0016DQ\u0001`;A\u0002u\f\u0001\"\\3uC\u0012\fG/\u0019\t\u0004}\u0006\u0005Q\"A@\u000b\u0005q$\u0012bAA\u0002\u007f\n\u0001\"+\u001a7NKR\fG-\u0019;b#V,'/\u001f\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0003=!(/\u00198tY\u0006$X\rV8QY\u0006tGCBA\u0006\u0003K\t9\u0004\u0005\u0004\u0002\u000e\u0005U\u0011\u0011D\u0007\u0003\u0003\u001fQ1A]A\t\u0015\r\t\u0019BC\u0001\u0004CBL\u0017\u0002BA\f\u0003\u001f\u0011q\u0001R1uCN+G\u000f\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tyBC\u0001\u0006if\u0004Xm]\u0005\u0005\u0003G\tiBA\u0002S_^D\u0001\"a\n\u0002\u0006\u0001\u0007\u0011\u0011F\u0001\ti\u0006\u0014G.Z#omB!\u00111FA\u001a\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0007\u0005M\u0001\"\u0003\u0003\u00026\u00055\"!\u0005\"bi\u000eDG+\u00192mK\u0016sg/S7qY\"A\u0011\u0011HA\u0003\u0001\u0004\tY$A\u0006rk\u0016\u0014\u0018pQ8oM&<\u0007\u0003BA\u001f\u0003\u007fi!!!\r\n\t\u0005\u0005\u0013\u0011\u0007\u0002\u0011\u0005\u0006$8\r[)vKJL8i\u001c8gS\u001eD\u0011\"!\u0012\u0001\u0005\u0004%I!a\u0012\u0002\u001f\u0019LW\r\u001c3D_2d\u0017\r^5p]N,\"!!\u0013\u0011\r\u0005-\u0013QKA-\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003'R\u0016AC2pY2,7\r^5p]&!\u0011qKA'\u0005\u0019\u0011UO\u001a4feB9\u0011,a\u0017\u0002`\u0005\u0015\u0014bAA/5\n1A+\u001e9mKJ\u00022!WA1\u0013\r\t\u0019G\u0017\u0002\u0004\u0013:$\b\u0003BA4\u0003cj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\n_B,'/\u0019;peNTA!a\u001c\u0002\u0012\u000511m\\7n_:LA!a\u001d\u0002j\t)qJ\u001d3fe\"A\u0011q\u000f\u0001!\u0002\u0013\tI%\u0001\tgS\u0016dGmQ8mY\u0006$\u0018n\u001c8tA!9\u00111\u0010\u0001\u0005B\u0005u\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0004\u0003BAA\u0003\u001fsA!a!\u0002\fB\u0019\u0011Q\u0011.\u000e\u0005\u0005\u001d%bAAE!\u00051AH]8pizJ1!!$[\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011SAJ\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0012.\t\u000f\u0005]\u0005\u0001\"\u0011\u0002\u001a\u0006aQ\r\u001f9mC&tG+\u001a:ngR!\u00111TAQ!\r\u0019\u0012QT\u0005\u0004\u0003?#\"!\u0003*fY^\u0013\u0018\u000e^3s\u0011!\t\u0019+!&A\u0002\u0005m\u0015A\u00019x\u0001")
public class DataSetSort
extends SingleRel
implements CommonSort,
DataSetRel {
    private final RelOptCluster cluster;
    private final RelNode inp;
    private final RelCollation collations;
    private final RelDataType rowRelDataType;
    private final RexNode offset;
    private final RexNode fetch;
    private final long limitStart;
    private final long limitEnd;
    private final Buffer<Tuple2<Object, Order>> fieldCollations;

    @Override
    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        return FlinkRelNode.getExpressionString$(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode.estimateRowSize$(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode.estimateDataTypeSize$(this, t);
    }

    @Override
    public long getFetchLimitEnd(RexNode fetch, RexNode offset) {
        return CommonSort.getFetchLimitEnd$(this, fetch, offset);
    }

    @Override
    public long getFetchLimitStart(RexNode offset) {
        return CommonSort.getFetchLimitStart$(this, offset);
    }

    @Override
    public String sortToString(RelDataType rowRelDataType, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch) {
        return CommonSort.sortToString$(this, rowRelDataType, sortCollation, sortOffset, sortFetch);
    }

    @Override
    public RelWriter sortExplainTerms(RelWriter pw, RelDataType rowRelDataType, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch) {
        return CommonSort.sortExplainTerms$(this, pw, rowRelDataType, sortCollation, sortOffset, sortFetch);
    }

    private long limitStart() {
        return this.limitStart;
    }

    private long limitEnd() {
        return this.limitEnd;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.rowRelDataType;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DataSetSort(this.cluster, traitSet, inputs.get(0), this.collations, this.getRowType(), this.offset, this.fetch);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double estimateRowCount(RelMetadataQuery metadata) {
        double d;
        Double inputRowCnt = metadata.getRowCount(this.getInput());
        if (inputRowCnt == null) {
            d = Predef$.MODULE$.Double2double(inputRowCnt);
        } else {
            double rowCount = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(Predef$.MODULE$.Double2double(inputRowCnt) - (double)this.limitStart()), 1.0);
            if (this.fetch != null) {
                int limit = RexLiteral.intValue(this.fetch);
                d = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(rowCount), (double)limit);
            } else {
                void var3_3;
                d = var3_3;
            }
        }
        return d;
    }

    @Override
    public DataSet<Row> translateToPlan(BatchTableEnvImpl tableEnv, BatchQueryConfig queryConfig) {
        DataSet dataSet;
        if (this.fieldCollations().isEmpty()) {
            throw new TableException("Limiting the result without sorting is not allowed as it could lead to arbitrary results.");
        }
        TableConfig config = tableEnv.getConfig();
        PartitionOperator inputDs = ((DataSetRel)this.inp).translateToPlan(tableEnv, queryConfig);
        int currentParallelism = inputDs.getExecutionEnvironment().getParallelism();
        ObjectRef partitionedDs = ObjectRef.create(currentParallelism == 1 ? inputDs : inputDs.partitionByRange((int[])((TraversableOnce)this.fieldCollations().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._1$mcI$sp()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int())).withOrders((Order[])((TraversableOnce)this.fieldCollations().map((Function1 & Serializable & scala.Serializable)x$2 -> (Order)x$2._2(), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Order.class))));
        this.fieldCollations().foreach((Function1 & Serializable & scala.Serializable)fieldCollation -> {
            partitionedDs.elem = ((DataSet)partitionedDs.elem).sortPartition(fieldCollation._1$mcI$sp(), (Order)fieldCollation._2());
            return BoxedUnit.UNIT;
        });
        if (this.offset == null && this.fetch == null) {
            dataSet = (DataSet)partitionedDs.elem;
        } else {
            CountPartitionFunction countFunction = new CountPartitionFunction();
            String partitionCountName = "prepare offset/fetch";
            MapPartitionOperator partitionCount = (MapPartitionOperator)((DataSet)partitionedDs.elem).mapPartition(countFunction).name(partitionCountName);
            String broadcastName = "countPartition";
            LimitFilterFunction limitFunction = new LimitFilterFunction(this.limitStart(), this.limitEnd(), broadcastName);
            String limitName = "offset: $offsetToString(offset), fetch: $fetchToString(fetch, offset))";
            dataSet = ((SingleInputUdfOperator)((DataSet)partitionedDs.elem).filter(limitFunction).name(limitName)).withBroadcastSet((DataSet)partitionCount, broadcastName);
        }
        return dataSet;
    }

    private Buffer<Tuple2<Object, Order>> fieldCollations() {
        return this.fieldCollations;
    }

    @Override
    public String toString() {
        return this.sortToString(this.getRowType(), this.collations, this.offset, this.fetch);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.sortExplainTerms(super.explainTerms(pw), this.getRowType(), this.collations, this.offset, this.fetch);
    }

    public DataSetSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode inp, RelCollation collations, RelDataType rowRelDataType, RexNode offset, RexNode fetch) {
        this.cluster = cluster;
        this.inp = inp;
        this.collations = collations;
        this.rowRelDataType = rowRelDataType;
        this.offset = offset;
        this.fetch = fetch;
        super(cluster, traitSet, inp);
        CommonSort.$init$(this);
        FlinkRelNode.$init$(this);
        this.limitStart = this.getFetchLimitStart(offset);
        this.limitEnd = this.getFetchLimitEnd(fetch, offset);
        this.fieldCollations = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(collations.getFieldCollations()).asScala()).map((Function1 & Serializable & scala.Serializable)c -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)c.getFieldIndex()), (Object)SortUtil$.MODULE$.directionToOrder(c.getDirection())), Buffer$.MODULE$.canBuildFrom());
    }
}

