/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dql;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlDescribeDatabase
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DESCRIBE DATABASE", SqlKind.OTHER);
    private final SqlIdentifier databaseName;
    private boolean isExtended = false;

    public SqlDescribeDatabase(SqlParserPos pos, SqlIdentifier databaseName, boolean isExtended) {
        super(pos);
        this.databaseName = databaseName;
        this.isExtended = isExtended;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Collections.singletonList(this.databaseName);
    }

    public String getDatabaseName() {
        return this.databaseName.getSimple();
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public String[] fullDatabaseName() {
        return this.databaseName.names.toArray(new String[0]);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DESCRIBE DATABASE");
        if (this.isExtended) {
            writer.keyword("EXTENDED");
        }
        this.databaseName.unparse(writer, leftPrec, rightPrec);
    }
}

