/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ExtendedSqlNode;

public class SqlDropView
extends SqlDrop
implements ExtendedSqlNode {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("DROP VIEW", SqlKind.DROP_VIEW);
    private final SqlIdentifier viewName;

    public SqlDropView(SqlParserPos pos, SqlIdentifier viewName, boolean ifExists) {
        super(OPERATOR, pos, ifExists);
        this.viewName = viewName;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.viewName);
    }

    public SqlIdentifier getViewName() {
        return this.viewName;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        writer.keyword("VIEW");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.viewName.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void validate() {
    }

    public String[] fullViewName() {
        return this.viewName.names.toArray(new String[0]);
    }
}

