/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;

public enum SqlLibrary {
    STANDARD(""),
    SPATIAL("s"),
    MYSQL("m"),
    ORACLE("o"),
    POSTGRESQL("p");

    public final String abbrev;
    public final String fun;
    public static final Map<String, SqlLibrary> MAP;

    private SqlLibrary(String abbrev) {
        this.abbrev = Objects.requireNonNull(abbrev);
        this.fun = this.name().toLowerCase(Locale.ROOT);
    }

    public static SqlLibrary of(String name) {
        return MAP.get(name);
    }

    public static List<SqlLibrary> parse(String libraryNameList) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (String libraryName : libraryNameList.split(",")) {
            list.add((Object)SqlLibrary.of(libraryName));
        }
        return list.build();
    }

    static {
        ImmutableMap.Builder<String, SqlLibrary> builder = ImmutableMap.builder();
        for (SqlLibrary value : SqlLibrary.values()) {
            builder.put(value.name(), value);
            builder.put(value.fun, value);
        }
        MAP = builder.build();
    }
}

