/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import org.apache.calcite.sql.SqlAbstractStringLiteral;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Util;

public class SqlCharStringLiteral
extends SqlAbstractStringLiteral {
    protected SqlCharStringLiteral(NlsString val, SqlParserPos pos) {
        super(val, SqlTypeName.CHAR, pos);
    }

    public NlsString getNlsString() {
        return (NlsString)this.value;
    }

    public SqlCollation getCollation() {
        return this.getNlsString().getCollation();
    }

    @Override
    public SqlCharStringLiteral clone(SqlParserPos pos) {
        return new SqlCharStringLiteral((NlsString)this.value, pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        assert (this.value instanceof NlsString);
        NlsString nlsString = (NlsString)this.value;
        writer.literal(nlsString.asSql(true, true, writer.getDialect()));
    }

    @Override
    protected SqlAbstractStringLiteral concat1(List<SqlLiteral> literals) {
        return new SqlCharStringLiteral(NlsString.concat(Util.transform(literals, literal -> ((SqlCharStringLiteral)literal).getNlsString())), literals.get(0).getParserPosition());
    }
}

