/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.convert;

import java.util.Locale;
import java.util.Objects;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.flink.calcite.shaded.com.google.common.base.Predicate;

public abstract class ConverterRule
extends RelOptRule {
    private final RelTrait inTrait;
    private final RelTrait outTrait;

    public ConverterRule(Class<? extends RelNode> clazz, RelTrait in, RelTrait out, String descriptionPrefix) {
        this(clazz, (? super R r) -> true, in, out, RelFactories.LOGICAL_BUILDER, descriptionPrefix);
    }

    @Deprecated
    public <R extends RelNode> ConverterRule(Class<R> clazz, Predicate<? super R> predicate, RelTrait in, RelTrait out, String descriptionPrefix) {
        this(clazz, predicate, in, out, RelFactories.LOGICAL_BUILDER, descriptionPrefix);
    }

    public <R extends RelNode> ConverterRule(Class<R> clazz, java.util.function.Predicate<? super R> predicate, RelTrait in, RelTrait out, RelBuilderFactory relBuilderFactory, String descriptionPrefix) {
        super(ConverterRule.convertOperand(clazz, predicate, in), relBuilderFactory, ConverterRule.createDescription(descriptionPrefix, in, out));
        this.inTrait = Objects.requireNonNull(in);
        this.outTrait = Objects.requireNonNull(out);
        assert (in.getTraitDef() == out.getTraitDef());
    }

    @Deprecated
    public <R extends RelNode> ConverterRule(Class<R> clazz, Predicate<? super R> predicate, RelTrait in, RelTrait out, RelBuilderFactory relBuilderFactory, String description) {
        this(clazz, predicate::apply, in, out, relBuilderFactory, description);
    }

    @Override
    public Convention getOutConvention() {
        return (Convention)this.outTrait;
    }

    @Override
    public RelTrait getOutTrait() {
        return this.outTrait;
    }

    public RelTrait getInTrait() {
        return this.inTrait;
    }

    public RelTraitDef getTraitDef() {
        return this.inTrait.getTraitDef();
    }

    private static String createDescription(String descriptionPrefix, RelTrait in, RelTrait out) {
        return String.format(Locale.ROOT, "%s(in:%s,out:%s)", Objects.toString(descriptionPrefix, "ConverterRule"), in, out);
    }

    public abstract RelNode convert(RelNode var1);

    public boolean isGuaranteed() {
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode converted;
        Object rel = call.rel(0);
        if (rel.getTraitSet().contains(this.inTrait) && (converted = this.convert((RelNode)rel)) != null) {
            call.transformTo(converted);
        }
    }
}

