/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class PlannerQueryOperation
implements QueryOperation {
    private final RelNode calciteTree;
    private final TableSchema tableSchema;

    public PlannerQueryOperation(RelNode calciteTree) {
        this.calciteTree = calciteTree;
        RelDataType rowType = calciteTree.getRowType();
        String[] fieldNames = rowType.getFieldNames().toArray(new String[0]);
        TypeInformation[] fieldTypes = (TypeInformation[])rowType.getFieldList().stream().map(field -> FlinkTypeFactory.toTypeInfo(field.getType())).toArray(TypeInformation[]::new);
        this.tableSchema = new TableSchema(fieldNames, fieldTypes);
    }

    public RelNode getCalciteTree() {
        return this.calciteTree;
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public String asSummaryString() {
        return OperationUtils.formatWithChildren((String)"PlannerNode", Collections.emptyMap(), this.getChildren(), Operation::asSummaryString);
    }

    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return (T)visitor.visit((QueryOperation)this);
    }
}

