/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.QueryOperationCatalogView;

@Internal
public class QueryOperationCatalogViewTable
extends AbstractTable
implements TranslatableTable {
    private final QueryOperationCatalogView catalogView;
    private final RelProtoDataType rowType;

    public static QueryOperationCatalogViewTable createCalciteTable(QueryOperationCatalogView catalogView) {
        return new QueryOperationCatalogViewTable(catalogView, typeFactory -> {
            TableSchema tableSchema = catalogView.getSchema();
            return ((FlinkTypeFactory)typeFactory).buildLogicalRowType(tableSchema);
        });
    }

    private QueryOperationCatalogViewTable(QueryOperationCatalogView catalogView, RelProtoDataType rowType) {
        this.catalogView = catalogView;
        this.rowType = rowType;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        FlinkRelBuilder relBuilder = FlinkRelBuilder.of(context.getCluster(), relOptTable);
        RelNode relNode = relBuilder.tableOperation(this.catalogView.getQueryOperation()).build();
        return RelOptUtil.createCastRel(relNode, (RelDataType)this.rowType.apply(relBuilder.getTypeFactory()), false);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.rowType.apply(typeFactory);
    }
}

