/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.util.Objects;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;

public class RelOptPredicateList {
    private static final ImmutableList<RexNode> EMPTY_LIST = ImmutableList.of();
    public static final RelOptPredicateList EMPTY = new RelOptPredicateList(EMPTY_LIST, EMPTY_LIST, EMPTY_LIST, ImmutableMap.of());
    public final ImmutableList<RexNode> pulledUpPredicates;
    public final ImmutableList<RexNode> leftInferredPredicates;
    public final ImmutableList<RexNode> rightInferredPredicates;
    public final ImmutableMap<RexNode, RexNode> constantMap;

    private RelOptPredicateList(ImmutableList<RexNode> pulledUpPredicates, ImmutableList<RexNode> leftInferredPredicates, ImmutableList<RexNode> rightInferredPredicates, ImmutableMap<RexNode, RexNode> constantMap) {
        this.pulledUpPredicates = Objects.requireNonNull(pulledUpPredicates);
        this.leftInferredPredicates = Objects.requireNonNull(leftInferredPredicates);
        this.rightInferredPredicates = Objects.requireNonNull(rightInferredPredicates);
        this.constantMap = Objects.requireNonNull(constantMap);
    }

    public static RelOptPredicateList of(RexBuilder rexBuilder, Iterable<RexNode> pulledUpPredicates) {
        ImmutableList<RexNode> pulledUpPredicatesList = ImmutableList.copyOf(pulledUpPredicates);
        if (pulledUpPredicatesList.isEmpty()) {
            return EMPTY;
        }
        return RelOptPredicateList.of(rexBuilder, pulledUpPredicatesList, EMPTY_LIST, EMPTY_LIST);
    }

    public static RelOptPredicateList of(RexBuilder rexBuilder, Iterable<RexNode> pulledUpPredicates, Iterable<RexNode> leftInferredPredicates, Iterable<RexNode> rightInferredPredicates) {
        ImmutableList<RexNode> pulledUpPredicatesList = ImmutableList.copyOf(pulledUpPredicates);
        ImmutableList<RexNode> leftInferredPredicateList = ImmutableList.copyOf(leftInferredPredicates);
        ImmutableList<RexNode> rightInferredPredicatesList = ImmutableList.copyOf(rightInferredPredicates);
        if (pulledUpPredicatesList.isEmpty() && leftInferredPredicateList.isEmpty() && rightInferredPredicatesList.isEmpty()) {
            return EMPTY;
        }
        ImmutableMap<RexNode, RexNode> constantMap = RexUtil.predicateConstants(RexNode.class, rexBuilder, pulledUpPredicatesList);
        return new RelOptPredicateList(pulledUpPredicatesList, leftInferredPredicateList, rightInferredPredicatesList, constantMap);
    }

    public RelOptPredicateList union(RexBuilder rexBuilder, RelOptPredicateList list) {
        if (this == EMPTY) {
            return list;
        }
        if (list == EMPTY) {
            return this;
        }
        return RelOptPredicateList.of(rexBuilder, RelOptPredicateList.concat(this.pulledUpPredicates, list.pulledUpPredicates), RelOptPredicateList.concat(this.leftInferredPredicates, list.leftInferredPredicates), RelOptPredicateList.concat(this.rightInferredPredicates, list.rightInferredPredicates));
    }

    private static <E> ImmutableList<E> concat(ImmutableList<E> list1, ImmutableList<E> list2) {
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(list1)).addAll(list2)).build();
    }

    public RelOptPredicateList shift(RexBuilder rexBuilder, int offset) {
        return RelOptPredicateList.of(rexBuilder, RexUtil.shift(this.pulledUpPredicates, offset), RexUtil.shift(this.leftInferredPredicates, offset), RexUtil.shift(this.rightInferredPredicates, offset));
    }
}

