/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.table.shaded.org.reflections.Reflections;
import org.apache.flink.table.shaded.org.reflections.scanners.Scanner;

public class ReflectionsUtil {
    public static <T> Set<Class<? extends T>> scanSubClasses(String packageName, Class<T> targetClass) {
        return ReflectionsUtil.scanSubClasses(packageName, targetClass, false, false);
    }

    public static <T> Set<Class<? extends T>> scanSubClasses(String packageName, Class<T> targetClass, boolean includingInterface, boolean includingAbstractClass) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        return reflections.getSubTypesOf(targetClass).stream().filter(c -> {
            if (c.isInterface()) {
                return includingInterface;
            }
            if (Modifier.isAbstract(c.getModifiers())) {
                return includingAbstractClass;
            }
            return true;
        }).collect(Collectors.toSet());
    }

    private ReflectionsUtil() {
    }
}

