/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.schema;

import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder$;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverterFactory;
import org.apache.flink.table.planner.catalog.CatalogSchemaTable;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001E\u0011\u0001\u0004T3hC\u000eL8)\u0019;bY><7k\\;sG\u0016$\u0016M\u00197f\u0015\t\u0019A!\u0001\u0004tG\",W.\u0019\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001)\"AE-\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0016\u001b\u0005\u0011\u0011B\u0001\f\u0003\u0005]1E.\u001b8l!J,\u0007/\u0019:j]\u001e$\u0016M\u00197f\u0005\u0006\u001cX\r\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u001a\u00031\u0011X\r\\(qiN\u001b\u0007.Z7b!\tQb$D\u0001\u001c\u0015\t)AD\u0003\u0002\u001e\u0019\u000591-\u00197dSR,\u0017BA\u0010\u001c\u00051\u0011V\r\\(qiN\u001b\u0007.Z7b\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013!\u00028b[\u0016\u001c\bcA\u0012)U5\tAE\u0003\u0002&M\u0005!Q\u000f^5m\u0015\u00059\u0013\u0001\u00026bm\u0006L!!\u000b\u0013\u0003\t1K7\u000f\u001e\t\u0003WEr!\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\na\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001'\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u00059!o\\<UsB,\u0007CA\u001c=\u001b\u0005A$BA\u001d;\u0003\u0011!\u0018\u0010]3\u000b\u0005mb\u0012a\u0001:fY&\u0011Q\b\u000f\u0002\f%\u0016dG)\u0019;b)f\u0004X\r\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001A\u0003-\u00198\r[3nCR\u000b'\r\\3\u0016\u0003\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001\u0012\u0004\u0002\u000f\r\fG/\u00197pO&\u0011ai\u0011\u0002\u0013\u0007\u0006$\u0018\r\\8h'\u000eDW-\\1UC\ndW\r\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003B\u00031\u00198\r[3nCR\u000b'\r\\3!\u0011!Q\u0005A!b\u0001\n\u0003Y\u0015\u0001D2bi\u0006dwn\u001a+bE2,W#\u0001'\u0011\u00055{U\"\u0001(\u000b\u0005\u0011C\u0011B\u0001)O\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0011!\u0011\u0006A!A!\u0002\u0013a\u0015!D2bi\u0006dwn\u001a+bE2,\u0007\u0005C\u0003U\u0001\u0011\u0005Q+\u0001\u0004=S:LGO\u0010\u000b\u0007-\n\u001cG-\u001a4\u0011\u0007Q\u0001q\u000b\u0005\u0002Y32\u0001A!\u0002.\u0001\u0005\u0004Y&!\u0001+\u0012\u0005q{\u0006C\u0001\u0017^\u0013\tqVFA\u0004O_RD\u0017N\\4\u0011\u00051\u0002\u0017BA1.\u0005\r\te.\u001f\u0005\u00061M\u0003\r!\u0007\u0005\u0006CM\u0003\rA\t\u0005\u0006kM\u0003\rA\u000e\u0005\u0006\u007fM\u0003\r!\u0011\u0005\u0006\u0015N\u0003\r\u0001\u0014\u0005\tQ\u0002A)\u0019!C\u0001S\u0006Y1m\u001c7v[:,\u0005\u0010\u001d:t+\u0005Q\u0007\u0003B\u0016lU)J!\u0001\\\u001a\u0003\u00075\u000b\u0007\u000f\u0003\u0005o\u0001!\u0005\t\u0015)\u0003k\u00031\u0019w\u000e\\;n]\u0016C\bO]:!\u0011\u0015\u0001\b\u0001\"\u0011r\u0003\u0015!xNU3m)\t\u0011h\u000f\u0005\u0002ti6\t!(\u0003\u0002vu\t9!+\u001a7O_\u0012,\u0007\"B<p\u0001\u0004A\u0018aB2p]R,\u0007\u0010\u001e\t\u0003srt!A\u0007>\n\u0005m\\\u0012a\u0003*fY>\u0003H\u000fV1cY\u0016L!! @\u0003\u0019Q{'+\u001a7D_:$X\r\u001f;\u000b\u0005m\\\u0002bBA\u0001\u0001\u0011%\u00111A\u0001\u001fM&tG-\u00118e\u0007J,\u0017\r^3MK\u001e\f7-\u001f+bE2,7k\\;sG\u0016$b!!\u0002\u0002\u0012\u0005u\u0002#BA\u0004\u0003\u001b9VBAA\u0005\u0015\r\tY\u0001C\u0001\bg>,(oY3t\u0013\u0011\ty!!\u0003\u0003\u0017Q\u000b'\r\\3T_V\u00148-\u001a\u0005\b\u0003'y\b\u0019AA\u000b\u00035A\u0017N\u001c;fI>\u0003H/[8ogB1\u0011qCA\u001cU)rA!!\u0007\u000249!\u00111DA\u0019\u001d\u0011\ti\"a\f\u000f\t\u0005}\u0011Q\u0006\b\u0005\u0003C\tYC\u0004\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9\u0003E\u0001\u0007yI|w\u000e\u001e \n\u0003=I!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"C\u0002\u00026\u0019\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002:\u0005m\"\u0001\u0002&NCBT1!!\u000e\u0007\u0011\u001d\tyd a\u0001\u0003\u0003\nAaY8oMB!\u00111IA%\u001b\t\t)EC\u0002\u0002H)\tQbY8oM&<WO]1uS>t\u0017\u0002BA&\u0003\u000b\u0012aBU3bI\u0006\u0014G.Z\"p]\u001aLw\rC\u0004\u0002P\u0001!I!!\u0015\u0002%\u0015\u0014\u0018m]3US6,\u0017J\u001c3jG\u0006$xN\u001d\u000b\bm\u0005M\u0013qKA3\u0011\u001d\t)&!\u0014A\u0002Y\n1B]3m\t\u0006$\u0018\rV=qK\"A\u0011\u0011LA'\u0001\u0004\tY&A\u0004gC\u000e$xN]=\u0011\t\u0005u\u0013\u0011M\u0007\u0003\u0003?R!!\b\u0004\n\t\u0005\r\u0014q\f\u0002\u0011\r2Lgn\u001b+za\u00164\u0015m\u0019;pefD\u0001\"a\u001a\u0002N\u0001\u0007\u0011\u0011N\u0001\fi\u0006\u0014G.Z*pkJ\u001cW\r\r\u0003\u0002l\u0005=\u0004CBA\u0004\u0003\u001b\ti\u0007E\u0002Y\u0003_\"1\"!\u001d\u0002f\u0005\u0005\t\u0011!B\u00017\n\u0019q\fJ\u0019")
public class LegacyCatalogSourceTable<T>
extends FlinkPreparingTableBase {
    private final RelOptSchema relOptSchema;
    private final RelDataType rowType;
    private final CatalogSchemaTable schemaTable;
    private final CatalogTable catalogTable;
    private scala.collection.immutable.Map<String, String> columnExprs;
    private volatile boolean bitmap$0;

    private scala.collection.immutable.Map columnExprs$lzycompute() {
        LegacyCatalogSourceTable legacyCatalogSourceTable = this;
        synchronized (legacyCatalogSourceTable) {
            if (!this.bitmap$0) {
                this.columnExprs = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(this.catalogTable().getSchema().getTableColumns()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Tuple2<String, String>> apply(TableColumn x0$1) {
                        Iterable iterable;
                        TableColumn tableColumn = x0$1;
                        if (tableColumn instanceof TableColumn.ComputedColumn) {
                            TableColumn.ComputedColumn computedColumn = (TableColumn.ComputedColumn)tableColumn;
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)computedColumn.getName(), (Object)computedColumn.getExpression())));
                        } else {
                            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        }
                        return iterable;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = true;
            }
            return this.columnExprs;
        }
    }

    public CatalogSchemaTable schemaTable() {
        return this.schemaTable;
    }

    public CatalogTable catalogTable() {
        return this.catalogTable;
    }

    public scala.collection.immutable.Map<String, String> columnExprs() {
        return this.bitmap$0 ? this.columnExprs : this.columnExprs$lzycompute();
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        Object object;
        Object object2;
        RelOptCluster cluster = context.getCluster();
        FlinkContext flinkContext = cluster.getPlanner().getContext().unwrap(FlinkContext.class);
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)cluster.getTypeFactory();
        Configuration conf = flinkContext.getTableConfig().getConfiguration();
        Map<String, String> hintedOptions = FlinkHints.getHintedOptions(context.getTableHints());
        if (JavaConversions$.MODULE$.mapAsScalaMap(hintedOptions).nonEmpty() && !conf.getBoolean(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED)) {
            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " hint is allowed only when "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"OPTIONS"}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED.key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is set to true"})).s((Seq)Nil$.MODULE$)).toString());
        }
        TableSource<T> tableSource = this.findAndCreateLegacyTableSource(hintedOptions, (ReadableConfig)conf);
        RelDataType actualRowType = this.eraseTimeIndicator(this.rowType, typeFactory, tableSource);
        LegacyTableSourceTable<T> tableSourceTable = new LegacyTableSourceTable<T>(this.relOptSchema, this.schemaTable().getTableIdentifier(), actualRowType, this.statistic, tableSource, this.schemaTable().isStreamingMode(), this.catalogTable(), hintedOptions);
        int[] physicalFields = (int[])((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(this.getRowType().getFieldList()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LegacyCatalogSourceTable $outer;

            public final boolean apply(RelDataTypeField f) {
                return !this.$outer.columnExprs().contains((Object)f.getName());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(RelDataTypeField f) {
                return f.getIndex();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        LegacyTableSourceTable<T> newRelTable = tableSourceTable.copy(tableSource, physicalFields);
        LogicalTableScan scan = LogicalTableScan.create(cluster, newRelTable, context.getTableHints());
        FlinkRelBuilder relBuilder = FlinkRelBuilder$.MODULE$.of(cluster, this.getRelOptSchema());
        relBuilder.push(scan);
        SqlExprToRexConverterFactory toRexFactory = flinkContext.getSqlExprToRexConverterFactory();
        Buffer fieldNames = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(actualRowType.getFieldNames()).asScala();
        if (this.columnExprs().nonEmpty()) {
            String[] fieldExprs = (String[])((TraversableOnce)fieldNames.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LegacyCatalogSourceTable $outer;

                public final String apply(String name) {
                    return this.$outer.columnExprs().contains((Object)name) ? (String)this.$outer.columnExprs().apply((Object)name) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
            RexNode[] rexNodes = toRexFactory.create(newRelTable.getRowType(), null).convertToRexNodes(fieldExprs);
            object2 = relBuilder.projectNamed(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.refArrayOps((Object[])rexNodes).toList()), JavaConversions$.MODULE$.bufferAsJavaList(fieldNames), true);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        Option watermarkSpec = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.catalogTable().getSchema().getWatermarkSpecs()).asScala()).headOption();
        if (this.schemaTable().isStreamingMode() && watermarkSpec.nonEmpty()) {
            if (TableSourceValidation.hasRowtimeAttribute(tableSource)) {
                throw new TableException("If watermark is specified in DDL, the underlying TableSource of connector shouldn't return an non-empty list of RowtimeAttributeDescriptor via DefinedRowtimeAttributes interface.");
            }
            String rowtime2 = ((WatermarkSpec)watermarkSpec.get()).getRowtimeAttribute();
            if (rowtime2.contains(".")) {
                throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Nested field '", "' as rowtime attribute is not supported right now."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowtime2})));
            }
            int rowtimeIndex = fieldNames.indexOf((Object)rowtime2);
            RexNode watermarkRexNode = toRexFactory.create(actualRowType, null).convertToRexNode(((WatermarkSpec)watermarkSpec.get()).getWatermarkExpr());
            object = relBuilder.watermark(rowtimeIndex, watermarkRexNode);
        } else {
            object = BoxedUnit.UNIT;
        }
        return relBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private TableSource<T> findAndCreateLegacyTableSource(Map<String, String> hintedOptions, ReadableConfig conf) {
        CatalogTable tableToFind = JavaConversions$.MODULE$.mapAsScalaMap(hintedOptions).nonEmpty() ? this.catalogTable().copy(FlinkHints.mergeTableOptions(hintedOptions, this.catalogTable().getOptions())) : this.catalogTable();
        TableSource tableSource = TableFactoryUtil.findAndCreateTableSource((Catalog)this.schemaTable().getCatalog().orElse(null), (ObjectIdentifier)this.schemaTable().getTableIdentifier(), (CatalogTable)tableToFind, (ReadableConfig)conf, (boolean)this.schemaTable().isTemporary());
        String tableName = this.schemaTable().getTableIdentifier().asSummaryString();
        TableSource tableSource2 = tableSource;
        if (tableSource2 instanceof StreamTableSource) {
            void var5_5;
            StreamTableSource streamTableSource = (StreamTableSource)tableSource2;
            if (this.schemaTable().isStreamingMode() || streamTableSource.isBounded()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return tableSource;
            }
            throw new ValidationException(new StringBuilder().append((Object)"Cannot query on an unbounded source in batch mode, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but '", "' is unbounded."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var5_5}))).toString());
        }
        throw new ValidationException("Catalog tables only support StreamTableSource and InputFormatTableSource");
    }

    private RelDataType eraseTimeIndicator(RelDataType relDataType, FlinkTypeFactory factory, TableSource<?> tableSource) {
        RelDataType relDataType2;
        boolean hasLegacyTimeAttributes;
        boolean bl = hasLegacyTimeAttributes = TableSourceValidation.hasRowtimeAttribute(tableSource) || TableSourceValidation.hasProctimeAttribute(tableSource);
        if (this.columnExprs().isEmpty() && this.catalogTable().getSchema().getWatermarkSpecs().isEmpty() && hasLegacyTimeAttributes) {
            relDataType2 = relDataType;
        } else {
            RowType logicalRowType = FlinkTypeFactory$.MODULE$.toLogicalRowType(relDataType);
            List fieldNames = logicalRowType.getFieldNames();
            Buffer fieldTypes = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(logicalRowType.getFields()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final LogicalType apply(RowType.RowField f) {
                    LogicalType logicalType;
                    if (FlinkTypeFactory$.MODULE$.isTimeIndicatorType(f.getType())) {
                        TimestampType timestampType;
                        LogicalType logicalType2 = f.getType();
                        if (logicalType2 instanceof TimestampType) {
                            TimestampType timestampType2 = (TimestampType)logicalType2;
                            timestampType = new TimestampType(timestampType2.isNullable(), TimestampKind.REGULAR, timestampType2.getPrecision());
                        } else {
                            if (!(logicalType2 instanceof LocalZonedTimestampType)) throw new ValidationException(new StringBuilder().append((Object)"The supported time indicator type are TIMESTAMP and TIMESTAMP_LTZ, but is ").append((Object)f.getType()).append((Object)".").toString());
                            LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)logicalType2;
                            timestampType = new LocalZonedTimestampType(localZonedTimestampType.isNullable(), TimestampKind.REGULAR, localZonedTimestampType.getPrecision());
                        }
                        logicalType = timestampType;
                        return logicalType;
                    } else {
                        logicalType = f.getType();
                    }
                    return logicalType;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            relDataType2 = factory.buildRelNodeRowType((Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(fieldNames).asScala()), (Seq<LogicalType>)fieldTypes);
        }
        return relDataType2;
    }

    public LegacyCatalogSourceTable(RelOptSchema relOptSchema, List<String> names, RelDataType rowType, CatalogSchemaTable schemaTable, CatalogTable catalogTable) {
        this.relOptSchema = relOptSchema;
        this.rowType = rowType;
        this.schemaTable = schemaTable;
        this.catalogTable = catalogTable;
        super(relOptSchema, rowType, names, schemaTable.getStatistic());
    }
}

