/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsFilterPushDown;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.plan.abilities.source.FilterPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor;
import org.apache.flink.table.planner.plan.utils.RexNodeToExpressionConverter;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import scala.Tuple2;

public abstract class PushFilterIntoSourceScanRuleBase
extends RelOptRule {
    public PushFilterIntoSourceScanRuleBase(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        TableConfig config = ShortcutUtils.unwrapContext(call.getPlanner()).getTableConfig();
        return config.getConfiguration().getBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_PREDICATE_PUSHDOWN_ENABLED);
    }

    protected List<RexNode> convertExpressionToRexNode(List<ResolvedExpression> expressions, RelBuilder relBuilder) {
        ExpressionConverter exprConverter = new ExpressionConverter(relBuilder);
        return expressions.stream().map(e -> (RexNode)e.accept((ExpressionVisitor)exprConverter)).collect(Collectors.toList());
    }

    protected RexNode createRemainingCondition(RelBuilder relBuilder, List<ResolvedExpression> expressions, RexNode[] unconvertedPredicates) {
        List<RexNode> remainingPredicates = this.convertExpressionToRexNode(expressions, relBuilder);
        remainingPredicates.addAll(Arrays.asList(unconvertedPredicates));
        return relBuilder.and(remainingPredicates);
    }

    protected Tuple2<SupportsFilterPushDown.Result, TableSourceTable> resolveFiltersAndCreateTableSourceTable(RexNode[] convertiblePredicates, TableSourceTable oldTableSourceTable, TableScan scan, RelBuilder relBuilder) {
        int originPredicatesSize = convertiblePredicates.length;
        DynamicTableSource newTableSource = oldTableSourceTable.tableSource().copy();
        SupportsFilterPushDown.Result result = FilterPushDownSpec.apply(Arrays.asList(convertiblePredicates), newTableSource, SourceAbilityContext.from(scan));
        relBuilder.push(scan);
        List<RexNode> acceptedPredicates = this.convertExpressionToRexNode(result.getAcceptedFilters(), relBuilder);
        FilterPushDownSpec filterPushDownSpec = new FilterPushDownSpec(acceptedPredicates);
        int updatedPredicatesSize = result.getRemainingFilters().size();
        TableSourceTable newTableSourceTable = oldTableSourceTable.copy(newTableSource, this.getNewFlinkStatistic(oldTableSourceTable, originPredicatesSize, updatedPredicatesSize), this.getNewExtraDigests(result.getAcceptedFilters()), new SourceAbilitySpec[]{filterPushDownSpec});
        return new Tuple2((Object)result, (Object)newTableSourceTable);
    }

    protected Tuple2<RexNode[], RexNode[]> extractPredicates(String[] inputNames, RexNode filterExpression, TableScan scan, RexBuilder rexBuilder) {
        FlinkContext context = ShortcutUtils.unwrapContext(scan);
        int maxCnfNodeCount = FlinkRelOptUtil.getMaxCnfNodeCount(scan);
        RexNodeToExpressionConverter converter = new RexNodeToExpressionConverter(rexBuilder, inputNames, context.getFunctionCatalog(), context.getCatalogManager(), TimeZone.getTimeZone(context.getTableConfig().getLocalTimeZone()));
        return RexNodeExtractor.extractConjunctiveConditions(filterExpression, maxCnfNodeCount, rexBuilder, converter);
    }

    protected boolean canPushdownFilter(TableSourceTable tableSourceTable) {
        return tableSourceTable != null && tableSourceTable.tableSource() instanceof SupportsFilterPushDown && Arrays.stream(tableSourceTable.abilitySpecs()).noneMatch(spec -> spec instanceof FilterPushDownSpec);
    }

    protected FlinkStatistic getNewFlinkStatistic(TableSourceTable tableSourceTable, int originPredicatesSize, int updatedPredicatesSize) {
        FlinkStatistic oldStatistic = tableSourceTable.getStatistic();
        FlinkStatistic newStatistic = originPredicatesSize == updatedPredicatesSize ? oldStatistic : (oldStatistic == FlinkStatistic.UNKNOWN() ? oldStatistic : FlinkStatistic.builder().statistic(oldStatistic).tableStats(null).build());
        return newStatistic;
    }

    protected String[] getNewExtraDigests(List<ResolvedExpression> acceptedFilters) {
        String extraDigest;
        if (!acceptedFilters.isEmpty()) {
            String pushedExpr = ((ResolvedExpression)acceptedFilters.stream().reduce((l, r) -> new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.AND, Arrays.asList(l, r), DataTypes.BOOLEAN())).get()).toString();
            extraDigest = "filter=[" + pushedExpr + "]";
        } else {
            extraDigest = "filter=[]";
        }
        return new String[]{extraDigest};
    }
}

