/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.common;

import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRel;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSnapshot;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.planner.plan.rules.common.CommonTemporalTableJoinRule;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.sources.LookupableTableSource;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;

public abstract class CommonTemporalTableJoinRule$class {
    public static boolean matches(CommonTemporalTableJoinRule $this, FlinkLogicalSnapshot snapshot) {
        RexFieldAccess rexFieldAccess;
        RexNode rexNode = snapshot.getPeriod();
        if (rexNode instanceof RexFieldAccess && (rexFieldAccess = (RexFieldAccess)rexNode).getType() instanceof TimeIndicatorRelDataType && rexFieldAccess.getReferenceExpr() instanceof RexCorrelVariable) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return true;
        }
        throw new TableException("Temporal table join currently only supports 'FOR SYSTEM_TIME AS OF' left table's time attribute field.");
    }

    public static boolean canConvertToLookupJoin(CommonTemporalTableJoinRule $this, FlinkLogicalSnapshot snapshot, FlinkLogicalRel snapshotInput) {
        Some some;
        TableScan scan;
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType = snapshot.getPeriod().getType();
        boolean bl = relDataType instanceof TimeIndicatorRelDataType && !(timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType).isEventTime();
        boolean isProcessingTime = bl;
        Option tableScan = CommonTemporalTableJoinRule$class.getTableScan($this, snapshotInput);
        Option option = tableScan;
        boolean bl2 = option instanceof Some ? CommonTemporalTableJoinRule$class.isTableSourceScan($this, scan = (TableScan)(some = (Some)option).x()) && CommonTemporalTableJoinRule$class.isLookupTableSource($this, scan) : false;
        boolean snapshotOnLookupSource = bl2;
        return isProcessingTime && snapshotOnLookupSource;
    }

    private static Option getTableScan(CommonTemporalTableJoinRule $this, RelNode snapshotInput) {
        Object object;
        RelNode relNode = snapshotInput;
        if (relNode instanceof TableScan) {
            TableScan tableScan = (TableScan)relNode;
            object = new Some((Object)tableScan);
        } else {
            LogicalProject logicalProject;
            object = relNode instanceof LogicalProject && $this.trimHep((logicalProject = (LogicalProject)relNode).getInput()) instanceof TableScan ? new Some((Object)((TableScan)$this.trimHep(logicalProject.getInput()))) : None$.MODULE$;
        }
        return object;
    }

    private static boolean isTableSourceScan(CommonTemporalTableJoinRule $this, RelNode relNode) {
        boolean bl;
        RelNode relNode2 = relNode;
        if (relNode2 instanceof LogicalTableScan) {
            LogicalTableScan logicalTableScan = (LogicalTableScan)relNode2;
            RelOptTable table = logicalTableScan.getTable();
            RelOptTable relOptTable = table;
            boolean bl2 = relOptTable instanceof LegacyTableSourceTable ? true : relOptTable instanceof TableSourceTable;
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            boolean bl4 = relNode2 instanceof FlinkLogicalLegacyTableSourceScan ? true : relNode2 instanceof FlinkLogicalTableSourceScan;
            bl = bl4;
        }
        return bl;
    }

    private static boolean isLookupTableSource(CommonTemporalTableJoinRule $this, RelNode relNode) {
        boolean bl;
        RelNode relNode2 = relNode;
        if (relNode2 instanceof FlinkLogicalLegacyTableSourceScan) {
            FlinkLogicalLegacyTableSourceScan flinkLogicalLegacyTableSourceScan = (FlinkLogicalLegacyTableSourceScan)relNode2;
            bl = flinkLogicalLegacyTableSourceScan.tableSource() instanceof LookupableTableSource;
        } else if (relNode2 instanceof FlinkLogicalTableSourceScan) {
            FlinkLogicalTableSourceScan flinkLogicalTableSourceScan = (FlinkLogicalTableSourceScan)relNode2;
            bl = flinkLogicalTableSourceScan.tableSource() instanceof LookupTableSource;
        } else if (relNode2 instanceof LogicalTableScan) {
            boolean bl2;
            LogicalTableScan logicalTableScan = (LogicalTableScan)relNode2;
            RelOptTable relOptTable = logicalTableScan.getTable();
            if (relOptTable instanceof LegacyTableSourceTable) {
                LegacyTableSourceTable legacyTableSourceTable = (LegacyTableSourceTable)relOptTable;
                bl2 = legacyTableSourceTable.tableSource() instanceof LookupableTableSource;
            } else if (relOptTable instanceof TableSourceTable) {
                TableSourceTable tableSourceTable = (TableSourceTable)relOptTable;
                bl2 = tableSourceTable.tableSource() instanceof LookupTableSource;
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public static RelNode trimHep(CommonTemporalTableJoinRule $this, RelNode node) {
        RelNode relNode;
        RelNode relNode2 = node;
        if (relNode2 instanceof HepRelVertex) {
            HepRelVertex hepRelVertex = (HepRelVertex)relNode2;
            relNode = hepRelVertex.getCurrentRel();
        } else {
            relNode = node;
        }
        return relNode;
    }

    public static void $init$(CommonTemporalTableJoinRule $this) {
    }
}

