/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGenerator;
import org.apache.flink.table.runtime.operators.wmassigners.WatermarkAssignerOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class StreamExecWatermarkAssigner
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String FIELD_NAME_WATERMARK_EXPR = "watermarkExpr";
    public static final String FIELD_NAME_ROWTIME_FIELD_INDEX = "rowtimeFieldIndex";
    @JsonProperty(value="watermarkExpr")
    private final RexNode watermarkExpr;
    @JsonProperty(value="rowtimeFieldIndex")
    private final int rowtimeFieldIndex;

    public StreamExecWatermarkAssigner(RexNode watermarkExpr, int rowtimeFieldIndex, InputProperty inputProperty, RowType outputType, String description) {
        this(watermarkExpr, rowtimeFieldIndex, StreamExecWatermarkAssigner.getNewNodeId(), Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecWatermarkAssigner(@JsonProperty(value="watermarkExpr") RexNode watermarkExpr, @JsonProperty(value="rowtimeFieldIndex") int rowtimeFieldIndex, @JsonProperty(value="id") int id, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.watermarkExpr = (RexNode)Preconditions.checkNotNull((Object)watermarkExpr);
        this.rowtimeFieldIndex = rowtimeFieldIndex;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        TableConfig tableConfig = planner.getTableConfig();
        GeneratedWatermarkGenerator watermarkGenerator = WatermarkGeneratorCodeGenerator.generateWatermarkGenerator(tableConfig, (RowType)inputEdge.getOutputType(), this.watermarkExpr, JavaScalaConversionUtil.toScala(Optional.empty()));
        long idleTimeout = ((Duration)tableConfig.getConfiguration().get(ExecutionConfigOptions.TABLE_EXEC_SOURCE_IDLE_TIMEOUT)).toMillis();
        WatermarkAssignerOperatorFactory operatorFactory = new WatermarkAssignerOperatorFactory(this.rowtimeFieldIndex, idleTimeout, watermarkGenerator);
        return new OneInputTransformation(inputTransform, this.getDescription(), (StreamOperatorFactory)operatorFactory, (TypeInformation)InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism());
    }
}

