/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.trait.MiniBatchInterval;
import org.apache.flink.table.planner.plan.trait.MiniBatchMode;
import org.apache.flink.table.runtime.operators.wmassigners.ProcTimeMiniBatchAssignerOperator;
import org.apache.flink.table.runtime.operators.wmassigners.RowTimeMiniBatchAssginerOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class StreamExecMiniBatchAssigner
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String FIELD_NAME_MINI_BATCH_INTERVAL = "miniBatchInterval";
    @JsonProperty(value="miniBatchInterval")
    private final MiniBatchInterval miniBatchInterval;

    public StreamExecMiniBatchAssigner(MiniBatchInterval miniBatchInterval, InputProperty inputProperty, RowType outputType, String description) {
        this(miniBatchInterval, StreamExecMiniBatchAssigner.getNewNodeId(), Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecMiniBatchAssigner(@JsonProperty(value="miniBatchInterval") MiniBatchInterval miniBatchInterval, @JsonProperty(value="id") int id, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, inputProperties, (LogicalType)outputType, description);
        this.miniBatchInterval = (MiniBatchInterval)Preconditions.checkNotNull((Object)miniBatchInterval);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ProcTimeMiniBatchAssignerOperator operator;
        Transformation<?> inputTransform = this.getInputEdges().get(0).translateToPlan(planner);
        if (this.miniBatchInterval.getMode() == MiniBatchMode.ProcTime) {
            operator = new ProcTimeMiniBatchAssignerOperator(this.miniBatchInterval.getInterval());
        } else if (this.miniBatchInterval.getMode() == MiniBatchMode.RowTime) {
            operator = new RowTimeMiniBatchAssginerOperator(this.miniBatchInterval.getInterval());
        } else {
            throw new TableException(String.format("MiniBatchAssigner shouldn't be in %s mode this is a bug, please file an issue.", new Object[]{this.miniBatchInterval.getMode()}));
        }
        return new OneInputTransformation(inputTransform, this.getDescription(), (OneInputStreamOperator)operator, (TypeInformation)InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism());
    }
}

