/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecAggregateBase;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.aggregate.MiniBatchIncrementalGroupAggFunction;
import org.apache.flink.table.runtime.operators.bundle.KeyedMapBundleOperator;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class StreamExecIncrementalGroupAggregate
extends StreamExecAggregateBase {
    public static final String FIELD_NAME_PARTIAL_AGG_GROUPING = "partialAggGrouping";
    public static final String FIELD_NAME_FINAL_AGG_GROUPING = "finalAggGrouping";
    public static final String FIELD_NAME_PARTIAL_ORIGINAL_AGG_CALLS = "partialOriginalAggCalls";
    public static final String FIELD_NAME_PARTIAL_AGG_CALL_NEED_RETRACTIONS = "partialAggCallNeedRetractions";
    public static final String FIELD_NAME_PARTIAL_LOCAL_AGG_INPUT_TYPE = "partialLocalAggInputRowType";
    public static final String FIELD_NAME_PARTIAL_AGG_NEED_RETRACTION = "partialAggNeedRetraction";
    @JsonProperty(value="partialAggGrouping")
    private final int[] partialAggGrouping;
    @JsonProperty(value="finalAggGrouping")
    private final int[] finalAggGrouping;
    @JsonProperty(value="partialOriginalAggCalls")
    private final AggregateCall[] partialOriginalAggCalls;
    @JsonProperty(value="partialAggCallNeedRetractions")
    private final boolean[] partialAggCallNeedRetractions;
    @JsonProperty(value="partialLocalAggInputRowType")
    @JsonSerialize(using=LogicalTypeJsonSerializer.class)
    @JsonDeserialize(using=LogicalTypeJsonDeserializer.class)
    private final RowType partialLocalAggInputType;
    @JsonProperty(value="partialAggNeedRetraction")
    private final boolean partialAggNeedRetraction;

    public StreamExecIncrementalGroupAggregate(int[] partialAggGrouping, int[] finalAggGrouping, AggregateCall[] partialOriginalAggCalls, boolean[] partialAggCallNeedRetractions, RowType partialLocalAggInputType, boolean partialAggNeedRetraction, InputProperty inputProperty, RowType outputType, String description) {
        this(partialAggGrouping, finalAggGrouping, partialOriginalAggCalls, partialAggCallNeedRetractions, partialLocalAggInputType, partialAggNeedRetraction, StreamExecIncrementalGroupAggregate.getNewNodeId(), Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecIncrementalGroupAggregate(@JsonProperty(value="partialAggGrouping") int[] partialAggGrouping, @JsonProperty(value="finalAggGrouping") int[] finalAggGrouping, @JsonProperty(value="partialOriginalAggCalls") AggregateCall[] partialOriginalAggCalls, @JsonProperty(value="partialAggCallNeedRetractions") boolean[] partialAggCallNeedRetractions, @JsonProperty(value="partialLocalAggInputRowType") RowType partialLocalAggInputType, @JsonProperty(value="partialAggNeedRetraction") boolean partialAggNeedRetraction, @JsonProperty(value="id") int id, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, inputProperties, (LogicalType)outputType, description);
        this.partialAggGrouping = (int[])Preconditions.checkNotNull((Object)partialAggGrouping);
        this.finalAggGrouping = (int[])Preconditions.checkNotNull((Object)finalAggGrouping);
        this.partialOriginalAggCalls = (AggregateCall[])Preconditions.checkNotNull((Object)partialOriginalAggCalls);
        this.partialAggCallNeedRetractions = (boolean[])Preconditions.checkNotNull((Object)partialAggCallNeedRetractions);
        Preconditions.checkArgument((partialOriginalAggCalls.length == partialAggCallNeedRetractions.length ? 1 : 0) != 0);
        this.partialLocalAggInputType = (RowType)Preconditions.checkNotNull((Object)partialLocalAggInputType);
        this.partialAggNeedRetraction = partialAggNeedRetraction;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        AggregateInfoList partialLocalAggInfoList = AggregateUtil.createPartialAggInfoList(this.partialLocalAggInputType, JavaScalaConversionUtil.toScala(Arrays.asList(this.partialOriginalAggCalls)), this.partialAggCallNeedRetractions, this.partialAggNeedRetraction, false);
        TableConfig config = planner.getTableConfig();
        GeneratedAggsHandleFunction partialAggsHandler = this.generateAggsHandler("PartialGroupAggsHandler", partialLocalAggInfoList, this.partialAggGrouping.length, partialLocalAggInfoList.getAccTypes(), config, planner.getRelBuilder(), true);
        AggregateInfoList incrementalAggInfo = AggregateUtil.createIncrementalAggInfoList(this.partialLocalAggInputType, JavaScalaConversionUtil.toScala(Arrays.asList(this.partialOriginalAggCalls)), this.partialAggCallNeedRetractions, this.partialAggNeedRetraction);
        GeneratedAggsHandleFunction finalAggsHandler = this.generateAggsHandler("FinalGroupAggsHandler", incrementalAggInfo, 0, partialLocalAggInfoList.getAccTypes(), config, planner.getRelBuilder(), false);
        RowDataKeySelector partialKeySelector = KeySelectorUtil.getRowDataSelector(this.partialAggGrouping, (InternalTypeInfo<RowData>)InternalTypeInfo.of((LogicalType)inputEdge.getOutputType()));
        RowDataKeySelector finalKeySelector = KeySelectorUtil.getRowDataSelector(this.finalAggGrouping, (InternalTypeInfo<RowData>)partialKeySelector.getProducedType());
        MiniBatchIncrementalGroupAggFunction aggFunction = new MiniBatchIncrementalGroupAggFunction(partialAggsHandler, finalAggsHandler, (KeySelector)finalKeySelector, config.getIdleStateRetention().toMillis());
        KeyedMapBundleOperator operator = new KeyedMapBundleOperator((MapBundleFunction)aggFunction, AggregateUtil.createMiniBatchTrigger(config));
        OneInputTransformation transform2 = new OneInputTransformation(inputTransform, this.getDescription(), (OneInputStreamOperator)operator, (TypeInformation)InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism());
        transform2.setStateKeySelector((KeySelector)partialKeySelector);
        transform2.setStateKeyType((TypeInformation)partialKeySelector.getProducedType());
        return transform2;
    }

    private GeneratedAggsHandleFunction generateAggsHandler(String name, AggregateInfoList aggInfoList, int mergedAccOffset, DataType[] mergedAccExternalTypes, TableConfig config, RelBuilder relBuilder, boolean inputFieldCopy) {
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(new CodeGeneratorContext(config), relBuilder, JavaScalaConversionUtil.toScala(this.partialLocalAggInputType.getChildren()), inputFieldCopy);
        return generator.needMerge(mergedAccOffset, true, mergedAccExternalTypes).generateAggsHandler(name, aggInfoList);
    }
}

