/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.OperatorCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.functions.sql.StreamRecordTimestampSqlFunction;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.utils.ScanUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;

public class StreamExecDataStreamScan
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
MultipleTransformationTranslator<RowData> {
    private final DataStream<?> dataStream;
    private final DataType sourceType;
    private final int[] fieldIndexes;
    private final String[] fieldNames;
    private final List<String> qualifiedName;

    public StreamExecDataStreamScan(DataStream<?> dataStream, DataType sourceType, int[] fieldIndexes, String[] fieldNames, List<String> qualifiedName, RowType outputType, String description) {
        super(Collections.emptyList(), (LogicalType)outputType, description);
        this.dataStream = dataStream;
        this.sourceType = sourceType;
        this.fieldIndexes = fieldIndexes;
        this.fieldNames = fieldNames;
        this.qualifiedName = qualifiedName;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        Transformation<RowData> transformation;
        Transformation<RowData> sourceTransform = this.dataStream.getTransformation();
        Optional<RexNode> rowtimeExpr = this.getRowtimeExpression(planner.getRelBuilder());
        if (rowtimeExpr.isPresent() || ScanUtil.needsConversion(this.sourceType)) {
            String resetElement;
            String extractElement;
            if (ScanUtil.hasTimeAttributeField(this.fieldIndexes)) {
                String elementTerm = OperatorCodeGenerator.ELEMENT();
                extractElement = String.format("ctx.%s = %s;", elementTerm, elementTerm);
                resetElement = String.format("ctx.%s = null;", elementTerm);
            } else {
                extractElement = "";
                resetElement = "";
            }
            CodeGeneratorContext ctx = new CodeGeneratorContext(planner.getTableConfig()).setOperatorBaseClass(TableStreamOperator.class);
            transformation = ScanUtil.convertToInternalRow(ctx, (Transformation<Object>)sourceTransform, this.fieldIndexes, this.sourceType, (RowType)this.getOutputType(), this.qualifiedName, JavaScalaConversionUtil.toScala(rowtimeExpr), extractElement, resetElement);
        } else {
            transformation = sourceTransform;
        }
        return transformation;
    }

    private Optional<RexNode> getRowtimeExpression(FlinkRelBuilder relBuilder) {
        RowType rowType;
        List fields2 = Arrays.stream(this.fieldIndexes).boxed().collect(Collectors.toList());
        if (!fields2.contains(-1)) {
            return Optional.empty();
        }
        String rowtimeField = this.fieldNames[fields2.indexOf(-1)];
        LogicalType logicalType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)this.sourceType);
        if (logicalType instanceof RowType && (rowType = (RowType)logicalType).getFieldNames().contains(rowtimeField) && TypeCheckUtils.isRowTime((LogicalType)rowType.getTypeAt(rowType.getFieldIndex(rowtimeField)))) {
            return Optional.empty();
        }
        return Optional.of(relBuilder.cast(relBuilder.call((SqlOperator)new StreamRecordTimestampSqlFunction(), new RexNode[0]), relBuilder.getTypeFactory().createFieldTypeFromLogicalType((LogicalType)new TimestampType(true, TimestampKind.ROWTIME, 3)).getSqlTypeName()));
    }

    public DataStream<?> getDataStream() {
        return this.dataStream;
    }
}

